/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.RenamePartitionDesc;

public class RenamePartitionHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        AlterPartitionMessage msg = this.deserializer.getAlterPartitionMessage(context.dmd.getPayload());
        String actualDbName = context.isDbNameEmpty() ? msg.getDB() : context.dbName;
        String actualTblName = context.isTableNameEmpty() ? msg.getTable() : context.tableName;
        LinkedHashMap<String, String> newPartSpec = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> oldPartSpec = new LinkedHashMap<String, String>();
        String tableName = actualDbName + "." + actualTblName;
        try {
            Table tblObj = msg.getTableObj();
            Iterator beforeIterator = msg.getPtnObjBefore().getValuesIterator();
            Iterator afterIterator = msg.getPtnObjAfter().getValuesIterator();
            for (FieldSchema fs : tblObj.getPartitionKeys()) {
                oldPartSpec.put(fs.getName(), (String)beforeIterator.next());
                newPartSpec.put(fs.getName(), (String)afterIterator.next());
            }
        }
        catch (Exception e) {
            throw e instanceof SemanticException ? (SemanticException)e : new SemanticException("Error reading message members", e);
        }
        RenamePartitionDesc renamePtnDesc = new RenamePartitionDesc(tableName, oldPartSpec, newPartSpec, context.eventOnlyReplicationSpec());
        Task<DDLWork> renamePtnTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.readEntitySet, (HashSet<WriteEntity>)this.writeEntitySet, renamePtnDesc), context.hiveConf);
        context.log.debug("Added rename ptn task : {}:{}->{}", new Object[]{renamePtnTask.getId(), oldPartSpec, newPartSpec});
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, actualTblName, newPartSpec);
        return Collections.singletonList(renamePtnTask);
    }
}

