/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.monitoring;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.DAGSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.FSCountersSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.LLAPioSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.LlapWmSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.QueryExecutionBreakdownSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.RenderStrategy;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezProgressMonitor;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.TimeCounterLimit;
import org.apache.hadoop.hive.ql.wm.VertexCounterLimit;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezJobMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(TezJobMonitor.class);
    static final String CLASS_NAME = TezJobMonitor.class.getName();
    private static final int MAX_CHECK_INTERVAL = 1000;
    private static final int MAX_RETRY_INTERVAL = 2500;
    private static final int MAX_RETRY_FAILURES = 3;
    private final PerfLogger perfLogger = SessionState.getPerfLogger();
    private static final List<DAGClient> shutdownList = new LinkedList<DAGClient>();
    private final List<BaseWork> topSortedWorks;
    transient SessionState.LogHelper console;
    private StringWriter diagnostics = new StringWriter();
    private final DAGClient dagClient;
    private final HiveConf hiveConf;
    private final DAG dag;
    private final Context context;
    private long executionStartTime = 0L;
    private final RenderStrategy.UpdateFunction updateFunction;

    public static void initShutdownHook() {
        Preconditions.checkNotNull(shutdownList, (Object)"Shutdown hook was not properly initialized");
    }

    public TezJobMonitor(List<BaseWork> topSortedWorks, DAGClient dagClient, HiveConf conf, DAG dag, Context ctx) {
        this.topSortedWorks = topSortedWorks;
        this.dagClient = dagClient;
        this.hiveConf = conf;
        this.dag = dag;
        this.context = ctx;
        this.console = SessionState.getConsole();
        this.updateFunction = this.updateFunction();
    }

    private RenderStrategy.UpdateFunction updateFunction() {
        return InPlaceUpdate.canRenderInPlace((HiveConf)this.hiveConf) && !SessionState.getConsole().getIsSilent() && !SessionState.get().isHiveServerQuery() ? new RenderStrategy.InPlaceUpdateFunction(this) : new RenderStrategy.LogToFileFunction(this);
    }

    private boolean isProfilingEnabled() {
        return HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.TEZ_EXEC_SUMMARY) || Utilities.isPerfOrAboveLogging(this.hiveConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int monitorExecution() {
        boolean done = false;
        boolean success = false;
        int failedCounter = 0;
        StopWatch failureTimer = new StopWatch();
        int rc = 0;
        DAGStatus status = null;
        Map vertexProgressMap = null;
        long monitorStartTime = System.currentTimeMillis();
        List<DAGClient> list = shutdownList;
        synchronized (list) {
            shutdownList.add(this.dagClient);
        }
        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunDag");
        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezSubmitToRunningDag");
        DAGStatus.State lastState = null;
        boolean running = false;
        long checkInterval = HiveConf.getTimeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.TEZ_DAG_STATUS_CHECK_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        WmContext wmContext = null;
        while (true) {
            try {
                while (true) {
                    Set<String> desiredCounters;
                    if (this.context != null) {
                        this.context.checkHeartbeaterLockException();
                    }
                    status = this.dagClient.getDAGStatus(EnumSet.of(StatusGetOpts.GET_COUNTERS), checkInterval);
                    TezCounters dagCounters = status.getDAGCounters();
                    vertexProgressMap = status.getVertexProgress();
                    wmContext = this.context.getWmContext();
                    List<String> vertexNames = vertexProgressMap.keySet().stream().map(k -> k.replaceAll(" ", "_")).collect(Collectors.toList());
                    if (dagCounters != null && wmContext != null && (desiredCounters = wmContext.getSubscribedCounters()) != null && !desiredCounters.isEmpty()) {
                        Map<String, Long> currentCounters = this.getCounterValues(dagCounters, vertexNames, vertexProgressMap, desiredCounters, done);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Requested DAG status. checkInterval: {}. currentCounters: {}", (Object)checkInterval, currentCounters);
                        }
                        wmContext.setCurrentCounters(currentCounters);
                    }
                    DAGStatus.State state = status.getState();
                    failedCounter = 0;
                    failureTimer.reset();
                    if (state != lastState || state == DAGStatus.State.RUNNING) {
                        lastState = state;
                        switch (state) {
                            case SUBMITTED: {
                                this.console.printInfo("Status: Submitted");
                                break;
                            }
                            case INITING: {
                                this.console.printInfo("Status: Initializing");
                                this.executionStartTime = System.currentTimeMillis();
                                break;
                            }
                            case RUNNING: {
                                if (!running) {
                                    this.perfLogger.PerfLogEnd(CLASS_NAME, "TezSubmitToRunningDag");
                                    this.console.printInfo("Status: Running (" + this.dagClient.getExecutionContext() + ")\n");
                                    this.executionStartTime = System.currentTimeMillis();
                                    running = true;
                                }
                                this.updateFunction.update(status, vertexProgressMap);
                                break;
                            }
                            case SUCCEEDED: {
                                if (!running) {
                                    this.executionStartTime = monitorStartTime;
                                }
                                this.updateFunction.update(status, vertexProgressMap);
                                success = true;
                                running = false;
                                done = true;
                                break;
                            }
                            case KILLED: {
                                if (!running) {
                                    this.executionStartTime = monitorStartTime;
                                }
                                this.updateFunction.update(status, vertexProgressMap);
                                this.console.printInfo("Status: Killed");
                                running = false;
                                done = true;
                                rc = 1;
                                break;
                            }
                            case FAILED: 
                            case ERROR: {
                                if (!running) {
                                    this.executionStartTime = monitorStartTime;
                                }
                                this.updateFunction.update(status, vertexProgressMap);
                                this.console.printError("Status: Failed");
                                running = false;
                                done = true;
                                rc = 2;
                                break;
                            }
                        }
                    }
                    if (wmContext == null || !done) continue;
                    wmContext.setQueryCompleted(true);
                }
            }
            catch (Exception e) {
                this.console.printInfo("Exception: " + e.getMessage());
                boolean isInterrupted = TezJobMonitor.hasInterruptedException(e);
                if (failedCounter == 0) {
                    failureTimer.reset();
                    failureTimer.start();
                }
                if (isInterrupted || ++failedCounter >= 3 && failureTimer.now(TimeUnit.MILLISECONDS) > 2500L) {
                    try {
                        if (isInterrupted) {
                            this.console.printInfo("Killing DAG...");
                        } else {
                            this.console.printInfo(String.format("Killing DAG... after %d seconds", failureTimer.now(TimeUnit.SECONDS)));
                        }
                        this.dagClient.tryKillDAG();
                    }
                    catch (IOException | TezException throwable) {
                        // empty catch block
                    }
                    this.console.printError("Execution has failed. stack trace: " + ExceptionUtils.getStackTrace((Throwable)e));
                    rc = 1;
                    done = true;
                } else {
                    this.console.printInfo("Retrying...");
                }
                if (wmContext == null) {
                }
                if (done) {
                    wmContext.setQueryCompleted(true);
                }
            }
            finally {
                if (!done) continue;
                if (wmContext != null && done) {
                    wmContext.setQueryCompleted(true);
                }
                if (rc != 0 && status != null) {
                    for (String diag : status.getDiagnostics()) {
                        this.console.printError(diag);
                        this.diagnostics.append(diag);
                    }
                }
                List<DAGClient> list2 = shutdownList;
                synchronized (list2) {
                    shutdownList.remove(this.dagClient);
                }
            }
            break;
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "TezRunDag");
        this.printSummary(success, vertexProgressMap);
        return rc;
    }

    private Map<String, Long> getCounterValues(TezCounters dagCounters, List<String> vertexNames, Map<String, Progress> vertexProgressMap, Set<String> desiredCounters, boolean done) {
        HashMap<String, Long> updatedCounters = new HashMap<String, Long>();
        for (CounterGroup counterGroup : dagCounters) {
            for (TezCounter tezCounter : counterGroup) {
                String counterName = tezCounter.getName();
                for (String desiredCounter : desiredCounters) {
                    String prefixRemovedCounterName;
                    if (counterName.equals(desiredCounter)) {
                        updatedCounters.put(counterName, tezCounter.getValue());
                        continue;
                    }
                    if (this.isDagLevelCounter(desiredCounter)) {
                        prefixRemovedCounterName = this.getCounterFromDagCounter(desiredCounter);
                        this.aggregateCountersSum(updatedCounters, vertexNames, prefixRemovedCounterName, desiredCounter, tezCounter);
                        continue;
                    }
                    if (this.isVertexLevelCounter(desiredCounter)) {
                        prefixRemovedCounterName = this.getCounterFromVertexCounter(desiredCounter);
                        this.aggregateCountersMax(updatedCounters, vertexNames, prefixRemovedCounterName, desiredCounter, tezCounter);
                        continue;
                    }
                    if (!counterName.startsWith(desiredCounter)) continue;
                    prefixRemovedCounterName = desiredCounter;
                    this.aggregateCountersSum(updatedCounters, vertexNames, prefixRemovedCounterName, desiredCounter, tezCounter);
                }
            }
        }
        String counterName = VertexCounterLimit.VertexCounter.VERTEX_TOTAL_TASKS.name();
        if (desiredCounters.contains(counterName) && vertexProgressMap != null) {
            for (Map.Entry<String, Progress> entry : vertexProgressMap.entrySet()) {
                long currentMax = 0L;
                if (updatedCounters.containsKey(counterName)) {
                    currentMax = (Long)updatedCounters.get(counterName);
                }
                long newMax = Math.max(currentMax, (long)entry.getValue().getTotalTaskCount());
                updatedCounters.put(counterName, newMax);
            }
        }
        if (desiredCounters.contains(counterName = VertexCounterLimit.VertexCounter.DAG_TOTAL_TASKS.name()) && vertexProgressMap != null) {
            for (Map.Entry<String, Progress> entry : vertexProgressMap.entrySet()) {
                long currentTotal = 0L;
                if (updatedCounters.containsKey(counterName)) {
                    currentTotal = (Long)updatedCounters.get(counterName);
                }
                long newTotal = currentTotal + (long)entry.getValue().getTotalTaskCount();
                updatedCounters.put(counterName, newTotal);
            }
        }
        if (!done && desiredCounters.contains(counterName = TimeCounterLimit.TimeCounter.EXECUTION_TIME.name()) && this.executionStartTime > 0L) {
            updatedCounters.put(counterName, System.currentTimeMillis() - this.executionStartTime);
        }
        return updatedCounters;
    }

    private void aggregateCountersSum(Map<String, Long> updatedCounters, List<String> vertexNames, String prefixRemovedCounterName, String desiredCounter, TezCounter tezCounter) {
        long counterValue = this.checkVertexSuffixAndGetValue(vertexNames, prefixRemovedCounterName, tezCounter);
        long currentTotal = 0L;
        if (updatedCounters.containsKey(desiredCounter)) {
            currentTotal = updatedCounters.get(desiredCounter);
        }
        long newTotal = currentTotal + counterValue;
        updatedCounters.put(desiredCounter, newTotal);
    }

    private void aggregateCountersMax(Map<String, Long> updatedCounters, List<String> vertexNames, String prefixRemovedCounterName, String desiredCounter, TezCounter tezCounter) {
        long counterValue = this.checkVertexSuffixAndGetValue(vertexNames, prefixRemovedCounterName, tezCounter);
        long currentMax = 0L;
        if (updatedCounters.containsKey(desiredCounter)) {
            currentMax = updatedCounters.get(desiredCounter);
        }
        long newMax = Math.max(currentMax, counterValue);
        updatedCounters.put(desiredCounter, newMax);
    }

    private long checkVertexSuffixAndGetValue(List<String> vertexNames, String counterName, TezCounter tezCounter) {
        for (String vertexName : vertexNames) {
            if (!tezCounter.getName().equalsIgnoreCase(counterName + "_" + vertexName)) continue;
            return tezCounter.getValue();
        }
        return 0L;
    }

    private String getCounterFromDagCounter(String desiredCounter) {
        return desiredCounter.substring("DAG_".length());
    }

    private String getCounterFromVertexCounter(String desiredCounter) {
        return desiredCounter.substring("VERTEX_".length());
    }

    private boolean isVertexLevelCounter(String desiredCounter) {
        return desiredCounter.startsWith("VERTEX_");
    }

    private boolean isDagLevelCounter(String desiredCounter) {
        return desiredCounter.startsWith("DAG_");
    }

    private void printSummary(boolean success, Map<String, Progress> progressMap) {
        if (this.isProfilingEnabled() && success && progressMap != null) {
            String wmQueue;
            double duration = (double)(System.currentTimeMillis() - this.executionStartTime) / 1000.0;
            this.console.printInfo("Status: DAG finished successfully in " + String.format("%.2f seconds", duration));
            this.console.printInfo("");
            new QueryExecutionBreakdownSummary(this.perfLogger).print(this.console);
            new DAGSummary(progressMap, this.hiveConf, this.dagClient, this.dag, this.perfLogger).print(this.console);
            if (HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENABLED, (boolean)false)) {
                new LLAPioSummary(progressMap, this.dagClient).print(this.console);
                new FSCountersSummary(progressMap, this.dagClient).print(this.console);
            }
            if ((wmQueue = HiveConf.getVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_TEZ_INTERACTIVE_QUEUE)) != null && !wmQueue.isEmpty()) {
                new LlapWmSummary(progressMap, this.dagClient).print(this.console);
            }
            this.console.printInfo("");
        }
    }

    private static boolean hasInterruptedException(Throwable e) {
        while (e != null) {
            if (e instanceof InterruptedException || e instanceof InterruptedIOException) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killRunningJobs() {
        List<DAGClient> list = shutdownList;
        synchronized (list) {
            for (DAGClient c : shutdownList) {
                try {
                    System.err.println("Trying to shutdown DAG");
                    c.tryKillDAG();
                }
                catch (Exception exception) {}
            }
        }
    }

    static long getCounterValueByGroupName(TezCounters vertexCounters, String groupNamePattern, String counterName) {
        TezCounter tezCounter = ((CounterGroup)vertexCounters.getGroup(groupNamePattern)).findCounter(counterName);
        return tezCounter == null ? 0L : tezCounter.getValue();
    }

    public String getDiagnostics() {
        return this.diagnostics.toString();
    }

    ProgressMonitor progressMonitor(DAGStatus status, Map<String, Progress> progressMap) {
        try {
            return new TezProgressMonitor(this.dagClient, status, this.topSortedWorks, progressMap, this.console, this.executionStartTime);
        }
        catch (IOException | TezException e) {
            this.console.printInfo("Getting  Progress Information: " + e.getMessage() + " stack trace: " + ExceptionUtils.getStackTrace((Throwable)e));
            return TezProgressMonitor.NULL;
        }
    }

    static {
        ShutdownHookManager.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                TezJobMonitor.killRunningJobs();
                try {
                    TezSessionPoolManager.getInstance().closeNonDefaultSessions();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

