/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Stat;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HivePartitioner;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordWriter;
import org.apache.hadoop.hive.ql.io.StreamingOutputFormat;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveFatalException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.SkewedColumnPositionPair;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SubStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.common.util.HiveStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSinkOperator
extends TerminalOperator<FileSinkDesc>
implements Serializable {
    public static final Logger LOG = LoggerFactory.getLogger(FileSinkOperator.class);
    protected transient HashMap<String, FSPaths> valToPaths;
    protected transient int numDynParts;
    protected transient List<String> dpColNames;
    protected transient DynamicPartitionCtx dpCtx;
    protected transient boolean isCompressed;
    protected transient boolean isTemporary;
    protected transient Path parent;
    protected transient HiveOutputFormat<?, ?> hiveOutputFormat;
    protected transient Path specPath;
    protected transient String unionPath;
    protected transient boolean isUnionDp;
    protected transient int dpStartCol;
    protected transient List<String> dpVals;
    protected transient List<Object> dpWritables;
    protected transient RecordWriter[] rowOutWriters;
    protected transient int maxPartitions;
    protected transient ListBucketingCtx lbCtx;
    protected transient boolean isSkewedStoredAsSubDirectories;
    protected transient boolean[] statsFromRecordWriter;
    protected transient boolean isCollectRWStats;
    private transient FSPaths prevFsp;
    private transient FSPaths fpaths;
    private StructField recIdField;
    private StructField bucketField;
    private StructObjectInspector recIdInspector;
    private IntObjectInspector bucketInspector;
    protected transient long numRows = 0L;
    protected transient long cntr = 1L;
    protected transient long logEveryNRows = 0L;
    protected transient int rowIndex = 0;
    private transient Path destTablePath;
    private transient boolean isInsertOverwrite;
    private transient String counterGroup;
    private transient BiFunction<Object[], ObjectInspector[], Integer> hashFunc;
    private static final long serialVersionUID = 1L;
    protected transient FileSystem fs;
    protected transient Serializer serializer;
    protected final transient LongWritable row_count = new LongWritable();
    private transient ExprNodeEvaluator[] partitionEval;
    protected transient int totalFiles;
    private transient int numFiles;
    protected transient boolean multiFileSpray;
    protected final transient Map<Integer, Integer> bucketMap = new HashMap<Integer, Integer>();
    private transient boolean isBucketed = false;
    private transient ObjectInspector[] partitionObjectInspectors;
    protected transient HivePartitioner<HiveKey, Object> prtner;
    protected final transient HiveKey key = new HiveKey();
    private transient Configuration hconf;
    protected transient FSPaths fsp;
    protected transient boolean bDynParts;
    private transient SubStructObjectInspector subSetOI;
    private transient int timeOut;
    private transient long lastProgressReport = System.currentTimeMillis();
    protected transient boolean autoDelete = false;
    protected transient JobConf jc;
    Class<? extends Writable> outputClass;
    String taskId;
    protected boolean filesCreated = false;
    protected Writable recordValue;

    private void initializeSpecPath() {
        boolean isLinked = ((FileSinkDesc)this.conf).isLinkedFileSink();
        if (!isLinked) {
            this.specPath = ((FileSinkDesc)this.conf).getDirName();
            this.unionPath = null;
        } else {
            boolean bl = this.isUnionDp = this.dpCtx != null;
            if (((FileSinkDesc)this.conf).isMmTable() || this.isUnionDp) {
                this.specPath = ((FileSinkDesc)this.conf).getParentDir();
                this.unionPath = ((FileSinkDesc)this.conf).getDirName().getName();
            } else {
                this.specPath = ((FileSinkDesc)this.conf).getDirName();
                this.unionPath = null;
            }
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Setting up FSOP " + System.identityHashCode(this) + " (" + ((FileSinkDesc)this.conf).isLinkedFileSink() + ") with " + this.taskId + " and " + this.specPath + " + " + this.unionPath);
        }
    }

    protected FileSinkOperator() {
    }

    public FileSinkOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        try {
            this.hconf = hconf;
            this.filesCreated = false;
            this.isTemporary = ((FileSinkDesc)this.conf).isTemporary();
            this.multiFileSpray = ((FileSinkDesc)this.conf).isMultiFileSpray();
            this.isBucketed = hconf.getInt("bucket_count", 0) > 0;
            this.totalFiles = ((FileSinkDesc)this.conf).getTotalFiles();
            this.numFiles = ((FileSinkDesc)this.conf).getNumFiles();
            this.dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
            this.lbCtx = ((FileSinkDesc)this.conf).getLbCtx();
            this.prevFsp = null;
            this.fsp = null;
            this.valToPaths = new HashMap();
            this.taskId = Utilities.getTaskId(hconf);
            this.initializeSpecPath();
            this.fs = this.specPath.getFileSystem(hconf);
            this.jc = hconf instanceof JobConf ? (JobConf)hconf : new JobConf(hconf);
            try {
                this.createHiveOutputFormat(this.jc);
            }
            catch (HiveException ex) {
                this.logOutputFormatError(hconf, ex);
                throw ex;
            }
            this.isCompressed = ((FileSinkDesc)this.conf).getCompressed();
            this.parent = Utilities.toTempPath(((FileSinkDesc)this.conf).getDirName());
            this.statsFromRecordWriter = new boolean[this.numFiles];
            this.serializer = (Serializer)((FileSinkDesc)this.conf).getTableInfo().getDeserializerClass().newInstance();
            this.serializer.initialize(this.unsetNestedColumnPaths(hconf), ((FileSinkDesc)this.conf).getTableInfo().getProperties());
            this.outputClass = this.serializer.getSerializedClass();
            this.destTablePath = ((FileSinkDesc)this.conf).getDestPath();
            this.isInsertOverwrite = ((FileSinkDesc)this.conf).getInsertOverwrite();
            this.counterGroup = HiveConf.getVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVECOUNTERGROUP);
            if (LOG.isInfoEnabled()) {
                LOG.info("Using serializer : " + this.serializer + " and formatter : " + this.hiveOutputFormat + (this.isCompressed ? " with compression" : ""));
            }
            this.timeOut = hconf.getInt("mapred.healthChecker.script.timeout", 600000) / 2;
            if (this.multiFileSpray) {
                this.partitionEval = new ExprNodeEvaluator[((FileSinkDesc)this.conf).getPartitionCols().size()];
                int i = 0;
                for (ExprNodeDesc e : ((FileSinkDesc)this.conf).getPartitionCols()) {
                    this.partitionEval[i++] = ExprNodeEvaluatorFactory.get(e);
                }
                this.partitionObjectInspectors = FileSinkOperator.initEvaluators(this.partitionEval, this.outputObjInspector);
                this.prtner = (HivePartitioner)ReflectionUtils.newInstance((Class)this.jc.getPartitionerClass(), null);
            }
            if (this.dpCtx != null) {
                this.dpSetup();
            }
            if (this.lbCtx != null) {
                this.lbSetup();
            }
            if (!this.bDynParts) {
                this.fsp = new FSPaths(this.specPath, ((FileSinkDesc)this.conf).isMmTable());
                this.fsp.subdirAfterTxn = FileSinkOperator.combinePathFragments(this.generateListBucketingDirName(null), this.unionPath);
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("creating new paths " + System.identityHashCode(this.fsp) + " from ctor; childSpec " + this.unionPath + ": tmpPath " + this.fsp.buildTmpPath() + ", task path " + this.fsp.buildTaskOutputTempPath());
                }
                if (!this.isSkewedStoredAsSubDirectories) {
                    this.valToPaths.put("", this.fsp);
                }
            }
            HadoopShims.StoragePolicyValue tmpStorage = HadoopShims.StoragePolicyValue.lookup((String)HiveConf.getVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEMPORARY_TABLE_STORAGE));
            if (this.isTemporary && this.fsp != null && tmpStorage != HadoopShims.StoragePolicyValue.DEFAULT) {
                assert (!((FileSinkDesc)this.conf).isMmTable());
                Path outputPath = this.fsp.buildTaskOutputTempPath();
                HadoopShims.StoragePolicyShim shim = ShimLoader.getHadoopShims().getStoragePolicyShim(this.fs);
                if (shim != null) {
                    this.fs.mkdirs(outputPath);
                    shim.setStoragePolicy(outputPath, tmpStorage);
                }
            }
            if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.UPDATE || ((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.DELETE) {
                this.recIdField = (StructField)((StructObjectInspector)this.outputObjInspector).getAllStructFieldRefs().get(0);
                this.recIdInspector = (StructObjectInspector)this.recIdField.getFieldObjectInspector();
                this.bucketField = (StructField)this.recIdInspector.getAllStructFieldRefs().get(1);
                this.bucketInspector = (IntObjectInspector)this.bucketField.getFieldObjectInspector();
            }
            this.numRows = 0L;
            this.cntr = 1L;
            this.logEveryNRows = HiveConf.getLongVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOG_N_RECORDS);
            this.statsMap.put(this.getCounterName(Counter.RECORDS_OUT), this.row_count);
            this.hashFunc = ((FileSinkDesc)this.conf).getTableInfo().getBucketingVersion() == 2 ? ObjectInspectorUtils::getBucketHashCode : ObjectInspectorUtils::getBucketHashCodeOld;
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    public String getCounterName(Counter counter) {
        String suffix = Integer.toString(((FileSinkDesc)this.conf).getDestTableId());
        String fullName = ((FileSinkDesc)this.conf).getTableInfo().getTableName();
        if (fullName != null) {
            suffix = suffix + "_" + fullName.toLowerCase();
        }
        return (Object)((Object)counter) + "_" + suffix;
    }

    private void logOutputFormatError(Configuration hconf, HiveException ex) {
        StringBuilder errorWriter = new StringBuilder();
        errorWriter.append("Failed to create output format; configuration: ");
        HiveConfUtil.dumpConfig((Configuration)hconf, (StringBuilder)errorWriter);
        Properties tdp = null;
        if (((FileSinkDesc)this.conf).getTableInfo() != null && (tdp = ((FileSinkDesc)this.conf).getTableInfo().getProperties()) != null) {
            errorWriter.append(";\n table properties: { ");
            for (Map.Entry<Object, Object> e : tdp.entrySet()) {
                errorWriter.append(e.getKey() + ": " + e.getValue() + ", ");
            }
            errorWriter.append('}');
        }
        LOG.error(errorWriter.toString(), (Throwable)ex);
    }

    private void lbSetup() {
        this.isSkewedStoredAsSubDirectories = this.lbCtx == null ? false : this.lbCtx.isSkewedStoredAsDir();
    }

    private void dpSetup() {
        this.bDynParts = false;
        this.numDynParts = this.dpCtx.getNumDPCols();
        this.dpColNames = this.dpCtx.getDPColNames();
        this.maxPartitions = this.dpCtx.getMaxPartitionsPerNode();
        assert (this.numDynParts == this.dpColNames.size()) : "number of dynamic partitions should be the same as the size of DP mapping";
        if (this.dpColNames != null && this.dpColNames.size() > 0) {
            this.bDynParts = true;
            assert (this.inputObjInspectors.length == 1) : "FileSinkOperator should have 1 parent, but it has " + this.inputObjInspectors.length;
            StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
            this.dpStartCol = Utilities.getDPColOffset((FileSinkDesc)this.conf);
            this.subSetOI = new SubStructObjectInspector(soi, 0, this.dpStartCol);
            this.dpVals = new ArrayList<String>(this.numDynParts);
            this.dpWritables = new ArrayList<Object>(this.numDynParts);
        }
    }

    protected void createBucketFiles(FSPaths fsp) throws HiveException {
        try {
            int filesIdx = 0;
            HashSet<Integer> seenBuckets = new HashSet<Integer>();
            for (int idx = 0; idx < this.totalFiles; ++idx) {
                if (this.getExecContext() != null && this.getExecContext().getFileId() != null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("replace taskId from execContext ");
                    }
                    this.taskId = Utilities.replaceTaskIdFromFilename(this.taskId, this.getExecContext().getFileId());
                    if (LOG.isInfoEnabled()) {
                        LOG.info("new taskId: FS " + this.taskId);
                    }
                    assert (!this.multiFileSpray);
                    assert (this.totalFiles == 1);
                }
                int bucketNum = 0;
                if (this.multiFileSpray) {
                    int reducerIdx;
                    int currReducer;
                    this.key.setHashCode(idx);
                    int numReducers = this.totalFiles / this.numFiles;
                    if (numReducers > 1 && (currReducer = Integer.parseInt(Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf)))) != (reducerIdx = this.prtner.getPartition((Object)this.key, null, numReducers)) || seenBuckets.contains(bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles))) continue;
                    seenBuckets.add(bucketNum);
                    this.bucketMap.put(bucketNum, filesIdx);
                    this.taskId = Utilities.replaceTaskIdFromFilename(Utilities.getTaskId(this.hconf), bucketNum);
                }
                this.createBucketForFileIdx(fsp, filesIdx);
                ++filesIdx;
            }
            assert (filesIdx == this.numFiles);
            if (this.isNativeTable() && this.fs != null && fsp != null && !((FileSinkDesc)this.conf).isMmTable()) {
                this.autoDelete = this.fs.deleteOnExit(fsp.outPaths[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
        this.filesCreated = true;
    }

    protected void createBucketForFileIdx(FSPaths fsp, int filesIdx) throws HiveException {
        try {
            fsp.initializeBucketPaths(filesIdx, this.taskId, this.isNativeTable(), this.isSkewedStoredAsSubDirectories);
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("createBucketForFileIdx " + filesIdx + ": final path " + fsp.finalPaths[filesIdx] + "; out path " + fsp.outPaths[filesIdx] + " (spec path " + this.specPath + ", tmp path " + fsp.buildTmpPath() + ", task " + this.taskId + ")");
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("New Final Path: FS " + fsp.finalPaths[filesIdx]);
            }
            if (this.isNativeTable() && !((FileSinkDesc)this.conf).isMmTable()) {
                this.autoDelete = this.fs.deleteOnExit(fsp.outPaths[filesIdx]);
            }
            this.updateDPCounters(fsp, filesIdx);
            Utilities.copyTableJobPropertiesToConf(((FileSinkDesc)this.conf).getTableInfo(), this.jc);
            if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID || ((FileSinkDesc)this.conf).isMmTable()) {
                Path outPath = fsp.outPaths[filesIdx];
                if (((FileSinkDesc)this.conf).isMmTable() && !FileUtils.mkdir((FileSystem)this.fs, (Path)outPath.getParent(), (Configuration)this.hconf)) {
                    LOG.warn("Unable to create directory with inheritPerms: " + outPath);
                }
                fsp.outWriters[filesIdx] = HiveFileFormatUtils.getHiveRecordWriter(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), this.outputClass, (FileSinkDesc)this.conf, outPath, this.reporter);
                this.statsFromRecordWriter[filesIdx] = fsp.outWriters[filesIdx] instanceof StatsProvidingRecordWriter;
            } else if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.INSERT) {
                SubStructObjectInspector inspector = this.bDynParts ? this.subSetOI : this.outputObjInspector;
                int acidBucketNum = Integer.parseInt(Utilities.getTaskIdFromFilename(this.taskId));
                fsp.updaters[filesIdx] = HiveFileFormatUtils.getAcidRecordUpdater(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), acidBucketNum, (FileSinkDesc)this.conf, fsp.outPaths[filesIdx], (ObjectInspector)inspector, this.reporter, -1);
            }
            if (this.reporter != null) {
                this.reporter.incrCounter(this.counterGroup, "CREATED_FILES", 1L);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void updateDPCounters(FSPaths fsp, int filesIdx) {
        if (this.bDynParts && this.destTablePath != null && fsp.dpDirForCounters != null) {
            Path destPartPath = new Path(this.destTablePath, fsp.dpDirForCounters);
            try {
                if (((FileSinkDesc)this.conf).isMmTable()) {
                    this.createDpDir(destPartPath);
                } else {
                    Path dpStagingDir = fsp.outPaths[filesIdx].getParent();
                    if (this.isUnionDp) {
                        dpStagingDir = dpStagingDir.getParent();
                    }
                    if (this.isInsertOverwrite) {
                        this.createDpDir(dpStagingDir);
                    } else {
                        this.createDpDirCheckSrc(dpStagingDir, destPartPath);
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("Skipping to increment CREATED_DYNAMIC_PARTITIONS counter.Exception: {}", (Object)e.getMessage());
            }
        }
    }

    private void createDpDirCheckSrc(Path dpStagingPath, Path dpFinalPath) throws IOException {
        if (!this.fs.exists(dpStagingPath) && !this.fs.exists(dpFinalPath)) {
            this.fs.mkdirs(dpStagingPath);
            if (this.reporter != null) {
                this.reporter.incrCounter(this.counterGroup, "CREATED_DYNAMIC_PARTITIONS", 1L);
            }
        }
    }

    private void createDpDir(Path dpPath) throws IOException {
        if (!this.fs.exists(dpPath)) {
            this.fs.mkdirs(dpPath);
            if (this.reporter != null) {
                this.reporter.incrCounter(this.counterGroup, "CREATED_DYNAMIC_PARTITIONS", 1L);
            }
        }
    }

    protected boolean updateProgress() {
        if (this.reporter != null && System.currentTimeMillis() - this.lastProgressReport > (long)this.timeOut) {
            this.reporter.progress();
            this.lastProgressReport = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        block33: {
            ++this.runTimeNumRows;
            String lbDirName = null;
            String string = lbDirName = this.lbCtx == null ? null : this.generateListBucketingDirName(row);
            if (!this.bDynParts && !this.filesCreated) {
                if (lbDirName != null) {
                    if (this.valToPaths.get(lbDirName) == null) {
                        this.createNewPaths(null, lbDirName);
                    }
                } else {
                    this.createBucketFiles(this.fsp);
                }
            }
            try {
                this.updateProgress();
                assert (this.inputObjInspectors[0].getCategory() == ObjectInspector.Category.STRUCT) : "input object inspector is not struct";
                if (this.bDynParts) {
                    if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                        ++this.numDynParts;
                    }
                    this.dpVals.clear();
                    this.dpWritables.clear();
                    ObjectInspectorUtils.partialCopyToStandardObject(this.dpWritables, (Object)row, (int)this.dpStartCol, (int)this.numDynParts, (StructObjectInspector)((StructObjectInspector)this.inputObjInspectors[0]), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                    for (Object o : this.dpWritables) {
                        if (o == null || o.toString().length() == 0) {
                            this.dpVals.add(this.dpCtx.getDefaultPartitionName());
                            continue;
                        }
                        this.dpVals.add(o.toString());
                    }
                    String invalidPartitionVal = HiveStringUtils.getPartitionValWithInvalidCharacter(this.dpVals, (Pattern)this.dpCtx.getWhiteListPattern());
                    if (invalidPartitionVal != null) {
                        throw new HiveFatalException("Partition value '" + invalidPartitionVal + "' contains a character not matched by whitelist pattern '" + this.dpCtx.getWhiteListPattern().toString() + "'.  " + "(configure with " + HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN.varname + ")");
                    }
                    this.fpaths = this.getDynOutPaths(this.dpVals, lbDirName);
                    this.recordValue = this.serializer.serialize(row, (ObjectInspector)this.subSetOI);
                } else {
                    if (lbDirName != null) {
                        this.fpaths = this.valToPaths.get(lbDirName);
                        if (this.fpaths == null) {
                            this.fpaths = this.createNewPaths(null, lbDirName);
                        }
                    } else {
                        this.fpaths = this.fsp;
                    }
                    this.recordValue = this.serializer.serialize(row, this.inputObjInspectors[0]);
                    if (this.recordValue == null) {
                        return;
                    }
                }
                this.rowOutWriters = this.fpaths.outWriters;
                this.isCollectRWStats = this.areAllTrue(this.statsFromRecordWriter);
                if (((FileSinkDesc)this.conf).isGatherStats() && !this.isCollectRWStats) {
                    SerDeStats stats = this.serializer.getSerDeStats();
                    if (stats != null) {
                        this.fpaths.addToStat("rawDataSize", stats.getRawDataSize());
                    }
                    this.fpaths.addToStat("numRows", 1L);
                }
                if (++this.numRows == this.cntr && LOG.isInfoEnabled()) {
                    long l = this.cntr = this.logEveryNRows == 0L ? this.cntr * 10L : this.numRows + this.logEveryNRows;
                    if (this.cntr < 0L || this.numRows < 0L) {
                        this.cntr = 0L;
                        this.numRows = 1L;
                    }
                    LOG.info(this.toString() + ": records written - " + this.numRows);
                }
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID || ((FileSinkDesc)this.conf).isMmTable()) {
                    this.rowOutWriters[this.findWriterOffset(row)].write(this.recordValue);
                    break block33;
                }
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.INSERT) {
                    this.fpaths.updaters[this.findWriterOffset(row)].insert(((FileSinkDesc)this.conf).getTableWriteId(), row);
                    break block33;
                }
                SubStructObjectInspector rowInspector = this.bDynParts ? this.subSetOI : this.outputObjInspector;
                Object recId = ((StructObjectInspector)rowInspector).getStructFieldData(row, this.recIdField);
                int bucketProperty = this.bucketInspector.get(this.recIdInspector.getStructFieldData(recId, this.bucketField));
                int bucketNum = BucketCodec.determineVersion(bucketProperty).decodeWriterId(bucketProperty);
                int writerOffset = 0;
                if (this.multiFileSpray) {
                    if (!this.bucketMap.containsKey(bucketNum)) {
                        String extraMsg = "  (no path info/)" + recId;
                        if (this.fpaths != null && this.fpaths.finalPaths != null && this.fpaths.finalPaths.length > 0) {
                            extraMsg = "  (finalPaths[0]=" + this.fpaths.finalPaths[0] + ")/" + recId;
                        }
                        throw new IllegalStateException("Found bucketNum=" + bucketNum + " from data but no mapping in 'bucketMap'." + extraMsg);
                    }
                    writerOffset = this.bucketMap.get(bucketNum);
                } else if (!this.isBucketed) {
                    writerOffset = this.fpaths.createDynamicBucket(bucketNum);
                }
                if (this.fpaths.updaters[writerOffset] == null) {
                    this.fpaths.updaters[writerOffset] = HiveFileFormatUtils.getAcidRecordUpdater(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), bucketNum, (FileSinkDesc)this.conf, this.fpaths.outPaths[writerOffset], (ObjectInspector)rowInspector, this.reporter, 0);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created updater for bucket number " + bucketNum + " using file " + this.fpaths.outPaths[writerOffset]);
                    }
                }
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.UPDATE) {
                    this.fpaths.updaters[writerOffset].update(((FileSinkDesc)this.conf).getTableWriteId(), row);
                    break block33;
                }
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.DELETE) {
                    this.fpaths.updaters[writerOffset].delete(((FileSinkDesc)this.conf).getTableWriteId(), row);
                    break block33;
                }
                throw new HiveException("Unknown write type " + ((FileSinkDesc)this.conf).getWriteType().toString());
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            catch (SerDeException e) {
                throw new HiveException(e);
            }
        }
    }

    protected boolean areAllTrue(boolean[] statsFromRW) {
        if (((FileSinkDesc)this.conf).getWriteType() != AcidUtils.Operation.NOT_ACID && !((FileSinkDesc)this.conf).isMmTable()) {
            return true;
        }
        for (boolean b : statsFromRW) {
            if (b) continue;
            return false;
        }
        return true;
    }

    private int findWriterOffset(Object row) throws HiveException {
        if (!this.multiFileSpray) {
            return 0;
        }
        assert (((FileSinkDesc)this.getConf()).getWriteType() != AcidUtils.Operation.DELETE && ((FileSinkDesc)this.getConf()).getWriteType() != AcidUtils.Operation.UPDATE) : "Unexpected operation type: " + ((FileSinkDesc)this.getConf()).getWriteType();
        Object[] bucketFieldValues = new Object[this.partitionEval.length];
        for (int i = 0; i < this.partitionEval.length; ++i) {
            bucketFieldValues[i] = this.partitionEval[i].evaluate(row);
        }
        int keyHashCode = this.hashFunc.apply(bucketFieldValues, this.partitionObjectInspectors);
        this.key.setHashCode(keyHashCode);
        int bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles);
        return this.bucketMap.get(bucketNum);
    }

    private FSPaths createNewPaths(String dpDir, String lbDir) throws HiveException {
        FSPaths fsp2 = new FSPaths(this.specPath, ((FileSinkDesc)this.conf).isMmTable());
        fsp2.subdirAfterTxn = FileSinkOperator.combinePathFragments(lbDir, this.unionPath);
        fsp2.subdirBeforeTxn = dpDir;
        String pathKey = FileSinkOperator.combinePathFragments(dpDir, lbDir);
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("creating new paths {} for {}, childSpec {}: tmpPath {}, task path {}", new Object[]{System.identityHashCode(fsp2), pathKey, this.unionPath, fsp2.buildTmpPath(), fsp2.buildTaskOutputTempPath()});
        }
        if (this.bDynParts) {
            fsp2.dpDirForCounters = pathKey;
        }
        if (!((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
            this.createBucketFiles(fsp2);
            this.valToPaths.put(pathKey, fsp2);
        }
        return fsp2;
    }

    private static String combinePathFragments(String first, String second) {
        return first == null ? second : (second == null ? first : first + "/" + second);
    }

    protected String generateListBucketingDirName(Object row) {
        if (!this.isSkewedStoredAsSubDirectories) {
            return null;
        }
        String lbDirName = null;
        List<String> skewedCols = this.lbCtx.getSkewedColNames();
        List<List<String>> allSkewedVals = this.lbCtx.getSkewedColValues();
        Map<List<String>, String> locationMap = this.lbCtx.getLbLocationMap();
        if (row != null) {
            ArrayList standObjs = new ArrayList();
            ArrayList<String> skewedValsCandidate = null;
            ObjectInspectorUtils.copyToStandardObject(standObjs, (Object)row, (StructObjectInspector)((StructObjectInspector)this.inputObjInspectors[0]), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            assert (standObjs.size() >= skewedCols.size()) : "The row has less number of columns than no. of skewed column.";
            skewedValsCandidate = new ArrayList<String>(skewedCols.size());
            for (SkewedColumnPositionPair posPair : this.lbCtx.getRowSkewedIndex()) {
                skewedValsCandidate.add(posPair.getSkewColPosition(), standObjs.get(posPair.getTblColPosition()).toString());
            }
            if (allSkewedVals.contains(skewedValsCandidate)) {
                lbDirName = FileUtils.makeListBucketingDirName(skewedCols, skewedValsCandidate);
                locationMap.put(skewedValsCandidate, lbDirName);
            } else {
                lbDirName = this.createDefaultLbDir(skewedCols, locationMap);
            }
        } else {
            lbDirName = this.createDefaultLbDir(skewedCols, locationMap);
        }
        return lbDirName;
    }

    private String createDefaultLbDir(List<String> skewedCols, Map<List<String>, String> locationMap) {
        String lbDirName = FileUtils.makeDefaultListBucketingDirName(skewedCols, (String)this.lbCtx.getDefaultDirName());
        ArrayList defaultKey = Lists.newArrayList((Object[])new String[]{this.lbCtx.getDefaultKey()});
        if (!locationMap.containsKey(defaultKey)) {
            locationMap.put(defaultKey, lbDirName);
        }
        return lbDirName;
    }

    protected FSPaths getDynOutPaths(List<String> row, String lbDir) throws HiveException {
        FSPaths fp;
        String dpDir = this.getDynPartDirectory(row, this.dpColNames);
        String pathKey = null;
        if (dpDir != null) {
            FSPaths fsp2;
            String dpAndLbDir;
            pathKey = dpAndLbDir = FileSinkOperator.combinePathFragments(dpDir, lbDir);
            if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                String buckNum = row.get(row.size() - 1);
                this.taskId = Utilities.replaceTaskIdFromFilename(this.taskId, buckNum);
                pathKey = dpAndLbDir + "/" + this.taskId;
            }
            if ((fsp2 = this.valToPaths.get(pathKey)) == null) {
                if (this.valToPaths.size() > this.maxPartitions) {
                    throw new HiveFatalException(ErrorMsg.DYNAMIC_PARTITIONS_TOO_MANY_PER_NODE_ERROR.getErrorCodedMsg() + "Maximum was set to " + this.maxPartitions + " partitions per node" + ", number of dynamic partitions on this node: " + this.valToPaths.size());
                }
                if (!((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.NONE) && this.prevFsp != null) {
                    this.prevFsp.closeWriters(false);
                    if (((FileSinkDesc)this.conf).isGatherStats() && this.isCollectRWStats) {
                        SerDeStats stats = null;
                        if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID || ((FileSinkDesc)this.conf).isMmTable()) {
                            RecordWriter outWriter = this.prevFsp.outWriters[0];
                            if (outWriter != null) {
                                stats = ((StatsProvidingRecordWriter)outWriter).getStats();
                            }
                        } else if (this.prevFsp.updaters[0] != null) {
                            stats = this.prevFsp.updaters[0].getStats();
                        }
                        if (stats != null) {
                            this.prevFsp.addToStat("rawDataSize", stats.getRawDataSize());
                            this.prevFsp.addToStat("numRows", stats.getRowCount());
                        }
                    }
                    this.prevFsp.outWriters[0] = null;
                    this.prevFsp = null;
                }
                fsp2 = this.createNewPaths(dpDir, lbDir);
                if (this.prevFsp == null) {
                    this.prevFsp = fsp2;
                }
                if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                    this.createBucketForFileIdx(fsp2, 0);
                    this.valToPaths.put(pathKey, fsp2);
                }
            }
            fp = fsp2;
        } else {
            fp = this.fsp;
        }
        return fp;
    }

    private String getDynPartDirectory(List<String> row, List<String> dpColNames) {
        return FileUtils.makePartName(dpColNames, row);
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        this.row_count.set(this.numRows);
        LOG.info(this.toString() + ": records written - " + this.numRows);
        if (!this.bDynParts && !this.filesCreated) {
            boolean skipFiles = "tez".equalsIgnoreCase(HiveConf.getVar((Configuration)this.hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE));
            if (skipFiles) {
                Class<? extends OutputFormat> clazz = ((FileSinkDesc)this.conf).getTableInfo().getOutputFileFormatClass();
                boolean bl = skipFiles = !StreamingOutputFormat.class.isAssignableFrom(clazz);
            }
            if (!skipFiles) {
                this.createBucketFiles(this.fsp);
            }
        }
        this.lastProgressReport = System.currentTimeMillis();
        if (!abort) {
            if (((FileSinkDesc)this.conf).isUsingBatchingSerDe()) {
                try {
                    this.recordValue = this.serializer.serialize(null, this.inputObjInspectors[0]);
                    if (null != this.fpaths) {
                        this.rowOutWriters = this.fpaths.outWriters;
                        this.rowOutWriters[0].write(this.recordValue);
                    } else if (this.recordValue instanceof ArrowWrapperWritable) {
                        for (FSPaths fSPaths : this.valToPaths.values()) {
                            for (RecordWriter writer : fSPaths.outWriters) {
                                writer.write(this.recordValue);
                            }
                        }
                    }
                }
                catch (IOException | SerDeException e) {
                    throw new HiveException(e);
                }
            }
            ArrayList<Path> commitPaths = new ArrayList<Path>();
            for (FSPaths fsp : this.valToPaths.values()) {
                fsp.closeWriters(abort);
                if (((FileSinkDesc)this.conf).isGatherStats() && this.isCollectRWStats) {
                    if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID || ((FileSinkDesc)this.conf).isMmTable()) {
                        for (int idx = 0; idx < fsp.outWriters.length; ++idx) {
                            SerDeStats stats;
                            RecordWriter outWriter = fsp.outWriters[idx];
                            if (outWriter == null || (stats = ((StatsProvidingRecordWriter)outWriter).getStats()) == null) continue;
                            fsp.addToStat("rawDataSize", stats.getRawDataSize());
                            fsp.addToStat("numRows", stats.getRowCount());
                        }
                    } else {
                        for (int i = 0; i < fsp.updaters.length; ++i) {
                            SerDeStats stats;
                            if (fsp.updaters[i] == null || (stats = fsp.updaters[i].getStats()) == null) continue;
                            fsp.addToStat("rawDataSize", stats.getRawDataSize());
                            fsp.addToStat("numRows", stats.getRowCount());
                        }
                    }
                }
                if (!this.isNativeTable()) continue;
                fsp.commit(this.fs, commitPaths);
            }
            if (((FileSinkDesc)this.conf).isMmTable()) {
                Utilities.writeMmCommitManifest(commitPaths, this.specPath, this.fs, this.taskId, ((FileSinkDesc)this.conf).getTableWriteId(), ((FileSinkDesc)this.conf).getStatementId(), this.unionPath, ((FileSinkDesc)this.conf).getInsertOverwrite());
            }
            if (((FileSinkDesc)this.conf).isGatherStats()) {
                this.publishStats();
            }
        } else {
            for (FSPaths fSPaths : this.valToPaths.values()) {
                fSPaths.abortWriters(this.fs, abort, !this.autoDelete && this.isNativeTable() && !((FileSinkDesc)this.conf).isMmTable());
            }
        }
        this.prevFsp = null;
        this.fsp = null;
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return FileSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "FS";
    }

    @Override
    public void jobCloseOp(Configuration hconf, boolean success) throws HiveException {
        try {
            if (this.conf != null && this.isNativeTable()) {
                Path specPath = ((FileSinkDesc)this.conf).getDirName();
                String unionSuffix = null;
                DynamicPartitionCtx dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
                ListBucketingCtx lbCtx = ((FileSinkDesc)this.conf).getLbCtx();
                if (((FileSinkDesc)this.conf).isLinkedFileSink() && (dpCtx != null || ((FileSinkDesc)this.conf).isMmTable())) {
                    specPath = ((FileSinkDesc)this.conf).getParentDir();
                    unionSuffix = ((FileSinkDesc)this.conf).getDirName().getName();
                }
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("jobCloseOp using specPath " + specPath);
                }
                if (!((FileSinkDesc)this.conf).isMmTable()) {
                    Utilities.mvFileToFinalPath(specPath, hconf, success, LOG, dpCtx, (FileSinkDesc)this.conf, this.reporter);
                } else {
                    int lbLevels;
                    int dpLevels = dpCtx == null ? 0 : dpCtx.getNumDPCols();
                    int n = lbLevels = lbCtx == null ? 0 : lbCtx.calculateListBucketingLevel();
                    int numBuckets = ((FileSinkDesc)this.conf).getTable() != null ? ((FileSinkDesc)this.conf).getTable().getNumBuckets() : (dpCtx != null ? dpCtx.getNumBuckets() : 0);
                    Utilities.MissingBucketsContext mbc = new Utilities.MissingBucketsContext(((FileSinkDesc)this.conf).getTableInfo(), numBuckets, ((FileSinkDesc)this.conf).getCompressed());
                    Utilities.handleMmTableFinalPath(specPath, unionSuffix, hconf, success, dpLevels, lbLevels, mbc, ((FileSinkDesc)this.conf).getTableWriteId(), ((FileSinkDesc)this.conf).getStatementId(), this.reporter, ((FileSinkDesc)this.conf).isMmTable(), ((FileSinkDesc)this.conf).isMmCtas(), ((FileSinkDesc)this.conf).getInsertOverwrite());
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        super.jobCloseOp(hconf, success);
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FILESINK;
    }

    @Override
    public void augmentPlan() {
        PlanUtils.configureOutputJobPropertiesForStorageHandler(((FileSinkDesc)this.getConf()).getTableInfo());
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        if (this.hiveOutputFormat == null) {
            try {
                this.createHiveOutputFormat(job);
            }
            catch (HiveException ex) {
                this.logOutputFormatError((Configuration)job, ex);
                throw new IOException(ex);
            }
        }
        if (((FileSinkDesc)this.conf).getTableInfo().isNonNative()) {
            try {
                this.hiveOutputFormat.checkOutputSpecs(ignored, job);
            }
            catch (NoSuchMethodError e) {
                LOG.warn("HiveOutputFormat should implement checkOutputSpecs() method`");
            }
        }
    }

    private void createHiveOutputFormat(JobConf job) throws HiveException {
        if (this.hiveOutputFormat == null) {
            Utilities.copyTableJobPropertiesToConf(((FileSinkDesc)this.conf).getTableInfo(), job);
        }
        try {
            this.hiveOutputFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)job, ((FileSinkDesc)this.getConf()).getTableInfo());
        }
        catch (Throwable t) {
            throw t instanceof HiveException ? (HiveException)t : new HiveException(t);
        }
    }

    private void publishStats() throws HiveException {
        boolean isStatsReliable = ((FileSinkDesc)this.conf).isStatsReliable();
        StatsPublisher statsPublisher = Utilities.getStatsPublisher(this.jc);
        if (statsPublisher == null) {
            LOG.error("StatsPublishing error: StatsPublisher is not initialized.");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_NOT_OBTAINED.getErrorCodedMsg());
            }
            return;
        }
        StatsCollectionContext sContext = new StatsCollectionContext(this.hconf);
        sContext.setStatsTmpDir(((FileSinkDesc)this.conf).getTmpStatsDir());
        if (!statsPublisher.connect(sContext)) {
            LOG.error("StatsPublishing error: cannot connect to database");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_CONNECTION_ERROR.getErrorCodedMsg());
            }
            return;
        }
        String spSpec = ((FileSinkDesc)this.conf).getStaticSpec();
        for (Map.Entry<String, FSPaths> entry : this.valToPaths.entrySet()) {
            String fspKey = entry.getKey();
            FSPaths fspValue = entry.getValue();
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Observing entry for stats " + fspKey + " => FSP with tmpPath " + fspValue.buildTmpPath());
            }
            if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                String taskID = Utilities.getTaskIdFromFilename(fspKey);
                fspKey = fspKey.split(taskID)[0];
            }
            String[] split = this.splitKey(fspKey);
            String dpSpec = split[0];
            String prefix = ((FileSinkDesc)this.conf).getTableInfo().getTableName().toLowerCase();
            String string = prefix = (prefix = Utilities.join(prefix, spSpec, dpSpec)).endsWith("/") ? prefix : prefix + "/";
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Prefix for stats " + prefix + " (from " + spSpec + ", " + dpSpec + ")");
            }
            HashMap<String, String> statsToPublish = new HashMap<String, String>();
            for (String statType : fspValue.getStoredStats()) {
                statsToPublish.put(statType, Long.toString(fspValue.stat.getStat(statType)));
            }
            if (statsPublisher.publishStat(prefix, statsToPublish)) continue;
            LOG.error("Failed to publish stats");
            if (!isStatsReliable) continue;
            throw new HiveException(ErrorMsg.STATSPUBLISHER_PUBLISHING_ERROR.getErrorCodedMsg());
        }
        sContext.setContextSuffix(this.getOperatorId());
        if (!statsPublisher.closeConnection(sContext)) {
            LOG.error("Failed to close stats");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_CLOSING_ERROR.getErrorCodedMsg());
            }
        }
    }

    private String[] splitKey(String fspKey) {
        if (!fspKey.isEmpty() && this.isSkewedStoredAsSubDirectories) {
            for (String dir : this.lbCtx.getSkewedValuesDirNames()) {
                int index = fspKey.indexOf(dir);
                if (index < 0) continue;
                return new String[]{fspKey.substring(0, index), fspKey.substring(index + 1)};
            }
        }
        return new String[]{fspKey, null};
    }

    private Configuration unsetNestedColumnPaths(Configuration conf) {
        if (conf.get("hive.io.file.readNestedColumn.paths") != null) {
            Configuration confCopy = new Configuration(conf);
            confCopy.unset("hive.io.file.readNestedColumn.paths");
            return confCopy;
        }
        return conf;
    }

    private boolean isNativeTable() {
        return !((FileSinkDesc)this.conf).getTableInfo().isNonNative();
    }

    public class FSPaths
    implements Cloneable {
        private Path tmpPathRoot;
        private String subdirBeforeTxn;
        private String subdirAfterTxn;
        private final String subdirForTxn;
        private Path taskOutputTempPathRoot;
        Path[] outPaths;
        Path[] finalPaths;
        RecordWriter[] outWriters;
        RecordUpdater[] updaters;
        Stat stat;
        int acidLastBucket = -1;
        int acidFileOffset = -1;
        private boolean isMmTable;
        String dpDirForCounters;

        public FSPaths(Path specPath, boolean isMmTable) {
            this.isMmTable = isMmTable;
            if (!isMmTable) {
                this.tmpPathRoot = Utilities.toTempPath(specPath);
                this.taskOutputTempPathRoot = Utilities.toTaskTempPath(specPath);
                this.subdirForTxn = null;
            } else {
                this.tmpPathRoot = specPath;
                this.taskOutputTempPathRoot = null;
                this.subdirForTxn = AcidUtils.baseOrDeltaSubdir(((FileSinkDesc)FileSinkOperator.this.conf).getInsertOverwrite(), ((FileSinkDesc)FileSinkOperator.this.conf).getTableWriteId(), ((FileSinkDesc)FileSinkOperator.this.conf).getTableWriteId(), ((FileSinkDesc)FileSinkOperator.this.conf).getStatementId());
            }
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("new FSPaths for " + FileSinkOperator.this.numFiles + " files, dynParts = " + FileSinkOperator.this.bDynParts + " (spec path " + specPath + ")");
            }
            this.outPaths = new Path[FileSinkOperator.this.numFiles];
            this.finalPaths = new Path[FileSinkOperator.this.numFiles];
            this.outWriters = new RecordWriter[FileSinkOperator.this.numFiles];
            this.updaters = new RecordUpdater[FileSinkOperator.this.numFiles];
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created slots for  " + FileSinkOperator.this.numFiles);
            }
            this.stat = new Stat();
        }

        public void closeWriters(boolean abort) throws HiveException {
            for (int idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    this.outWriters[idx].close(abort);
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
            try {
                for (int i = 0; i < this.updaters.length; ++i) {
                    if (this.updaters[i] == null) continue;
                    this.updaters[i].close(abort);
                }
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        }

        private void commit(FileSystem fs, List<Path> commitPaths) throws HiveException {
            for (int idx = 0; idx < this.outPaths.length; ++idx) {
                try {
                    if (this.outPaths[idx] == null) continue;
                    this.commitOneOutPath(idx, fs, commitPaths);
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException("Unable to commit output from: " + this.outPaths[idx] + " to: " + this.finalPaths[idx], e);
                }
            }
        }

        private void commitOneOutPath(int idx, FileSystem fs, List<Path> commitPaths) throws IOException, HiveException {
            if ((FileSinkOperator.this.bDynParts || FileSinkOperator.this.isSkewedStoredAsSubDirectories) && !fs.exists(this.finalPaths[idx].getParent())) {
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("commit making path for dyn/skew: " + this.finalPaths[idx].getParent());
                }
                FileUtils.mkdir((FileSystem)fs, (Path)this.finalPaths[idx].getParent(), (Configuration)FileSinkOperator.this.hconf);
            }
            if (this.outPaths[idx] != null && fs.exists(this.outPaths[idx])) {
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("committing " + this.outPaths[idx] + " to " + this.finalPaths[idx] + " (" + this.isMmTable + ")");
                }
                if (this.isMmTable) {
                    assert (this.outPaths[idx].equals((Object)this.finalPaths[idx]));
                    commitPaths.add(this.outPaths[idx]);
                } else if (!fs.rename(this.outPaths[idx], this.finalPaths[idx])) {
                    FileStatus fileStatus = FileUtils.getFileStatusOrNull((FileSystem)fs, (Path)this.finalPaths[idx]);
                    if (fileStatus != null) {
                        LOG.warn("Target path " + this.finalPaths[idx] + " with a size " + fileStatus.getLen() + " exists. Trying to delete it.");
                        if (!fs.delete(this.finalPaths[idx], true)) {
                            throw new HiveException("Unable to delete existing target output: " + this.finalPaths[idx]);
                        }
                    }
                    if (!fs.rename(this.outPaths[idx], this.finalPaths[idx])) {
                        throw new HiveException("Unable to rename output from: " + this.outPaths[idx] + " to: " + this.finalPaths[idx]);
                    }
                }
            }
            FileSinkOperator.this.updateProgress();
        }

        public void abortWriters(FileSystem fs, boolean abort, boolean delete) throws HiveException {
            for (int idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    this.outWriters[idx].close(abort);
                    if (delete) {
                        fs.delete(this.outPaths[idx], true);
                    }
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
        }

        public void initializeBucketPaths(int filesIdx, String taskId, boolean isNativeTable, boolean isSkewedStoredAsSubDirectories) {
            if (isNativeTable) {
                String taskWithExt;
                String extension = Utilities.getFileExtension(FileSinkOperator.this.jc, FileSinkOperator.this.isCompressed, FileSinkOperator.this.hiveOutputFormat);
                String string = taskWithExt = extension == null ? taskId : taskId + extension;
                if (!this.isMmTable) {
                    this.finalPaths[filesIdx] = !FileSinkOperator.this.bDynParts && !isSkewedStoredAsSubDirectories ? new Path(FileSinkOperator.this.parent, taskWithExt) : new Path(this.buildTmpPath(), taskWithExt);
                    this.outPaths[filesIdx] = new Path(this.buildTaskOutputTempPath(), Utilities.toTempPath(taskId));
                } else {
                    String taskIdPath = taskId;
                    if (((FileSinkDesc)FileSinkOperator.this.conf).isMerge()) {
                        taskIdPath = taskIdPath + ".merged";
                    }
                    if (extension != null) {
                        taskIdPath = taskIdPath + extension;
                    }
                    Path finalPath = new Path(this.buildTmpPath(), taskIdPath);
                    try {
                        FileSystem fpfs = finalPath.getFileSystem(FileSinkOperator.this.hconf);
                        if (fpfs.exists(finalPath)) {
                            throw new RuntimeException(finalPath + " already exists");
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.finalPaths[filesIdx] = finalPath;
                    this.outPaths[filesIdx] = finalPath;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("Final Path: FS " + this.finalPaths[filesIdx]);
                    if (LOG.isInfoEnabled() && !this.isMmTable) {
                        LOG.info("Writing to temp file: FS " + this.outPaths[filesIdx]);
                    }
                }
            } else {
                this.finalPaths[filesIdx] = this.outPaths[filesIdx] = FileSinkOperator.this.specPath;
            }
        }

        public Path buildTmpPath() {
            String pathStr = this.tmpPathRoot.toString();
            if (this.subdirBeforeTxn != null) {
                pathStr = pathStr + "/" + this.subdirBeforeTxn;
            }
            if (this.subdirForTxn != null) {
                pathStr = pathStr + "/" + this.subdirForTxn;
            }
            if (this.subdirAfterTxn != null) {
                pathStr = pathStr + "/" + this.subdirAfterTxn;
            }
            return new Path(pathStr);
        }

        public Path buildTaskOutputTempPath() {
            if (this.taskOutputTempPathRoot == null) {
                return null;
            }
            assert (this.subdirForTxn == null);
            String pathStr = this.taskOutputTempPathRoot.toString();
            if (this.subdirBeforeTxn != null) {
                pathStr = pathStr + "/" + this.subdirBeforeTxn;
            }
            if (this.subdirAfterTxn != null) {
                pathStr = pathStr + "/" + this.subdirAfterTxn;
            }
            return new Path(pathStr);
        }

        public void addToStat(String statType, long amount) {
            this.stat.addToStat(statType, amount);
        }

        public Collection<String> getStoredStats() {
            return this.stat.getStoredStats();
        }

        public int createDynamicBucket(int bucketNum) {
            int writerOffset = bucketNum;
            if (this.updaters.length <= writerOffset) {
                this.updaters = Arrays.copyOf(this.updaters, writerOffset + 1);
                this.outPaths = Arrays.copyOf(this.outPaths, writerOffset + 1);
                this.finalPaths = Arrays.copyOf(this.finalPaths, writerOffset + 1);
            }
            if (this.finalPaths[writerOffset] == null) {
                String bucketName = Utilities.replaceTaskIdFromFilename(Utilities.getTaskId(FileSinkOperator.this.hconf), bucketNum);
                this.finalPaths[writerOffset] = new Path(FileSinkOperator.this.bDynParts ? this.buildTmpPath() : FileSinkOperator.this.parent, bucketName);
                this.outPaths[writerOffset] = new Path(this.buildTaskOutputTempPath(), bucketName);
            }
            return writerOffset;
        }
    }

    public static interface RecordWriter {
        public void write(Writable var1) throws IOException;

        public void close(boolean var1) throws IOException;
    }

    public static enum Counter {
        RECORDS_OUT;

    }
}

