/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XConfiguration
extends Configuration {
    public static final String CONFIGURATION_SUBSTITUTE_DEPTH = "oozie.configuration.substitute.depth";
    private static Pattern varPat = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
    private static int MAX_SUBST = 20;
    protected static volatile boolean initalized = false;

    public XConfiguration() {
        super(false);
        XConfiguration.initSubstituteDepth();
    }

    public XConfiguration(InputStream is) throws IOException {
        this();
        this.parse(is);
    }

    public XConfiguration(Reader reader) throws IOException {
        this();
        this.parse(reader);
    }

    public XConfiguration(Properties props) {
        this();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public Properties toProperties() {
        Properties props = new Properties();
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return props;
    }

    public String get(String name) {
        return this.substituteVars(this.getRaw(name));
    }

    public String get(String name, String defaultValue) {
        String value = this.getRaw(name);
        value = value == null ? defaultValue : this.substituteVars(value);
        return value;
    }

    private static void initSubstituteDepth() {
        if (!initalized && Services.get() != null && Services.get().get(ConfigurationService.class) != null) {
            MAX_SUBST = ConfigurationService.getInt(CONFIGURATION_SUBSTITUTE_DEPTH);
            initalized = true;
        }
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        Matcher match = varPat.matcher("");
        String eval = expr;
        for (int s = 0; MAX_SUBST == -1 || s < MAX_SUBST; ++s) {
            match.reset(eval);
            if (!match.find()) {
                return eval;
            }
            String var = match.group();
            String val = this.getRaw(var = var.substring(2, var.length() - 1));
            if (val == null) {
                val = System.getProperty(var);
            }
            if (val == null) {
                return eval;
            }
            eval = eval.substring(0, match.start()) + val + eval.substring(match.end());
        }
        throw new IllegalStateException("Variable substitution depth too large: " + MAX_SUBST + " " + expr);
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        return super.getClassByName(name.trim());
    }

    public static void copy(Configuration source, Configuration target) {
        for (Map.Entry entry : source) {
            target.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void injectDefaults(Configuration source, Configuration target) {
        if (source != null) {
            for (Map.Entry entry : source) {
                if (target.get((String)entry.getKey()) != null) continue;
                target.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public XConfiguration trim() {
        XConfiguration trimmed = new XConfiguration();
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            trimmed.set((String)entry.getKey(), ((String)entry.getValue()).trim());
        }
        return trimmed;
    }

    public XConfiguration resolve() {
        XConfiguration resolved = new XConfiguration();
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            resolved.set((String)entry.getKey(), this.get((String)entry.getKey()));
        }
        return resolved;
    }

    private void parse(InputStream is) throws IOException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setXIncludeAware(true);
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setExpandEntityReferences(false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = builder.parse(is);
            this.parseDocument(doc);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    private void parse(Reader reader) throws IOException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setXIncludeAware(true);
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setExpandEntityReferences(false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(reader));
            this.parseDocument(doc);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    private void parseDocument(Document doc) throws IOException {
        Element root = doc.getDocumentElement();
        if (!"configuration".equals(root.getLocalName())) {
            throw new IOException("bad conf file: top-level element not <configuration>");
        }
        this.processNodes(root);
    }

    private void processNodes(Element root) throws IOException {
        try {
            NodeList props = root.getChildNodes();
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                Element prop = (Element)propNode;
                if (prop.getLocalName().equals("configuration")) {
                    this.processNodes(prop);
                    continue;
                }
                if (!"property".equals(prop.getLocalName())) {
                    throw new IOException("bad conf file: element not <property>");
                }
                NodeList fields = prop.getChildNodes();
                String attr = null;
                String value = null;
                for (int j = 0; j < fields.getLength(); ++j) {
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element)) continue;
                    Element field = (Element)fieldNode;
                    if ("name".equals(field.getLocalName()) && field.hasChildNodes()) {
                        attr = ((Text)field.getFirstChild()).getData().trim();
                    }
                    if (!"value".equals(field.getLocalName()) || !field.hasChildNodes()) continue;
                    value = ((Text)field.getFirstChild()).getData();
                }
                if (attr == null || value == null) continue;
                this.set(attr, value);
            }
        }
        catch (DOMException e) {
            throw new IOException(e);
        }
    }

    public String toXmlString() {
        return this.toXmlString(true);
    }

    public String toXmlString(boolean prolog) {
        String xml;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeXml(baos);
            baos.close();
            xml = new String(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException("It should not happen, " + ex.getMessage(), ex);
        }
        if (!prolog) {
            xml = xml.substring(xml.indexOf("<configuration>"));
        }
        return xml;
    }

    public String[] getTrimmedStrings(String name) {
        String[] values = this.getStrings(name);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
        }
        return values;
    }
}

