/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.coord.SyncCoordAction;
import org.apache.oozie.coord.SyncCoordDataset;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorUtil;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.jdom.JDOMException;

public class CoordELFunctions {
    public static final String DATASET = "oozie.coord.el.dataset.bean";
    public static final String COORD_ACTION = "oozie.coord.el.app.bean";
    public static final String CONFIGURATION = "oozie.coord.el.conf";
    public static final String LATEST_EL_USE_CURRENT_TIME = "oozie.service.ELService.latest-el.use-current-time";
    public static final String INSTANCE_SEPARATOR = "#";
    public static final String DIR_SEPARATOR = ",";
    private static String END_OF_OPERATION_INDICATOR_FILE = "_SUCCESS";
    public static final long MINUTE_MSEC = 60000L;
    public static final long HOUR_MSEC = 3600000L;
    public static final long DAY_MSEC = 86400000L;

    public static int ph1_coord_days(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.DAY);
        eval.setVariable("endOfDuration", (Object)TimeUnit.NONE);
        return val;
    }

    public static int ph1_coord_months(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.MONTH);
        eval.setVariable("endOfDuration", (Object)TimeUnit.NONE);
        return val;
    }

    public static int ph1_coord_hours(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.MINUTE);
        eval.setVariable("endOfDuration", (Object)TimeUnit.NONE);
        return val * 60;
    }

    public static int ph1_coord_minutes(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.MINUTE);
        eval.setVariable("endOfDuration", (Object)TimeUnit.NONE);
        return val;
    }

    public static int ph1_coord_endOfDays(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.DAY);
        eval.setVariable("endOfDuration", (Object)TimeUnit.END_OF_DAY);
        return val;
    }

    public static int ph1_coord_endOfMonths(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.MONTH);
        eval.setVariable("endOfDuration", (Object)TimeUnit.END_OF_MONTH);
        return val;
    }

    public static int ph2_coord_tzOffset() {
        long actionCreationTime = CoordELFunctions.getActionCreationtime().getTime();
        TimeZone dsTZ = ParamChecker.notNull(CoordELFunctions.getDatasetTZ(), "DatasetTZ");
        TimeZone jobTZ = ParamChecker.notNull(CoordELFunctions.getJobTZ(), "JobTZ");
        return (dsTZ.getOffset(actionCreationTime) - jobTZ.getOffset(actionCreationTime)) / 60000;
    }

    public static int ph3_coord_tzOffset() {
        return CoordELFunctions.ph2_coord_tzOffset();
    }

    public static String ph2_coord_dateOffset(String strBaseDate, int offset, String unit) throws Exception {
        Calendar baseCalDate = DateUtils.getCalendar(strBaseDate);
        StringBuilder buffer = new StringBuilder();
        baseCalDate.add(TimeUnit.valueOf(unit).getCalendarUnit(), offset);
        buffer.append(DateUtils.formatDateOozieTZ(baseCalDate));
        return buffer.toString();
    }

    public static String ph3_coord_dateOffset(String strBaseDate, int offset, String unit) throws Exception {
        return CoordELFunctions.ph2_coord_dateOffset(strBaseDate, offset, unit);
    }

    public static String ph2_coord_dateTzOffset(String strBaseDate, String timezone) throws Exception {
        Calendar baseCalDate = DateUtils.getCalendar(strBaseDate);
        StringBuilder buffer = new StringBuilder();
        baseCalDate.setTimeZone(DateUtils.getTimeZone(timezone));
        buffer.append(DateUtils.formatDate(baseCalDate));
        return buffer.toString();
    }

    public static String ph3_coord_dateTzOffset(String strBaseDate, String timezone) throws Exception {
        return CoordELFunctions.ph2_coord_dateTzOffset(strBaseDate, timezone);
    }

    public static String ph3_coord_future(int n, int instance) throws Exception {
        ParamChecker.checkGEZero(n, "future:n");
        ParamChecker.checkGTZero(instance, "future:instance");
        if (CoordELFunctions.isSyncDataSet()) {
            return CoordELFunctions.coord_future_sync(n, instance);
        }
        throw new UnsupportedOperationException("Asynchronous Dataset is not supported yet");
    }

    public static String ph3_coord_futureRange(int start, int end, int instance) throws Exception {
        ParamChecker.checkGEZero(start, "future:n");
        ParamChecker.checkGEZero(end, "future:n");
        ParamChecker.checkGTZero(instance, "future:instance");
        if (CoordELFunctions.isSyncDataSet()) {
            return CoordELFunctions.coord_futureRange_sync(start, end, instance);
        }
        throw new UnsupportedOperationException("Asynchronous Dataset is not supported yet");
    }

    private static String coord_future_sync(int n, int instance) throws Exception {
        return CoordELFunctions.coord_futureRange_sync(n, n, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String coord_futureRange_sync(int startOffset, int endOffset, int instance) throws Exception {
        XLog LOG = XLog.getLog(CoordELFunctions.class);
        Thread currentThread = Thread.currentThread();
        ELEvaluator eval = ELEvaluator.getCurrent();
        String retVal = "";
        int datasetFrequency = CoordELFunctions.getDSFrequency();
        TimeUnit dsTimeUnit = CoordELFunctions.getDSTimeUnit();
        int[] instCount = new int[1];
        Calendar nominalInstanceCal = CoordELFunctions.getCurrentInstance(CoordELFunctions.getActionCreationtime(), instCount);
        StringBuilder resolvedInstances = new StringBuilder();
        StringBuilder resolvedURIPaths = new StringBuilder();
        if (nominalInstanceCal != null) {
            Calendar initInstance = CoordELFunctions.getInitialInstanceCal();
            nominalInstanceCal = (Calendar)initInstance.clone();
            nominalInstanceCal.add(dsTimeUnit.getCalendarUnit(), instCount[0] * datasetFrequency);
            SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
            if (ds == null) {
                throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
            }
            String uriTemplate = ds.getUriTemplate();
            Configuration conf = (Configuration)eval.getVariable(CONFIGURATION);
            if (conf == null) {
                throw new RuntimeException("Associated Configuration should be defined with key oozie.coord.el.conf");
            }
            int available = 0;
            boolean resolved = false;
            String user = ParamChecker.notEmpty((String)eval.getVariable("user.name"), "user.name");
            String doneFlag = ds.getDoneFlag();
            URIHandlerService uriService = Services.get().get(URIHandlerService.class);
            URIHandler uriHandler = null;
            URIHandler.Context uriContext = null;
            try {
                for (int checkedInstance = 0; instance >= checkedInstance && !currentThread.isInterrupted(); ++checkedInstance) {
                    String uriWithDoneFlag;
                    ELEvaluator uriEval = CoordELFunctions.getUriEvaluator(nominalInstanceCal);
                    String uriPath = uriEval.evaluate(uriTemplate, String.class);
                    if (uriHandler == null) {
                        URI uri = new URI(uriPath);
                        uriHandler = uriService.getURIHandler(uri);
                        uriContext = uriHandler.getContext(uri, conf, user, true);
                    }
                    if (uriHandler.exists(new URI(uriWithDoneFlag = uriHandler.getURIWithDoneFlag(uriPath, doneFlag)), uriContext)) {
                        if (available == endOffset) {
                            LOG.debug("Matched future(" + available + "): " + uriWithDoneFlag);
                            resolved = true;
                            resolvedInstances.append(DateUtils.formatDateOozieTZ(nominalInstanceCal));
                            resolvedURIPaths.append(uriPath);
                            retVal = resolvedInstances.toString();
                            eval.setVariable("resolved_path", resolvedURIPaths.toString());
                            break;
                        }
                        if (available >= startOffset) {
                            LOG.debug("Matched future(" + available + "): " + uriWithDoneFlag);
                            resolvedInstances.append(DateUtils.formatDateOozieTZ(nominalInstanceCal)).append(INSTANCE_SEPARATOR);
                            resolvedURIPaths.append(uriPath).append(INSTANCE_SEPARATOR);
                        }
                        ++available;
                    }
                    nominalInstanceCal = (Calendar)initInstance.clone();
                    instCount[0] = instCount[0] + 1;
                    nominalInstanceCal.add(dsTimeUnit.getCalendarUnit(), instCount[0] * datasetFrequency);
                }
                if (!StringUtils.isEmpty((String)resolvedURIPaths.toString()) && eval.getVariable("resolved_path") == null) {
                    eval.setVariable("resolved_path", resolvedURIPaths.toString());
                }
            }
            finally {
                if (uriContext != null) {
                    uriContext.destroy();
                }
            }
            if (!resolved) {
                eval.setVariable("is_resolved", Boolean.FALSE);
                retVal = startOffset == endOffset ? "${coord:future(" + startOffset + ", " + instance + ")}" : "${coord:futureRange(" + startOffset + ", " + endOffset + ", " + instance + ")}";
            } else {
                eval.setVariable("is_resolved", Boolean.TRUE);
            }
        } else {
            eval.setVariable("is_resolved", Boolean.TRUE);
            retVal = "";
        }
        return retVal;
    }

    public static String ph2_coord_nominalTime() throws Exception {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction action = ParamChecker.notNull((SyncCoordAction)eval.getVariable(COORD_ACTION), "Coordinator Action");
        return DateUtils.formatDateOozieTZ(action.getNominalTime());
    }

    public static String ph3_coord_nominalTime() throws Exception {
        return CoordELFunctions.ph2_coord_nominalTime();
    }

    public static String ph2_coord_formatTime(String dateTimeStr, String format) throws Exception {
        Date dateTime = DateUtils.parseDateOozieTZ(dateTimeStr);
        return DateUtils.formatDateCustom(dateTime, format);
    }

    public static String ph3_coord_formatTime(String dateTimeStr, String format) throws Exception {
        return CoordELFunctions.ph2_coord_formatTime(dateTimeStr, format);
    }

    public static String ph2_coord_epochTime(String dateTimeStr, String millis) throws Exception {
        Date dateTime = DateUtils.parseDateOozieTZ(dateTimeStr);
        return DateUtils.formatDateEpoch(dateTime, Boolean.valueOf(millis));
    }

    public static String ph3_coord_epochTime(String dateTimeStr, String millis) throws Exception {
        return CoordELFunctions.ph2_coord_epochTime(dateTimeStr, millis);
    }

    public static String ph2_coord_actionId() throws Exception {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction action = ParamChecker.notNull((SyncCoordAction)eval.getVariable(COORD_ACTION), "Coordinator Action");
        return action.getActionId();
    }

    public static String ph3_coord_actionId() throws Exception {
        return CoordELFunctions.ph2_coord_actionId();
    }

    public static String ph2_coord_name() throws Exception {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction action = ParamChecker.notNull((SyncCoordAction)eval.getVariable(COORD_ACTION), "Coordinator Action");
        return action.getName();
    }

    public static String ph3_coord_name() throws Exception {
        return CoordELFunctions.ph2_coord_name();
    }

    public static String ph2_coord_actualTime() throws Exception {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction coordAction = (SyncCoordAction)eval.getVariable(COORD_ACTION);
        if (coordAction == null) {
            throw new RuntimeException("Associated Application instance should be defined with key oozie.coord.el.app.bean");
        }
        return DateUtils.formatDateOozieTZ(coordAction.getActualTime());
    }

    public static String ph3_coord_actualTime() throws Exception {
        return CoordELFunctions.ph2_coord_actualTime();
    }

    public static String ph3_coord_dataIn(String dataInName) {
        String uris = "";
        ELEvaluator eval = ELEvaluator.getCurrent();
        if (eval.getVariable(".datain." + dataInName) == null && eval.getVariable(".actionInputLogic") != null && !StringUtils.isEmpty((String)eval.getVariable(".actionInputLogic").toString())) {
            try {
                return new CoordInputLogicEvaluatorUtil().getInputDependencies(dataInName, (SyncCoordAction)eval.getVariable(COORD_ACTION));
            }
            catch (JDOMException e) {
                XLog.getLog(CoordELFunctions.class).error((Object)e);
                throw new RuntimeException(e.getMessage());
            }
        }
        uris = (String)eval.getVariable(".datain." + dataInName);
        Object unResolvedObj = eval.getVariable(".datain." + dataInName + ".unresolved");
        if (unResolvedObj == null) {
            return uris;
        }
        Boolean unresolved = Boolean.parseBoolean(unResolvedObj.toString());
        if (unresolved != null && unresolved.booleanValue()) {
            return "${coord:dataIn('" + dataInName + "')}";
        }
        return uris;
    }

    public static String ph3_coord_dataOut(String dataOutName) {
        String uris = "";
        ELEvaluator eval = ELEvaluator.getCurrent();
        uris = (String)eval.getVariable(".dataout." + dataOutName);
        return uris;
    }

    public static String ph2_coord_current(int n) throws Exception {
        if (CoordELFunctions.isSyncDataSet()) {
            return CoordELFunctions.coord_current_sync(n);
        }
        throw new UnsupportedOperationException("Asynchronous Dataset is not supported yet");
    }

    public static String ph2_coord_currentRange(int start, int end) throws Exception {
        if (CoordELFunctions.isSyncDataSet()) {
            return CoordELFunctions.coord_currentRange_sync(start, end);
        }
        throw new UnsupportedOperationException("Asynchronous Dataset is not supported yet");
    }

    public static String ph2_coord_offset(int n, String timeUnit) throws Exception {
        if (CoordELFunctions.isSyncDataSet()) {
            return CoordELFunctions.coord_offset_sync(n, timeUnit);
        }
        throw new UnsupportedOperationException("Asynchronous Dataset is not supported yet");
    }

    public static int ph2_coord_hoursInDay(int n) throws Exception {
        int datasetFrequency = CoordELFunctions.getDSFrequency();
        Calendar nominalInstanceCal = CoordELFunctions.getEffectiveNominalTime();
        if (nominalInstanceCal == null) {
            return -1;
        }
        nominalInstanceCal.add(CoordELFunctions.getDSTimeUnit().getCalendarUnit(), datasetFrequency * n);
        nominalInstanceCal.setTimeZone(CoordELFunctions.getDatasetTZ());
        return DateUtils.hoursInDay(nominalInstanceCal);
    }

    public static int ph3_coord_hoursInDay(int n) throws Exception {
        return CoordELFunctions.ph2_coord_hoursInDay(n);
    }

    public static int ph2_coord_daysInMonth(int n) throws Exception {
        int datasetFrequency = CoordELFunctions.getDSFrequency();
        Calendar nominalInstanceCal = CoordELFunctions.getEffectiveNominalTime();
        if (nominalInstanceCal == null) {
            return -1;
        }
        nominalInstanceCal.add(CoordELFunctions.getDSTimeUnit().getCalendarUnit(), datasetFrequency * n);
        nominalInstanceCal.setTimeZone(CoordELFunctions.getDatasetTZ());
        return nominalInstanceCal.getActualMaximum(5);
    }

    public static int ph3_coord_daysInMonth(int n) throws Exception {
        return CoordELFunctions.ph2_coord_daysInMonth(n);
    }

    public static String ph3_coord_latest(int n) throws Exception {
        ParamChecker.checkLEZero(n, "latest:n");
        if (CoordELFunctions.isSyncDataSet()) {
            return CoordELFunctions.coord_latest_sync(n);
        }
        throw new UnsupportedOperationException("Asynchronous Dataset is not supported yet");
    }

    public static String ph3_coord_latestRange(int start, int end) throws Exception {
        ParamChecker.checkLEZero(start, "latest:n");
        ParamChecker.checkLEZero(end, "latest:n");
        if (CoordELFunctions.isSyncDataSet()) {
            return CoordELFunctions.coord_latestRange_sync(start, end);
        }
        throw new UnsupportedOperationException("Asynchronous Dataset is not supported yet");
    }

    public static void configureEvaluator(ELEvaluator evaluator, SyncCoordDataset ds, SyncCoordAction coordAction) {
        evaluator.setVariable(COORD_ACTION, coordAction);
        evaluator.setVariable(DATASET, ds);
    }

    public static String evalAndWrap(ELEvaluator eval, String expr) throws Exception {
        try {
            eval.setVariable(".wrap", null);
            String result = eval.evaluate(expr, String.class);
            if (eval.getVariable(".wrap") != null) {
                return "${" + result + "}";
            }
            return result;
        }
        catch (Exception e) {
            throw new Exception("Unable to evaluate :" + expr + ":\n", e);
        }
    }

    public static String ph1_coord_current_echo(String n) {
        return CoordELFunctions.echoUnResolved("current", n);
    }

    public static String ph1_coord_absolute_echo(String date) {
        return CoordELFunctions.echoUnResolved("absolute", date);
    }

    public static String ph1_coord_currentRange_echo(String start, String end) {
        return CoordELFunctions.echoUnResolved("currentRange", start + ", " + end);
    }

    public static String ph1_coord_offset_echo(String n, String timeUnit) {
        return CoordELFunctions.echoUnResolved("offset", n + " , " + timeUnit);
    }

    public static String ph2_coord_current_echo(String n) {
        return CoordELFunctions.echoUnResolved("current", n);
    }

    public static String ph2_coord_currentRange_echo(String start, String end) {
        return CoordELFunctions.echoUnResolved("currentRange", start + ", " + end);
    }

    public static String ph2_coord_offset_echo(String n, String timeUnit) {
        return CoordELFunctions.echoUnResolved("offset", n + " , " + timeUnit);
    }

    public static String ph2_coord_absolute_echo(String date) {
        return CoordELFunctions.echoUnResolved("absolute", date);
    }

    public static String ph2_coord_absolute_range(String startInstance, int end) throws Exception {
        int[] instanceCount = new int[1];
        if (CoordELFunctions.getCurrentInstance(DateUtils.getCalendar(startInstance).getTime(), instanceCount) == null) {
            throw new CommandException(ErrorCode.E1010, "intial-instance should be equal or earlier than the start-instance. intial-instance is " + CoordELFunctions.getInitialInstance() + " and start-instance is " + startInstance);
        }
        int[] nominalCount = new int[1];
        if (CoordELFunctions.getCurrentInstance(CoordELFunctions.getActionCreationtime(), nominalCount) == null) {
            throw new CommandException(ErrorCode.E1010, "intial-instance should be equal or earlier than the nominal time. intial-instance is " + CoordELFunctions.getInitialInstance() + " and nominal time is " + CoordELFunctions.getActionCreationtime());
        }
        int start = instanceCount[0] - nominalCount[0];
        if (start > end) {
            throw new CommandException(ErrorCode.E1010, "start-instance should be equal or earlier than the end-instance. startInstance is " + startInstance + " which is equivalent to current (" + instanceCount[0] + ") but end is specified as current (" + end + ")");
        }
        return CoordELFunctions.ph2_coord_currentRange(start, end);
    }

    public static String ph1_coord_dateOffset_echo(String n, String offset, String unit) {
        return CoordELFunctions.echoUnResolved("dateOffset", n + " , " + offset + " , " + unit);
    }

    public static String ph1_coord_dateTzOffset_echo(String n, String timezone) {
        return CoordELFunctions.echoUnResolved("dateTzOffset", n + " , " + timezone);
    }

    public static String ph1_coord_epochTime_echo(String dateTime, String millis) {
        return CoordELFunctions.echoUnResolved("epochTime", "'" + dateTime + "'" + " , " + millis);
    }

    public static String ph1_coord_formatTime_echo(String dateTime, String format) {
        return CoordELFunctions.echoUnResolved("formatTime", "'" + dateTime + "'" + " , " + format);
    }

    public static String ph1_coord_latest_echo(String n) {
        return CoordELFunctions.echoUnResolved("latest", n);
    }

    public static String ph2_coord_latest_echo(String n) {
        return CoordELFunctions.ph1_coord_latest_echo(n);
    }

    public static String ph1_coord_future_echo(String n, String instance) {
        return CoordELFunctions.echoUnResolved("future", n + ", " + instance + "");
    }

    public static String ph2_coord_future_echo(String n, String instance) {
        return CoordELFunctions.ph1_coord_future_echo(n, instance);
    }

    public static String ph1_coord_latestRange_echo(String start, String end) {
        return CoordELFunctions.echoUnResolved("latestRange", start + ", " + end);
    }

    public static String ph2_coord_latestRange_echo(String start, String end) {
        return CoordELFunctions.ph1_coord_latestRange_echo(start, end);
    }

    public static String ph1_coord_futureRange_echo(String start, String end, String instance) {
        return CoordELFunctions.echoUnResolved("futureRange", start + ", " + end + ", " + instance);
    }

    public static String ph2_coord_futureRange_echo(String start, String end, String instance) {
        return CoordELFunctions.ph1_coord_futureRange_echo(start, end, instance);
    }

    public static String ph1_coord_dataIn_echo(String n) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String val = (String)eval.getVariable("oozie.dataname." + n);
        if (val == null || !val.equals("data-in")) {
            XLog.getLog(CoordELFunctions.class).error("data_in_name " + n + " is not valid");
            throw new RuntimeException("data_in_name " + n + " is not valid");
        }
        return CoordELFunctions.echoUnResolved("dataIn", "'" + n + "'");
    }

    public static String ph1_coord_dataOut_echo(String n) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String val = (String)eval.getVariable("oozie.dataname." + n);
        if (val == null || !val.equals("data-out")) {
            XLog.getLog(CoordELFunctions.class).error("data_out_name " + n + " is not valid");
            throw new RuntimeException("data_out_name " + n + " is not valid");
        }
        return CoordELFunctions.echoUnResolved("dataOut", "'" + n + "'");
    }

    public static String ph1_coord_nominalTime_echo() {
        return CoordELFunctions.echoUnResolved("nominalTime", "");
    }

    public static String ph1_coord_nominalTime_echo_wrap() {
        return CoordELFunctions.echoUnResolved("nominalTime", "");
    }

    public static String ph1_coord_nominalTime_echo_fixed() {
        return "2009-03-06T010:00";
    }

    public static String ph1_coord_actualTime_echo_wrap() {
        return CoordELFunctions.echoUnResolved("actualTime", "");
    }

    public static String ph1_coord_actionId_echo() {
        return CoordELFunctions.echoUnResolved("actionId", "");
    }

    public static String ph1_coord_name_echo() {
        return CoordELFunctions.echoUnResolved("name", "");
    }

    public static String coord_minutes_echo(String n) {
        return CoordELFunctions.echoUnResolved("minutes", n);
    }

    public static String coord_hours_echo(String n) {
        return CoordELFunctions.echoUnResolved("hours", n);
    }

    public static String coord_days_echo(String n) {
        return CoordELFunctions.echoUnResolved("days", n);
    }

    public static String coord_endOfDay_echo(String n) {
        return CoordELFunctions.echoUnResolved("endOfDay", n);
    }

    public static String coord_months_echo(String n) {
        return CoordELFunctions.echoUnResolved("months", n);
    }

    public static String coord_endOfMonth_echo(String n) {
        return CoordELFunctions.echoUnResolved("endOfMonth", n);
    }

    public static String coord_actualTime_echo() {
        return CoordELFunctions.echoUnResolved("actualTime", "");
    }

    public static String ph1_coord_hoursInDay_echo(String n) {
        return "24";
    }

    public static String ph1_coord_daysInMonth_echo(String n) {
        return "30";
    }

    public static String ph1_coord_tzOffset_echo() {
        return "3";
    }

    private static String coord_current_sync(int n) throws Exception {
        return CoordELFunctions.coord_currentRange_sync(n, n);
    }

    private static String coord_currentRange_sync(int start, int end) throws Exception {
        XLog LOG = XLog.getLog(CoordELFunctions.class);
        int datasetFrequency = CoordELFunctions.getDSFrequency();
        TimeUnit dsTimeUnit = CoordELFunctions.getDSTimeUnit();
        int[] instCount = new int[1];
        Calendar nominalInstanceCal = CoordELFunctions.getCurrentInstance(CoordELFunctions.getActionCreationtime(), instCount);
        if (nominalInstanceCal == null) {
            LOG.warn("If the initial instance of the dataset is later than the nominal time, an empty string is returned. This means that no data is available at the current-instance specified by the user and the user could try modifying his initial-instance to an earlier time.");
            return "";
        }
        Calendar initInstance = CoordELFunctions.getInitialInstanceCal();
        nominalInstanceCal = (Calendar)initInstance.clone();
        nominalInstanceCal.add(dsTimeUnit.getCalendarUnit(), (instCount[0] + start) * datasetFrequency);
        List<String> instances = new ArrayList();
        for (int i = start; i <= end; ++i) {
            if (nominalInstanceCal.compareTo(initInstance) < 0) {
                LOG.warn("If the initial instance of the dataset is later than the current-instance specified, such as coord:current({0}) in this case, an empty string is returned. This means that no data is available at the current-instance specified by the user and the user could try modifying his initial-instance to an earlier time.", start);
            } else {
                instances.add(DateUtils.formatDateOozieTZ(nominalInstanceCal));
            }
            nominalInstanceCal.add(dsTimeUnit.getCalendarUnit(), datasetFrequency);
        }
        instances = Lists.reverse(instances);
        return StringUtils.join(instances, (String)INSTANCE_SEPARATOR);
    }

    private static String coord_offset_sync(int n, String timeUnit) throws Exception {
        Calendar rawCal = CoordELFunctions.resolveOffsetRawTime(n, TimeUnit.valueOf(timeUnit), null);
        if (rawCal == null) {
            return "";
        }
        int freq = CoordELFunctions.getDSFrequency();
        TimeUnit freqUnit = CoordELFunctions.getDSTimeUnit();
        int freqCount = 0;
        Calendar cal = CoordELFunctions.getInitialInstanceCal();
        if (rawCal.before(cal)) {
            while (cal.after(rawCal)) {
                cal.add(freqUnit.getCalendarUnit(), -freq);
                --freqCount;
            }
        } else if (rawCal.after(cal)) {
            while (cal.before(rawCal)) {
                cal.add(freqUnit.getCalendarUnit(), freq);
                ++freqCount;
            }
        }
        if (cal.before(rawCal)) {
            rawCal = cal;
        } else if (cal.after(rawCal)) {
            cal.add(freqUnit.getCalendarUnit(), -freq);
            rawCal = cal;
            --freqCount;
        }
        String rawCalStr = DateUtils.formatDateOozieTZ(rawCal);
        Calendar nominalInstanceCal = CoordELFunctions.getInitialInstanceCal();
        nominalInstanceCal.add(freqUnit.getCalendarUnit(), freq * freqCount);
        if (nominalInstanceCal.getTime().compareTo(CoordELFunctions.getInitialInstance()) < 0) {
            XLog.getLog(CoordELFunctions.class).warn("If the initial instance of the dataset is later than the offset instance specified, such as coord:offset({0}, {1}) in this case, an empty string is returned. This means that no data is available at the offset instance specified by the user and the user could try modifying his initial-instance to an earlier time.", n, timeUnit);
            return "";
        }
        String nominalCalStr = DateUtils.formatDateOozieTZ(nominalInstanceCal);
        if (!rawCalStr.equals(nominalCalStr)) {
            throw new RuntimeException("Shouldn't happen");
        }
        return rawCalStr;
    }

    private static String coord_latest_sync(int offset) throws Exception {
        return CoordELFunctions.coord_latestRange_sync(offset, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String coord_latestRange_sync(int startOffset, int endOffset) throws Exception {
        XLog LOG = XLog.getLog(CoordELFunctions.class);
        Thread currentThread = Thread.currentThread();
        ELEvaluator eval = ELEvaluator.getCurrent();
        String retVal = "";
        int datasetFrequency = CoordELFunctions.getDSFrequency();
        TimeUnit dsTimeUnit = CoordELFunctions.getDSTimeUnit();
        int[] instCount = new int[1];
        boolean useCurrentTime = Services.get().getConf().getBoolean(LATEST_EL_USE_CURRENT_TIME, false);
        Calendar nominalInstanceCal = useCurrentTime ? CoordELFunctions.getCurrentInstance(new Date(), instCount) : CoordELFunctions.getCurrentInstance(CoordELFunctions.getActualTime(), instCount);
        StringBuilder resolvedInstances = new StringBuilder();
        StringBuilder resolvedURIPaths = new StringBuilder();
        if (nominalInstanceCal != null) {
            Calendar initInstance = CoordELFunctions.getInitialInstanceCal();
            SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
            if (ds == null) {
                throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
            }
            String uriTemplate = ds.getUriTemplate();
            Configuration conf = (Configuration)eval.getVariable(CONFIGURATION);
            if (conf == null) {
                throw new RuntimeException("Associated Configuration should be defined with key oozie.coord.el.conf");
            }
            int available = 0;
            boolean resolved = false;
            String user = ParamChecker.notEmpty((String)eval.getVariable("user.name"), "user.name");
            String doneFlag = ds.getDoneFlag();
            URIHandlerService uriService = Services.get().get(URIHandlerService.class);
            URIHandler uriHandler = null;
            URIHandler.Context uriContext = null;
            try {
                while (nominalInstanceCal.compareTo(initInstance) >= 0 && !currentThread.isInterrupted()) {
                    String uriWithDoneFlag;
                    ELEvaluator uriEval = CoordELFunctions.getUriEvaluator(nominalInstanceCal);
                    String uriPath = uriEval.evaluate(uriTemplate, String.class);
                    if (uriHandler == null) {
                        URI uri = new URI(uriPath);
                        uriHandler = uriService.getURIHandler(uri);
                        uriContext = uriHandler.getContext(uri, conf, user, true);
                    }
                    if (uriHandler.exists(new URI(uriWithDoneFlag = uriHandler.getURIWithDoneFlag(uriPath, doneFlag)), uriContext)) {
                        XLog.getLog(CoordELFunctions.class).debug("Found latest(" + available + "): " + uriWithDoneFlag);
                        if (available == startOffset) {
                            LOG.debug("Matched latest(" + available + "): " + uriWithDoneFlag);
                            resolved = true;
                            resolvedInstances.append(DateUtils.formatDateOozieTZ(nominalInstanceCal));
                            resolvedURIPaths.append(uriPath);
                            retVal = resolvedInstances.toString();
                            eval.setVariable("resolved_path", resolvedURIPaths.toString());
                            break;
                        }
                        if (available <= endOffset) {
                            LOG.debug("Matched latest(" + available + "): " + uriWithDoneFlag);
                            resolvedInstances.append(DateUtils.formatDateOozieTZ(nominalInstanceCal)).append(INSTANCE_SEPARATOR);
                            resolvedURIPaths.append(uriPath).append(INSTANCE_SEPARATOR);
                        }
                        --available;
                    }
                    nominalInstanceCal = (Calendar)initInstance.clone();
                    instCount[0] = instCount[0] - 1;
                    nominalInstanceCal.add(dsTimeUnit.getCalendarUnit(), instCount[0] * datasetFrequency);
                }
                if (!StringUtils.isEmpty((String)resolvedURIPaths.toString()) && eval.getVariable("resolved_path") == null) {
                    eval.setVariable("resolved_path", resolvedURIPaths.toString());
                }
            }
            finally {
                if (uriContext != null) {
                    uriContext.destroy();
                }
            }
            if (!resolved) {
                eval.setVariable("is_resolved", Boolean.FALSE);
                retVal = startOffset == endOffset ? "${coord:latest(" + startOffset + ")}" : "${coord:latestRange(" + startOffset + DIR_SEPARATOR + endOffset + ")}";
            } else {
                eval.setVariable("is_resolved", Boolean.TRUE);
            }
        } else {
            eval.setVariable("is_resolved", Boolean.FALSE);
        }
        return retVal;
    }

    private static ELEvaluator getUriEvaluator(Calendar tm) {
        tm.setTimeZone(DateUtils.getOozieProcessingTimeZone());
        ELEvaluator retEval = new ELEvaluator();
        retEval.setVariable("YEAR", tm.get(1));
        retEval.setVariable("MONTH", tm.get(2) + 1 < 10 ? "0" + (tm.get(2) + 1) : Integer.valueOf(tm.get(2) + 1));
        retEval.setVariable("DAY", tm.get(5) < 10 ? "0" + tm.get(5) : Integer.valueOf(tm.get(5)));
        retEval.setVariable("HOUR", tm.get(11) < 10 ? "0" + tm.get(11) : Integer.valueOf(tm.get(11)));
        retEval.setVariable("MINUTE", tm.get(12) < 10 ? "0" + tm.get(12) : Integer.valueOf(tm.get(12)));
        return retEval;
    }

    private static boolean isSyncDataSet() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        return ds.getType().equalsIgnoreCase("SYNC");
    }

    private static String checkIfResolved(String functionName, String n) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String replace = (String)eval.getVariable("resolve_" + functionName);
        if (replace == null || replace != null && replace.equalsIgnoreCase("false")) {
            eval.setVariable(".wrap", "true");
            return "coord:" + functionName + "(" + n + ")";
        }
        return null;
    }

    private static String echoUnResolved(String functionName, String n) {
        return CoordELFunctions.echoUnResolvedPre(functionName, n, "coord:");
    }

    private static String echoUnResolvedPre(String functionName, String n, String prefix) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable(".wrap", "true");
        return prefix + functionName + "(" + n + ")";
    }

    private static Date getInitialInstance() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return CoordELFunctions.getInitialInstance(eval);
    }

    private static Date getInitialInstance(ELEvaluator eval) {
        return CoordELFunctions.getInitialInstanceCal(eval).getTime();
    }

    private static Calendar getInitialInstanceCal() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return CoordELFunctions.getInitialInstanceCal(eval);
    }

    private static Calendar getInitialInstanceCal(ELEvaluator eval) {
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        GregorianCalendar effInitTS = new GregorianCalendar(ds.getTimeZone());
        effInitTS.setTime(ds.getInitInstance());
        DateUtils.moveToEnd(effInitTS, CoordELFunctions.getDSEndOfFlag(eval));
        return effInitTS;
    }

    private static Date getActionCreationtime() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return CoordELFunctions.getActionCreationtime(eval);
    }

    private static Date getActionCreationtime(ELEvaluator eval) {
        SyncCoordAction coordAction = (SyncCoordAction)eval.getVariable(COORD_ACTION);
        if (coordAction == null) {
            throw new RuntimeException("Associated Application instance should be defined with key oozie.coord.el.app.bean");
        }
        return coordAction.getNominalTime();
    }

    private static Date getActualTime() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction coordAction = (SyncCoordAction)eval.getVariable(COORD_ACTION);
        if (coordAction == null) {
            throw new RuntimeException("Associated Application instance should be defined with key oozie.coord.el.app.bean");
        }
        return coordAction.getActualTime();
    }

    private static TimeZone getJobTZ() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction coordAction = (SyncCoordAction)eval.getVariable(COORD_ACTION);
        if (coordAction == null) {
            throw new RuntimeException("Associated Application instance should be defined with key oozie.coord.el.app.bean");
        }
        return coordAction.getTimeZone();
    }

    public static Calendar getCurrentInstance(Date effectiveTime, int[] instanceCount) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return CoordELFunctions.getCurrentInstance(effectiveTime, instanceCount, eval);
    }

    private static Calendar getCurrentInstance(Date effectiveTime, int[] instanceCount, ELEvaluator eval) {
        Date datasetInitialInstance = CoordELFunctions.getInitialInstance(eval);
        TimeUnit dsTimeUnit = CoordELFunctions.getDSTimeUnit(eval);
        TimeZone dsTZ = CoordELFunctions.getDatasetTZ(eval);
        int dsFreq = CoordELFunctions.getDSFrequency(eval);
        Calendar current = Calendar.getInstance(dsTZ);
        current.setTime(datasetInitialInstance);
        GregorianCalendar calEffectiveTime = new GregorianCalendar(dsTZ);
        calEffectiveTime.setTime(effectiveTime);
        if (instanceCount == null) {
            instanceCount = new int[]{0};
        }
        if (current.compareTo(calEffectiveTime) > 0) {
            return null;
        }
        switch (dsTimeUnit) {
            case MINUTE: {
                instanceCount[0] = (int)((effectiveTime.getTime() - datasetInitialInstance.getTime()) / 60000L);
                break;
            }
            case HOUR: {
                instanceCount[0] = (int)((effectiveTime.getTime() - datasetInitialInstance.getTime()) / 3600000L);
                break;
            }
            case DAY: 
            case END_OF_DAY: {
                instanceCount[0] = (int)((effectiveTime.getTime() - datasetInitialInstance.getTime()) / 86400000L);
                break;
            }
            case MONTH: 
            case END_OF_MONTH: {
                int diffYear = calEffectiveTime.get(1) - current.get(1);
                instanceCount[0] = diffYear * 12 + calEffectiveTime.get(2) - current.get(2);
                break;
            }
            case YEAR: {
                instanceCount[0] = calEffectiveTime.get(1) - current.get(1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled dataset time unit " + (Object)((Object)dsTimeUnit));
            }
        }
        if (instanceCount[0] > 2) {
            instanceCount[0] = instanceCount[0] / dsFreq;
            current.add(dsTimeUnit.getCalendarUnit(), instanceCount[0] * dsFreq);
        } else {
            instanceCount[0] = 0;
        }
        while (!current.getTime().after(effectiveTime)) {
            current.add(dsTimeUnit.getCalendarUnit(), dsFreq);
            instanceCount[0] = instanceCount[0] + 1;
        }
        current.add(dsTimeUnit.getCalendarUnit(), -dsFreq);
        instanceCount[0] = instanceCount[0] - 1;
        return current;
    }

    private static Calendar getCurrentInstance_old(Date effectiveTime, int[] instanceCount, ELEvaluator eval) {
        Date datasetInitialInstance = CoordELFunctions.getInitialInstance(eval);
        TimeUnit dsTimeUnit = CoordELFunctions.getDSTimeUnit(eval);
        TimeZone dsTZ = CoordELFunctions.getDatasetTZ(eval);
        int dsFreq = CoordELFunctions.getDSFrequency(eval);
        Calendar current = Calendar.getInstance();
        current.setTime(datasetInitialInstance);
        current.setTimeZone(dsTZ);
        Calendar calEffectiveTime = Calendar.getInstance();
        calEffectiveTime.setTime(effectiveTime);
        calEffectiveTime.setTimeZone(dsTZ);
        if (instanceCount == null) {
            instanceCount = new int[]{0};
        }
        if (current.compareTo(calEffectiveTime) > 0) {
            return null;
        }
        Calendar origCurrent = (Calendar)current.clone();
        while (current.compareTo(calEffectiveTime) <= 0) {
            current = (Calendar)origCurrent.clone();
            instanceCount[0] = instanceCount[0] + 1;
            current.add(dsTimeUnit.getCalendarUnit(), instanceCount[0] * dsFreq);
        }
        instanceCount[0] = instanceCount[0] - 1;
        current = (Calendar)origCurrent.clone();
        current.add(dsTimeUnit.getCalendarUnit(), instanceCount[0] * dsFreq);
        return current;
    }

    public static Calendar getEffectiveNominalTime() {
        Date datasetInitialInstance = CoordELFunctions.getInitialInstance();
        TimeZone dsTZ = CoordELFunctions.getDatasetTZ();
        Calendar current = Calendar.getInstance();
        current.setTime(datasetInitialInstance);
        current.setTimeZone(dsTZ);
        Calendar calEffectiveTime = Calendar.getInstance();
        calEffectiveTime.setTime(CoordELFunctions.getActionCreationtime());
        calEffectiveTime.setTimeZone(dsTZ);
        if (current.compareTo(calEffectiveTime) > 0) {
            return null;
        }
        return calEffectiveTime;
    }

    private static int getDSFrequency() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return CoordELFunctions.getDSFrequency(eval);
    }

    private static int getDSFrequency(ELEvaluator eval) {
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        return ds.getFrequency();
    }

    private static TimeUnit getDSTimeUnit() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return CoordELFunctions.getDSTimeUnit(eval);
    }

    public static TimeUnit getDSTimeUnit(ELEvaluator eval) {
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        return ds.getTimeUnit();
    }

    public static TimeZone getDatasetTZ() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return CoordELFunctions.getDatasetTZ(eval);
    }

    private static TimeZone getDatasetTZ(ELEvaluator eval) {
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        return ds.getTimeZone();
    }

    private static TimeUnit getDSEndOfFlag() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return CoordELFunctions.getDSEndOfFlag(eval);
    }

    private static TimeUnit getDSEndOfFlag(ELEvaluator eval) {
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        return ds.getEndOfDuration();
    }

    public static String coord_conf(String property) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return (String)eval.getVariable(property);
    }

    public static String coord_user() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return (String)eval.getVariable("user.name");
    }

    public static List<Integer> expandOffsetTimes(Calendar startCal, Calendar endCal, ELEvaluator eval) {
        ArrayList<Integer> expandedFreqs = new ArrayList<Integer>();
        int freq = CoordELFunctions.getDSFrequency(eval);
        TimeUnit freqUnit = CoordELFunctions.getDSTimeUnit(eval);
        Calendar cal = CoordELFunctions.getCurrentInstance(CoordELFunctions.getActionCreationtime(eval), null, eval);
        int totalFreq = 0;
        if (startCal.before(cal)) {
            while (cal.after(startCal)) {
                cal.add(freqUnit.getCalendarUnit(), -freq);
                totalFreq += -freq;
            }
            if (cal.before(startCal)) {
                cal.add(freqUnit.getCalendarUnit(), freq);
                totalFreq += freq;
            }
        } else if (startCal.after(cal)) {
            while (cal.before(startCal)) {
                cal.add(freqUnit.getCalendarUnit(), freq);
                totalFreq += freq;
            }
        }
        while (cal.before(endCal) || cal.equals(endCal)) {
            expandedFreqs.add(totalFreq);
            cal.add(freqUnit.getCalendarUnit(), freq);
            totalFreq += freq;
        }
        return expandedFreqs;
    }

    public static Calendar resolveOffsetRawTime(int n, TimeUnit timeUnit, ELEvaluator eval) {
        Calendar cal = eval == null ? CoordELFunctions.getCurrentInstance(CoordELFunctions.getActionCreationtime(), null) : CoordELFunctions.getCurrentInstance(CoordELFunctions.getActionCreationtime(eval), null, eval);
        if (cal == null) {
            XLog.getLog(CoordELFunctions.class).warn("If the initial instance of the dataset is later than the nominal time, an empty string is returned. This means that no data is available at the offset instance specified by the user and the user could try modifying his or her initial-instance to an earlier time.");
            return null;
        }
        cal.add(timeUnit.getCalendarUnit(), n);
        return cal;
    }
}

