/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.util.web;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.pentaho.marketplace.util.web.HttpClientManager;

public class HttpUtil {
    private static final String PROXY_HOST_PROPERTY_NAME = "http.proxyHost";
    private static final String PROXY_PORT_PROPERTY_NAME = "http.proxyPort";
    private static final String PROXY_USER_PROPERTY_NAME = "http.proxyUser";
    private static final String PROXY_PASSWORD_PROPERTY_NAME = "http.proxyPassword";
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int PAGE_TIMEOUT = 7000;
    private static Log logger = LogFactory.getLog(HttpUtil.class);

    public static HttpClient getClient() {
        CloseableHttpClient client = null;
        LaxRedirectStrategy strategy = new LaxRedirectStrategy();
        HttpClientManager httpClientManager = HttpClientManager.getInstance();
        HttpClientManager.HttpClientBuilderFacade clientBuilder = httpClientManager.createBuilder();
        clientBuilder.setSocketTimeout(7000).setConnectionTimeout(3000).setRedirect((RedirectStrategy)strategy);
        try {
            String proxyHost = System.getProperty(PROXY_HOST_PROPERTY_NAME);
            int proxyPort = Integer.parseInt(System.getProperty(PROXY_PORT_PROPERTY_NAME));
            if (StringUtils.isNotEmpty((String)proxyHost)) {
                clientBuilder.setProxy(proxyHost, proxyPort);
                String proxyUser = System.getProperty(PROXY_USER_PROPERTY_NAME);
                String proxyPassword = System.getProperty(PROXY_PASSWORD_PROPERTY_NAME);
                if (StringUtils.isNotBlank((String)proxyUser)) {
                    AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                    clientBuilder.setCredentials(proxyUser, proxyPassword, authScope);
                }
            }
            client = clientBuilder.build();
        }
        catch (Exception ignored) {
            logger.debug((Object)"Cannot create custom HttpClient.");
        }
        if (client == null) {
            logger.debug((Object)"Trying create default HttpClient.");
            client = httpClientManager.createDefaultClient();
        }
        return client;
    }

    public static boolean getURLContent(String url, StringBuffer content) {
        InputStream response = HttpUtil.getURLInputStream(url);
        if (response == null) {
            return false;
        }
        try {
            byte[] buffer = new byte[2048];
            int size = response.read(buffer);
            while (size > 0) {
                for (int idx = 0; idx < size; ++idx) {
                    content.append((char)buffer[idx]);
                }
                size = response.read(buffer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static String getURLContent(String uri) {
        StringBuffer content = new StringBuffer();
        HttpUtil.getURLContent(uri, content);
        return content.toString();
    }

    public static InputStream getURLInputStream(String url) {
        HttpClient client = HttpUtil.getClient();
        try {
            HttpGet call = new HttpGet(url);
            HttpResponse response = client.execute((HttpUriRequest)call);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                return response.getEntity().getContent();
            }
            logger.debug((Object)("The status code is not \"ok\": " + status));
            return null;
        }
        catch (Throwable e) {
            logger.debug((Object)("Unable to get input stream from " + url), e);
            return null;
        }
    }

    public static InputStream getURLInputStream(URL url) {
        return HttpUtil.getURLInputStream(url.toString());
    }

    public static Reader getURLReader(String uri) {
        InputStream inputStream = HttpUtil.getURLInputStream(uri);
        if (inputStream != null) {
            return new InputStreamReader(inputStream);
        }
        return null;
    }

    public static Map parseQueryString(String s) {
        String[] valArray = null;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String[]> rtn = new HashMap<String, String[]>();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            String key = HttpUtil.parseName(pair.substring(0, pos), sb);
            String val = HttpUtil.parseName(pair.substring(pos + 1, pair.length()), sb);
            if (rtn.containsKey(key)) {
                String[] oldVals = (String[])rtn.get(key);
                valArray = new String[oldVals.length + 1];
                System.arraycopy(oldVals, 0, valArray, 0, oldVals.length);
                valArray[oldVals.length] = val;
            } else {
                valArray = new String[]{val};
            }
            rtn.put(key, valArray);
        }
        return rtn;
    }

    private static String parseName(String s, StringBuffer sb) {
        sb.setLength(0);
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException numberformatexception) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException oob) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

