/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rules;

import java.util.Arrays;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rules.Rules;
import org.pentaho.di.trans.steps.rules.RulesExecutorData;
import org.pentaho.di.trans.steps.rules.RulesExecutorMeta;

public class RulesExecutor
extends BaseStep
implements StepInterface {
    private RulesExecutorMeta meta;
    private RulesExecutorData data;

    public RulesExecutor(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RulesExecutorMeta)smi;
        this.data = (RulesExecutorData)sdi;
        return super.init(smi, sdi);
    }

    public boolean runtimeInit() throws KettleStepException {
        this.data.setOutputRowMeta(this.getInputRowMeta().clone());
        this.meta.getFields(this.data.getOutputRowMeta(), this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
        this.data.setRuleFilePath(this.meta.getRuleFile());
        this.data.setRuleString(this.meta.getRuleDefinition());
        this.data.initializeRules();
        this.data.initializeColumns(this.getInputRowMeta());
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RulesExecutorMeta)smi;
        this.data = (RulesExecutorData)sdi;
        super.dispose(smi, sdi);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRow;
        this.meta = (RulesExecutorMeta)smi;
        this.data = (RulesExecutorData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.data.shutdown();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            if (!this.runtimeInit()) {
                return false;
            }
            this.first = false;
        }
        this.data.loadRow(r);
        this.data.execute();
        int beginOutputRowFill = 0;
        String[] expectedResults = this.meta.getExpectedResultList();
        if (this.meta.isKeepInputFields()) {
            int inputRowSize = this.getInputRowMeta().size();
            outputRow = Arrays.copyOf(r, inputRowSize + expectedResults.length);
            beginOutputRowFill = inputRowSize;
        } else {
            outputRow = new Object[expectedResults.length];
        }
        Rules.Column result = null;
        for (int i = 0; i < expectedResults.length; ++i) {
            result = (Rules.Column)this.data.fetchResult(expectedResults[i]);
            outputRow[i + beginOutputRowFill] = result == null ? null : result.getPayload();
        }
        this.putRow(this.data.getOutputRowMeta(), outputRow);
        return true;
    }
}

