/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.palo.JobEntryCubeDelete;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.palo.JobEntryCubeDelete.PaloCubeDelete;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.palo.core.PaloNameComparator;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class PaloCubeDeleteDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = PaloCubeDelete.class;
    private Text textStepName;
    private Label labelStepName;
    private CCombo addConnectionLine;
    private Label labelCubeName;
    private CCombo comboCubeName;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private PaloCubeDelete jobEntry;
    private Shell shell;
    private PropsUI props = PropsUI.getInstance();
    private SelectionAdapter lsDef;
    private boolean changed;
    private JobMeta jobMeta;

    public PaloCubeDeleteDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (PaloCubeDelete)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(jobEntryInt.getName());
        }
        this.jobMeta = jobMeta;
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage((Shell)this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PaloCubeDeleteDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PaloCubeDeleteDialog.PaloCubeDelete", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.labelStepName = new Label((Composite)this.shell, 131072);
        this.labelStepName.setText(BaseMessages.getString(PKG, (String)"PaloCubeDeleteDialog.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.labelStepName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.labelStepName.setLayoutData((Object)fd);
        this.textStepName = new Text((Composite)this.shell, 18436);
        this.textStepName.setText(this.jobEntry.getName());
        this.props.setLook((Control)this.textStepName);
        this.textStepName.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, 0);
        this.textStepName.setLayoutData((Object)fd);
        this.addConnectionLine = this.addConnectionLine((Composite)this.shell, (Control)this.textStepName, 35, margin);
        this.props.setLook((Control)this.addConnectionLine);
        this.addConnectionLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCubeDeleteDialog.this.doSelectConnection(false);
            }
        });
        this.labelCubeName = new Label((Composite)this.shell, 131072);
        this.labelCubeName.setText(BaseMessages.getString(PKG, (String)"PaloCubeDeleteDialog.CubeName", (String[])new String[0]));
        this.props.setLook((Control)this.labelCubeName);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.labelCubeName.setLayoutData((Object)fd);
        this.comboCubeName = new CCombo((Composite)this.shell, 2048);
        this.comboCubeName.addModifyListener(lsMod);
        this.props.setLook((Control)this.comboCubeName);
        this.comboCubeName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
            }

            public void focusGained(FocusEvent arg0) {
                PaloCubeDeleteDialog.this.doSelectConnection(false);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.comboCubeName.setLayoutData((Object)fd);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOK, this.wCancel}, (int)margin, (Control)this.comboCubeName);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                PaloCubeDeleteDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                PaloCubeDeleteDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PaloCubeDeleteDialog.this.ok();
            }
        };
        this.textStepName.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                PaloCubeDeleteDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize((Shell)this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    private void doSelectConnection(boolean clearCurrentData) {
        try {
            DatabaseMeta dbMeta;
            if (clearCurrentData) {
                this.comboCubeName.removeAll();
            }
            if (this.comboCubeName.getItemCount() > 1) {
                return;
            }
            if (this.addConnectionLine.getText() != null && (dbMeta = DatabaseMeta.findDatabase((List)this.jobMeta.getDatabases(), (String)this.addConnectionLine.getText())) != null) {
                PaloHelper helper = new PaloHelper(dbMeta, DefaultLogLevel.getLogLevel());
                helper.connect();
                List cubes = helper.getCubesNames();
                Collections.sort(cubes, new PaloNameComparator());
                for (String cubename : cubes) {
                    if (this.comboCubeName.indexOf(cubename) != -1) continue;
                    this.comboCubeName.add(cubename);
                }
                helper.disconnect();
            }
        }
        catch (Exception ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PaloDimInputFlatDialog.RetreiveDimensionsErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PaloDimInputFlatDialog.RetreiveDimensionsError", (String[])new String[0]), ex);
        }
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.textStepName.setText(this.jobEntry.getName());
        }
        this.textStepName.selectAll();
        int index = this.addConnectionLine.indexOf(this.jobEntry.getDatabaseMeta() != null ? this.jobEntry.getDatabaseMeta().getName() : "");
        if (index >= 0) {
            this.addConnectionLine.select(index);
        }
        if (this.jobEntry.getCubeName() != null) {
            this.comboCubeName.add(this.jobEntry.getCubeName());
            this.comboCubeName.select(0);
        }
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        this.jobEntry.setName(this.textStepName.getText());
        this.jobEntry.setDatabaseMeta(DatabaseMeta.findDatabase((List)this.jobMeta.getDatabases(), (String)this.addConnectionLine.getText()));
        this.jobEntry.setCubeName(this.comboCubeName.getText());
        this.dispose();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

