/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BinaryColumnStatsData
implements TBase<BinaryColumnStatsData, _Fields>,
Serializable,
Cloneable,
Comparable<BinaryColumnStatsData> {
    private static final TStruct STRUCT_DESC = new TStruct("BinaryColumnStatsData");
    private static final TField MAX_COL_LEN_FIELD_DESC = new TField("maxColLen", 10, 1);
    private static final TField AVG_COL_LEN_FIELD_DESC = new TField("avgColLen", 4, 2);
    private static final TField NUM_NULLS_FIELD_DESC = new TField("numNulls", 10, 3);
    private static final TField BIT_VECTORS_FIELD_DESC = new TField("bitVectors", 11, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private long maxColLen;
    private double avgColLen;
    private long numNulls;
    private ByteBuffer bitVectors;
    private static final int __MAXCOLLEN_ISSET_ID = 0;
    private static final int __AVGCOLLEN_ISSET_ID = 1;
    private static final int __NUMNULLS_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public BinaryColumnStatsData() {
    }

    public BinaryColumnStatsData(long maxColLen, double avgColLen, long numNulls) {
        this();
        this.maxColLen = maxColLen;
        this.setMaxColLenIsSet(true);
        this.avgColLen = avgColLen;
        this.setAvgColLenIsSet(true);
        this.numNulls = numNulls;
        this.setNumNullsIsSet(true);
    }

    public BinaryColumnStatsData(BinaryColumnStatsData other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.maxColLen = other.maxColLen;
        this.avgColLen = other.avgColLen;
        this.numNulls = other.numNulls;
        if (other.isSetBitVectors()) {
            this.bitVectors = TBaseHelper.copyBinary((ByteBuffer)other.bitVectors);
        }
    }

    public BinaryColumnStatsData deepCopy() {
        return new BinaryColumnStatsData(this);
    }

    public void clear() {
        this.setMaxColLenIsSet(false);
        this.maxColLen = 0L;
        this.setAvgColLenIsSet(false);
        this.avgColLen = 0.0;
        this.setNumNullsIsSet(false);
        this.numNulls = 0L;
        this.bitVectors = null;
    }

    public long getMaxColLen() {
        return this.maxColLen;
    }

    public void setMaxColLen(long maxColLen) {
        this.maxColLen = maxColLen;
        this.setMaxColLenIsSet(true);
    }

    public void unsetMaxColLen() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetMaxColLen() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setMaxColLenIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public double getAvgColLen() {
        return this.avgColLen;
    }

    public void setAvgColLen(double avgColLen) {
        this.avgColLen = avgColLen;
        this.setAvgColLenIsSet(true);
    }

    public void unsetAvgColLen() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetAvgColLen() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setAvgColLenIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getNumNulls() {
        return this.numNulls;
    }

    public void setNumNulls(long numNulls) {
        this.numNulls = numNulls;
        this.setNumNullsIsSet(true);
    }

    public void unsetNumNulls() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetNumNulls() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setNumNullsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public byte[] getBitVectors() {
        this.setBitVectors(TBaseHelper.rightSize((ByteBuffer)this.bitVectors));
        return this.bitVectors == null ? null : this.bitVectors.array();
    }

    public ByteBuffer bufferForBitVectors() {
        return TBaseHelper.copyBinary((ByteBuffer)this.bitVectors);
    }

    public void setBitVectors(byte[] bitVectors) {
        this.bitVectors = bitVectors == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(bitVectors, bitVectors.length));
    }

    public void setBitVectors(ByteBuffer bitVectors) {
        this.bitVectors = TBaseHelper.copyBinary((ByteBuffer)bitVectors);
    }

    public void unsetBitVectors() {
        this.bitVectors = null;
    }

    public boolean isSetBitVectors() {
        return this.bitVectors != null;
    }

    public void setBitVectorsIsSet(boolean value) {
        if (!value) {
            this.bitVectors = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case MAX_COL_LEN: {
                if (value == null) {
                    this.unsetMaxColLen();
                    break;
                }
                this.setMaxColLen((Long)value);
                break;
            }
            case AVG_COL_LEN: {
                if (value == null) {
                    this.unsetAvgColLen();
                    break;
                }
                this.setAvgColLen((Double)value);
                break;
            }
            case NUM_NULLS: {
                if (value == null) {
                    this.unsetNumNulls();
                    break;
                }
                this.setNumNulls((Long)value);
                break;
            }
            case BIT_VECTORS: {
                if (value == null) {
                    this.unsetBitVectors();
                    break;
                }
                this.setBitVectors((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case MAX_COL_LEN: {
                return this.getMaxColLen();
            }
            case AVG_COL_LEN: {
                return this.getAvgColLen();
            }
            case NUM_NULLS: {
                return this.getNumNulls();
            }
            case BIT_VECTORS: {
                return this.getBitVectors();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case MAX_COL_LEN: {
                return this.isSetMaxColLen();
            }
            case AVG_COL_LEN: {
                return this.isSetAvgColLen();
            }
            case NUM_NULLS: {
                return this.isSetNumNulls();
            }
            case BIT_VECTORS: {
                return this.isSetBitVectors();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof BinaryColumnStatsData) {
            return this.equals((BinaryColumnStatsData)that);
        }
        return false;
    }

    public boolean equals(BinaryColumnStatsData that) {
        if (that == null) {
            return false;
        }
        boolean this_present_maxColLen = true;
        boolean that_present_maxColLen = true;
        if (this_present_maxColLen || that_present_maxColLen) {
            if (!this_present_maxColLen || !that_present_maxColLen) {
                return false;
            }
            if (this.maxColLen != that.maxColLen) {
                return false;
            }
        }
        boolean this_present_avgColLen = true;
        boolean that_present_avgColLen = true;
        if (this_present_avgColLen || that_present_avgColLen) {
            if (!this_present_avgColLen || !that_present_avgColLen) {
                return false;
            }
            if (this.avgColLen != that.avgColLen) {
                return false;
            }
        }
        boolean this_present_numNulls = true;
        boolean that_present_numNulls = true;
        if (this_present_numNulls || that_present_numNulls) {
            if (!this_present_numNulls || !that_present_numNulls) {
                return false;
            }
            if (this.numNulls != that.numNulls) {
                return false;
            }
        }
        boolean this_present_bitVectors = this.isSetBitVectors();
        boolean that_present_bitVectors = that.isSetBitVectors();
        if (this_present_bitVectors || that_present_bitVectors) {
            if (!this_present_bitVectors || !that_present_bitVectors) {
                return false;
            }
            if (!this.bitVectors.equals(that.bitVectors)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_maxColLen = true;
        list.add(Boolean.valueOf(present_maxColLen));
        if (present_maxColLen) {
            list.add(Long.valueOf(this.maxColLen));
        }
        boolean present_avgColLen = true;
        list.add(Boolean.valueOf(present_avgColLen));
        if (present_avgColLen) {
            list.add(Double.valueOf(this.avgColLen));
        }
        boolean present_numNulls = true;
        list.add(Boolean.valueOf(present_numNulls));
        if (present_numNulls) {
            list.add(Long.valueOf(this.numNulls));
        }
        boolean present_bitVectors = this.isSetBitVectors();
        list.add(Boolean.valueOf(present_bitVectors));
        if (present_bitVectors) {
            list.add(this.bitVectors);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(BinaryColumnStatsData other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetMaxColLen()).compareTo(other.isSetMaxColLen());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxColLen() && (lastComparison = TBaseHelper.compareTo((long)this.maxColLen, (long)other.maxColLen)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAvgColLen()).compareTo(other.isSetAvgColLen());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAvgColLen() && (lastComparison = TBaseHelper.compareTo((double)this.avgColLen, (double)other.avgColLen)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNumNulls()).compareTo(other.isSetNumNulls());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumNulls() && (lastComparison = TBaseHelper.compareTo((long)this.numNulls, (long)other.numNulls)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBitVectors()).compareTo(other.isSetBitVectors());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBitVectors() && (lastComparison = TBaseHelper.compareTo((Comparable)this.bitVectors, (Comparable)other.bitVectors)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BinaryColumnStatsData(");
        boolean first = true;
        sb.append("maxColLen:");
        sb.append(this.maxColLen);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("avgColLen:");
        sb.append(this.avgColLen);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("numNulls:");
        sb.append(this.numNulls);
        first = false;
        if (this.isSetBitVectors()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bitVectors:");
            if (this.bitVectors == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.bitVectors, (StringBuilder)sb);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetMaxColLen()) {
            throw new TProtocolException("Required field 'maxColLen' is unset! Struct:" + this.toString());
        }
        if (!this.isSetAvgColLen()) {
            throw new TProtocolException("Required field 'avgColLen' is unset! Struct:" + this.toString());
        }
        if (!this.isSetNumNulls()) {
            throw new TProtocolException("Required field 'numNulls' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new BinaryColumnStatsDataStandardSchemeFactory());
        schemes.put(TupleScheme.class, new BinaryColumnStatsDataTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.BIT_VECTORS};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.MAX_COL_LEN, new FieldMetaData("maxColLen", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.AVG_COL_LEN, new FieldMetaData("avgColLen", 1, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.NUM_NULLS, new FieldMetaData("numNulls", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.BIT_VECTORS, new FieldMetaData("bitVectors", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(BinaryColumnStatsData.class, metaDataMap);
    }

    private static class BinaryColumnStatsDataTupleScheme
    extends TupleScheme<BinaryColumnStatsData> {
        private BinaryColumnStatsDataTupleScheme() {
        }

        public void write(TProtocol prot, BinaryColumnStatsData struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.maxColLen);
            oprot.writeDouble(struct.avgColLen);
            oprot.writeI64(struct.numNulls);
            BitSet optionals = new BitSet();
            if (struct.isSetBitVectors()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetBitVectors()) {
                oprot.writeBinary(struct.bitVectors);
            }
        }

        public void read(TProtocol prot, BinaryColumnStatsData struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.maxColLen = iprot.readI64();
            struct.setMaxColLenIsSet(true);
            struct.avgColLen = iprot.readDouble();
            struct.setAvgColLenIsSet(true);
            struct.numNulls = iprot.readI64();
            struct.setNumNullsIsSet(true);
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                struct.bitVectors = iprot.readBinary();
                struct.setBitVectorsIsSet(true);
            }
        }
    }

    private static class BinaryColumnStatsDataTupleSchemeFactory
    implements SchemeFactory {
        private BinaryColumnStatsDataTupleSchemeFactory() {
        }

        public BinaryColumnStatsDataTupleScheme getScheme() {
            return new BinaryColumnStatsDataTupleScheme();
        }
    }

    private static class BinaryColumnStatsDataStandardScheme
    extends StandardScheme<BinaryColumnStatsData> {
        private BinaryColumnStatsDataStandardScheme() {
        }

        public void read(TProtocol iprot, BinaryColumnStatsData struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.maxColLen = iprot.readI64();
                            struct.setMaxColLenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 4) {
                            struct.avgColLen = iprot.readDouble();
                            struct.setAvgColLenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.numNulls = iprot.readI64();
                            struct.setNumNullsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.bitVectors = iprot.readBinary();
                            struct.setBitVectorsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, BinaryColumnStatsData struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(MAX_COL_LEN_FIELD_DESC);
            oprot.writeI64(struct.maxColLen);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(AVG_COL_LEN_FIELD_DESC);
            oprot.writeDouble(struct.avgColLen);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(NUM_NULLS_FIELD_DESC);
            oprot.writeI64(struct.numNulls);
            oprot.writeFieldEnd();
            if (struct.bitVectors != null && struct.isSetBitVectors()) {
                oprot.writeFieldBegin(BIT_VECTORS_FIELD_DESC);
                oprot.writeBinary(struct.bitVectors);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class BinaryColumnStatsDataStandardSchemeFactory
    implements SchemeFactory {
        private BinaryColumnStatsDataStandardSchemeFactory() {
        }

        public BinaryColumnStatsDataStandardScheme getScheme() {
            return new BinaryColumnStatsDataStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        MAX_COL_LEN(1, "maxColLen"),
        AVG_COL_LEN(2, "avgColLen"),
        NUM_NULLS(3, "numNulls"),
        BIT_VECTORS(4, "bitVectors");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return MAX_COL_LEN;
                }
                case 2: {
                    return AVG_COL_LEN;
                }
                case 3: {
                    return NUM_NULLS;
                }
                case 4: {
                    return BIT_VECTORS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

