/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.RelatedOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.hive.HiveImport;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.MergeJob;
import com.cloudera.sqoop.metastore.JobData;
import com.cloudera.sqoop.metastore.JobStorage;
import com.cloudera.sqoop.metastore.JobStorageFactory;
import com.cloudera.sqoop.orm.TableClassName;
import com.cloudera.sqoop.tool.BaseSqoopTool;
import com.cloudera.sqoop.util.AppendUtils;
import com.cloudera.sqoop.util.ClassLoaderStack;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.tool.CodeGenTool;

public class ImportTool
extends BaseSqoopTool {
    public static final Log LOG = LogFactory.getLog((String)ImportTool.class.getName());
    private CodeGenTool codeGenerator = new CodeGenTool();
    private boolean allTables;
    private int checkColumnType;
    private ClassLoader prevClassLoader = null;

    public ImportTool() {
        this("import", false);
    }

    public ImportTool(String toolName, boolean allTables) {
        super(toolName);
        this.allTables = allTables;
    }

    @Override
    protected boolean init(SqoopOptions sqoopOpts) {
        boolean ret = super.init(sqoopOpts);
        this.codeGenerator.setManager(this.manager);
        return ret;
    }

    public List<String> getGeneratedJarFiles() {
        return this.codeGenerator.getGeneratedJarFiles();
    }

    private void loadJars(Configuration conf, String ormJarFile, String tableClassName) throws IOException {
        boolean isLocal;
        boolean bl = isLocal = "local".equals(conf.get("mapreduce.jobtracker.address")) || "local".equals(conf.get("mapred.job.tracker"));
        if (isLocal) {
            this.prevClassLoader = ClassLoaderStack.addJarFile(ormJarFile, tableClassName);
        }
    }

    private void unloadJars() {
        if (null != this.prevClassLoader) {
            ClassLoaderStack.setCurrentClassLoader(this.prevClassLoader);
        }
    }

    private boolean isIncremental(SqoopOptions options) {
        return !options.getIncrementalMode().equals((Object)SqoopOptions.IncrementalMode.None);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIncrementalState(SqoopOptions options) throws IOException {
        if (!this.isIncremental(options)) {
            return;
        }
        Map<String, String> descriptor = options.getStorageDescriptor();
        String jobName = options.getJobName();
        if (null != jobName && null != descriptor) {
            LOG.info((Object)"Saving incremental import state to the metastore");
            JobStorageFactory ssf = new JobStorageFactory(options.getConf());
            JobStorage storage = ssf.getJobStorage(descriptor);
            storage.open(descriptor);
            try {
                JobData data = new JobData(options.getParent(), this);
                storage.update(jobName, data);
                LOG.info((Object)("Updated data for job: " + jobName));
            }
            finally {
                storage.close();
            }
        } else {
            LOG.info((Object)"Incremental import complete! To run another incremental import of all data following this import, supply the following arguments:");
            SqoopOptions.IncrementalMode incrementalMode = options.getIncrementalMode();
            switch (incrementalMode) {
                case AppendRows: {
                    LOG.info((Object)" --incremental append");
                    break;
                }
                case DateLastModified: {
                    LOG.info((Object)" --incremental lastmodified");
                    break;
                }
                default: {
                    LOG.warn((Object)("Undefined incremental mode: " + (Object)((Object)incrementalMode)));
                }
            }
            LOG.info((Object)("  --check-column " + options.getIncrementalTestColumn()));
            LOG.info((Object)("  --last-value " + options.getIncrementalLastValue()));
            LOG.info((Object)"(Consider saving this with 'sqoop job --create')");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMaxColumnId(SqoopOptions options) throws SQLException {
        String query;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT MAX(");
        sb.append(this.manager.escapeColName(options.getIncrementalTestColumn()));
        sb.append(") FROM ");
        if (options.getTableName() != null) {
            sb.append(this.manager.escapeTableName(options.getTableName()));
            String where = options.getWhereClause();
            if (null != where) {
                sb.append(" WHERE ");
                sb.append(where);
            }
            query = sb.toString();
        } else {
            sb.append("(");
            sb.append(options.getSqlQuery());
            sb.append(") sqoop_import_query_alias");
            query = sb.toString().replaceAll("\\$CONDITIONS", "(1 = 1)");
        }
        Connection conn = this.manager.getConnection();
        Statement s = null;
        ResultSet rs = null;
        try {
            LOG.info((Object)("Maximal id query for free form incremental import: " + query));
            s = conn.createStatement();
            rs = s.executeQuery(query);
            if (!rs.next()) {
                LOG.warn((Object)"Unexpected: empty results for max value query?");
                Object var7_7 = null;
                return var7_7;
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            this.checkColumnType = rsmd.getColumnType(1);
            if (this.checkColumnType == 93) {
                Timestamp timestamp = rs.getTimestamp(1);
                return timestamp;
            }
            if (this.checkColumnType == 91) {
                Date date = rs.getDate(1);
                return date;
            }
            if (this.checkColumnType == 92) {
                Time time = rs.getTime(1);
                return time;
            }
            Object object = rs.getObject(1);
            return object;
        }
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("SQL Exception closing resultset: " + sqlE));
            }
            try {
                if (null != s) {
                    s.close();
                }
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("SQL Exception closing statement: " + sqlE));
            }
        }
    }

    private boolean isDateTimeColumn(int columnType) {
        return columnType == 93 || columnType == 91 || columnType == 92;
    }

    private boolean initIncrementalConstraints(SqoopOptions options, ImportJobContext context) throws ImportException, IOException {
        Object nextVal;
        if (!this.isIncremental(options)) {
            return true;
        }
        FileSystem fs = FileSystem.get((Configuration)options.getConf());
        SqoopOptions.IncrementalMode incrementalMode = options.getIncrementalMode();
        String nextIncrementalValue = null;
        switch (incrementalMode) {
            case AppendRows: {
                try {
                    nextVal = this.getMaxColumnId(options);
                    if (this.isDateTimeColumn(this.checkColumnType)) {
                        nextIncrementalValue = nextVal == null ? null : this.manager.datetimeToQueryString(nextVal.toString(), this.checkColumnType);
                        break;
                    }
                    if (this.manager.isCharColumn(this.checkColumnType)) {
                        throw new ImportException("Character column (" + options.getIncrementalTestColumn() + ") can not be used " + "to determine which rows to incrementally import.");
                    }
                    nextIncrementalValue = nextVal == null ? null : nextVal.toString();
                    break;
                }
                catch (SQLException sqlE) {
                    throw new IOException(sqlE);
                }
            }
            case DateLastModified: {
                if (options.getMergeKeyCol() == null && !options.isAppendMode() && fs.exists(this.getOutputPath(options, context.getTableName(), false))) {
                    throw new ImportException("--merge-key or --append is required when using --" + "incremental" + " lastmodified and the output directory exists.");
                }
                this.checkColumnType = this.manager.getColumnTypes(options.getTableName(), options.getSqlQuery()).get(options.getIncrementalTestColumn());
                nextVal = this.manager.getCurrentDbTimestamp();
                if (null == nextVal) {
                    throw new IOException("Could not get current time from database");
                }
                nextIncrementalValue = this.manager.datetimeToQueryString(nextVal.toString(), this.checkColumnType);
                break;
            }
            default: {
                throw new ImportException("Undefined incremental import type: " + (Object)((Object)incrementalMode));
            }
        }
        StringBuilder sb = new StringBuilder();
        String prevEndpoint = options.getIncrementalLastValue();
        if (this.isDateTimeColumn(this.checkColumnType) && null != prevEndpoint && !prevEndpoint.startsWith("'") && !prevEndpoint.endsWith("'")) {
            prevEndpoint = this.manager.datetimeToQueryString(prevEndpoint, this.checkColumnType);
        }
        String checkColName = this.manager.escapeColName(options.getIncrementalTestColumn());
        LOG.info((Object)("Incremental import based on column " + checkColName));
        if (null != prevEndpoint) {
            if (prevEndpoint.equals(nextIncrementalValue)) {
                LOG.info((Object)"No new rows detected since last import.");
                return false;
            }
            LOG.info((Object)("Lower bound value: " + prevEndpoint));
            sb.append(checkColName);
            switch (incrementalMode) {
                case AppendRows: {
                    sb.append(" > ");
                    break;
                }
                case DateLastModified: {
                    sb.append(" >= ");
                    break;
                }
                default: {
                    throw new ImportException("Undefined comparison");
                }
            }
            sb.append(prevEndpoint);
            sb.append(" AND ");
        }
        if (null != nextIncrementalValue) {
            sb.append(checkColName);
            switch (incrementalMode) {
                case AppendRows: {
                    sb.append(" <= ");
                    break;
                }
                case DateLastModified: {
                    sb.append(" < ");
                    break;
                }
                default: {
                    throw new ImportException("Undefined comparison");
                }
            }
            sb.append(nextIncrementalValue);
        } else {
            sb.append(checkColName);
            sb.append(" IS NULL ");
        }
        LOG.info((Object)("Upper bound value: " + nextIncrementalValue));
        if (options.getTableName() != null) {
            String prevWhereClause = options.getWhereClause();
            if (null != prevWhereClause) {
                sb.append(" AND (");
                sb.append(prevWhereClause);
                sb.append(")");
            }
            String newConstraints = sb.toString();
            options.setWhereClause(newConstraints);
        } else {
            sb.append(" AND $CONDITIONS");
            String newQuery = options.getSqlQuery().replace("$CONDITIONS", sb.toString());
            options.setSqlQuery(newQuery);
        }
        SqoopOptions recordOptions = options.getParent();
        if (null == recordOptions) {
            recordOptions = options;
        }
        recordOptions.setIncrementalLastValue(nextVal == null ? null : nextVal.toString());
        return true;
    }

    protected void lastModifiedMerge(SqoopOptions options, ImportJobContext context) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)options.getConf());
        if (context.getDestination() != null && fs.exists(context.getDestination())) {
            Path userDestDir = this.getOutputPath(options, context.getTableName(), false);
            if (fs.exists(userDestDir)) {
                String tableClassName = null;
                if (!context.getConnManager().isORMFacilitySelfManaged()) {
                    tableClassName = new TableClassName(options).getClassForTable(context.getTableName());
                }
                Path destDir = this.getOutputPath(options, context.getTableName());
                options.setExistingJarName(context.getJarFile());
                options.setClassName(tableClassName);
                options.setMergeOldPath(userDestDir.toString());
                options.setMergeNewPath(context.getDestination().toString());
                options.setTargetDir(destDir.toString());
                this.loadJars(options.getConf(), context.getJarFile(), context.getTableName());
                MergeJob mergeJob = new MergeJob(options);
                if (mergeJob.runMergeJob()) {
                    Path tmpDir = this.getOutputPath(options, context.getTableName());
                    fs.rename(userDestDir, tmpDir);
                    fs.rename(destDir, userDestDir);
                    fs.delete(tmpDir, true);
                } else {
                    LOG.error((Object)"Merge MapReduce job failed!");
                }
                this.unloadJars();
            } else {
                fs.rename(context.getDestination(), userDestDir);
            }
        }
    }

    protected boolean importTable(SqoopOptions options, String tableName, HiveImport hiveImport) throws IOException, ImportException {
        Path outputPath;
        String jarFile = null;
        jarFile = this.codeGenerator.generateORM(options, tableName);
        ImportJobContext context = new ImportJobContext(tableName, jarFile, options, outputPath = this.getOutputPath(options, tableName));
        if (!this.initIncrementalConstraints(options, context)) {
            return false;
        }
        if (options.isDeleteMode()) {
            this.deleteTargetDir(context);
        }
        if (null != tableName) {
            this.manager.importTable(context);
        } else {
            this.manager.importQuery(context);
        }
        if (options.isAppendMode()) {
            AppendUtils app = new AppendUtils(context);
            app.append();
        } else if (options.getIncrementalMode() == SqoopOptions.IncrementalMode.DateLastModified) {
            this.lastModifiedMerge(options, context);
        }
        if (options.doHiveImport() && options.getFileLayout() != SqoopOptions.FileLayout.ParquetFile) {
            hiveImport.importTable(tableName, options.getHiveTableName(), false);
        }
        this.saveIncrementalState(options);
        return true;
    }

    private void deleteTargetDir(ImportJobContext context) throws IOException {
        Path destDir;
        SqoopOptions options = context.getOptions();
        FileSystem fs = FileSystem.get((Configuration)options.getConf());
        if (fs.exists(destDir = context.getDestination())) {
            fs.delete(destDir, true);
            LOG.info((Object)("Destination directory " + destDir + " deleted."));
            return;
        }
        LOG.info((Object)("Destination directory " + destDir + " is not present, " + "hence not deleting."));
    }

    private Path getOutputPath(SqoopOptions options, String tableName) {
        return this.getOutputPath(options, tableName, options.isAppendMode() || options.getIncrementalMode().equals((Object)SqoopOptions.IncrementalMode.DateLastModified));
    }

    private Path getOutputPath(SqoopOptions options, String tableName, boolean temp) {
        String hdfsWarehouseDir = options.getWarehouseDir();
        String hdfsTargetDir = options.getTargetDir();
        Path outputPath = null;
        if (temp) {
            String salt = tableName;
            if (salt == null && options.getSqlQuery() != null) {
                salt = Integer.toHexString(options.getSqlQuery().hashCode());
            }
            outputPath = AppendUtils.getTempAppendDir(salt);
            LOG.debug((Object)("Using temporary folder: " + outputPath.getName()));
        } else if (hdfsTargetDir != null) {
            outputPath = new Path(hdfsTargetDir);
        } else if (hdfsWarehouseDir != null) {
            outputPath = new Path(hdfsWarehouseDir, tableName);
        } else if (null != tableName) {
            outputPath = new Path(tableName);
        }
        return outputPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(SqoopOptions options) {
        HiveImport hiveImport = null;
        if (this.allTables) {
            LOG.error((Object)"ImportTool.run() can only handle a single table.");
            return 1;
        }
        if (!this.init(options)) {
            return 1;
        }
        this.codeGenerator.setManager(this.manager);
        try {
            if (options.doHiveImport()) {
                hiveImport = new HiveImport(options, this.manager, options.getConf(), false);
            }
            this.importTable(options, options.getTableName(), hiveImport);
        }
        catch (IllegalArgumentException iea) {
            LOG.error((Object)("Imported Failed: " + iea.getMessage()));
            if (System.getProperty("sqoop.throwOnError") != null) {
                throw iea;
            }
            int n = 1;
            return n;
        }
        catch (IOException ioe) {
            LOG.error((Object)("Encountered IOException running import job: " + StringUtils.stringifyException((Throwable)ioe)));
            if (System.getProperty("sqoop.throwOnError") != null) {
                throw new RuntimeException(ioe);
            }
            int n = 1;
            return n;
        }
        catch (ImportException ie) {
            LOG.error((Object)("Error during import: " + ie.toString()));
            if (System.getProperty("sqoop.throwOnError") != null) {
                throw new RuntimeException(ie);
            }
            int n = 1;
            return n;
        }
        finally {
            this.destroy(options);
        }
        return 0;
    }

    protected RelatedOptions getImportOptions() {
        RelatedOptions importOpts = new RelatedOptions("Import control arguments");
        OptionBuilder.withDescription((String)"Use direct import fast path");
        OptionBuilder.withLongOpt((String)"direct");
        importOpts.addOption(OptionBuilder.create());
        if (!this.allTables) {
            OptionBuilder.withArgName((String)"table-name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Table to read");
            OptionBuilder.withLongOpt((String)"table");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"col,col,col...");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Columns to import from table");
            OptionBuilder.withLongOpt((String)"columns");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"column-name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Column of the table used to split work units");
            OptionBuilder.withLongOpt((String)"split-by");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"where clause");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"WHERE clause to use during import");
            OptionBuilder.withLongOpt((String)"where");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withDescription((String)"Imports data in append mode");
            OptionBuilder.withLongOpt((String)"append");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withDescription((String)"Imports data in delete mode");
            OptionBuilder.withLongOpt((String)"delete-target-dir");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"dir");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"HDFS plain table destination");
            OptionBuilder.withLongOpt((String)"target-dir");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"statement");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Import results of SQL 'statement'");
            OptionBuilder.withLongOpt((String)"query");
            importOpts.addOption(OptionBuilder.create((String)"e"));
            OptionBuilder.withArgName((String)"statement");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Set boundary query for retrieving max and min value of the primary key");
            OptionBuilder.withLongOpt((String)"boundary-query");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"column");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Key column to use to join results");
            OptionBuilder.withLongOpt((String)"merge-key");
            importOpts.addOption(OptionBuilder.create());
            this.addValidationOpts(importOpts);
        }
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"HDFS parent for table destination");
        OptionBuilder.withLongOpt((String)"warehouse-dir");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data to SequenceFiles");
        OptionBuilder.withLongOpt((String)"as-sequencefile");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data as plain text (default)");
        OptionBuilder.withLongOpt((String)"as-textfile");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data to Avro data files");
        OptionBuilder.withLongOpt((String)"as-avrodatafile");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data to Parquet files");
        OptionBuilder.withLongOpt((String)"as-parquetfile");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Use 'n' map tasks to import in parallel");
        OptionBuilder.withLongOpt((String)"num-mappers");
        importOpts.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set name for generated mapreduce job");
        OptionBuilder.withLongOpt((String)"mapreduce-job-name");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Enable compression");
        OptionBuilder.withLongOpt((String)"compress");
        importOpts.addOption(OptionBuilder.create((String)"z"));
        OptionBuilder.withArgName((String)"codec");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Compression codec to use for import");
        OptionBuilder.withLongOpt((String)"compression-codec");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Split the input stream every 'n' bytes when importing in direct mode");
        OptionBuilder.withLongOpt((String)"direct-split-size");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set the maximum size for an inline LOB");
        OptionBuilder.withLongOpt((String)"inline-lob-limit");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set number 'n' of rows to fetch from the database when more rows are needed");
        OptionBuilder.withLongOpt((String)"fetch-size");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"reset-mappers");
        OptionBuilder.withDescription((String)"Reset the number of mappers to one mapper if no split key available");
        OptionBuilder.withLongOpt((String)"autoreset-to-one-mapper");
        importOpts.addOption(OptionBuilder.create());
        return importOpts;
    }

    protected RelatedOptions getIncrementalOptions() {
        RelatedOptions incrementalOpts = new RelatedOptions("Incremental import arguments");
        OptionBuilder.withArgName((String)"import-type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Define an incremental import of type 'append' or 'lastmodified'");
        OptionBuilder.withLongOpt((String)"incremental");
        incrementalOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"column");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Source column to check for incremental change");
        OptionBuilder.withLongOpt((String)"check-column");
        incrementalOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Last imported value in the incremental check column");
        OptionBuilder.withLongOpt((String)"last-value");
        incrementalOpts.addOption(OptionBuilder.create());
        return incrementalOpts;
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        toolOptions.addUniqueOptions(this.getCommonOptions());
        toolOptions.addUniqueOptions(this.getImportOptions());
        if (!this.allTables) {
            toolOptions.addUniqueOptions(this.getIncrementalOptions());
        }
        toolOptions.addUniqueOptions(this.getOutputFormatOptions());
        toolOptions.addUniqueOptions(this.getInputFormatOptions());
        toolOptions.addUniqueOptions(this.getHiveOptions(true));
        toolOptions.addUniqueOptions(this.getHBaseOptions());
        toolOptions.addUniqueOptions(this.getHCatalogOptions());
        toolOptions.addUniqueOptions(this.getHCatImportOnlyOptions());
        toolOptions.addUniqueOptions(this.getAccumuloOptions());
        RelatedOptions codeGenOpts = this.getCodeGenOpts(this.allTables);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Disable code generation; use specified jar");
        OptionBuilder.withLongOpt((String)"jar-file");
        codeGenOpts.addOption(OptionBuilder.create());
        toolOptions.addUniqueOptions(codeGenOpts);
    }

    @Override
    public void printHelp(ToolOptions toolOptions) {
        super.printHelp(toolOptions);
        System.out.println("");
        if (this.allTables) {
            System.out.println("At minimum, you must specify --connect");
        } else {
            System.out.println("At minimum, you must specify --connect and --table");
        }
        System.out.println("Arguments to mysqldump and other subprograms may be supplied");
        System.out.println("after a '--' on the command line.");
    }

    private void applyIncrementalOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption("incremental")) {
            String incrementalTypeStr = in.getOptionValue("incremental");
            if ("append".equals(incrementalTypeStr)) {
                out.setIncrementalMode(SqoopOptions.IncrementalMode.AppendRows);
                out.setAppendMode(true);
            } else if ("lastmodified".equals(incrementalTypeStr)) {
                out.setIncrementalMode(SqoopOptions.IncrementalMode.DateLastModified);
            } else {
                throw new SqoopOptions.InvalidOptionsException("Unknown incremental import mode: " + incrementalTypeStr + ". Use 'append' or 'lastmodified'." + "\nTry --help for usage instructions.");
            }
        }
        if (in.hasOption("check-column")) {
            out.setIncrementalTestColumn(in.getOptionValue("check-column"));
        }
        if (in.hasOption("last-value")) {
            out.setIncrementalLastValue(in.getOptionValue("last-value"));
        }
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        try {
            this.applyCommonOptions(in, out);
            if (in.hasOption("direct")) {
                out.setDirectMode(true);
            }
            if (!this.allTables) {
                if (in.hasOption("table")) {
                    out.setTableName(in.getOptionValue("table"));
                }
                if (in.hasOption("columns")) {
                    String[] cols = in.getOptionValue("columns").split(",");
                    for (int i = 0; i < cols.length; ++i) {
                        cols[i] = cols[i].trim();
                    }
                    out.setColumns(cols);
                }
                if (in.hasOption("split-by")) {
                    out.setSplitByCol(in.getOptionValue("split-by"));
                }
                if (in.hasOption("where")) {
                    out.setWhereClause(in.getOptionValue("where"));
                }
                if (in.hasOption("target-dir")) {
                    out.setTargetDir(in.getOptionValue("target-dir"));
                }
                if (in.hasOption("append")) {
                    out.setAppendMode(true);
                }
                if (in.hasOption("delete-target-dir")) {
                    out.setDeleteMode(true);
                }
                if (in.hasOption("query")) {
                    out.setSqlQuery(in.getOptionValue("query"));
                }
                if (in.hasOption("boundary-query")) {
                    out.setBoundaryQuery(in.getOptionValue("boundary-query"));
                }
                if (in.hasOption("merge-key")) {
                    out.setMergeKeyCol(in.getOptionValue("merge-key"));
                }
                this.applyValidationOptions(in, out);
            }
            if (in.hasOption("warehouse-dir")) {
                out.setWarehouseDir(in.getOptionValue("warehouse-dir"));
            }
            if (in.hasOption("as-sequencefile")) {
                out.setFileLayout(SqoopOptions.FileLayout.SequenceFile);
            }
            if (in.hasOption("as-textfile")) {
                out.setFileLayout(SqoopOptions.FileLayout.TextFile);
            }
            if (in.hasOption("as-avrodatafile")) {
                out.setFileLayout(SqoopOptions.FileLayout.AvroDataFile);
            }
            if (in.hasOption("as-parquetfile")) {
                out.setFileLayout(SqoopOptions.FileLayout.ParquetFile);
            }
            if (in.hasOption("num-mappers")) {
                out.setNumMappers(Integer.parseInt(in.getOptionValue("num-mappers")));
            }
            if (in.hasOption("mapreduce-job-name")) {
                out.setMapreduceJobName(in.getOptionValue("mapreduce-job-name"));
            }
            if (in.hasOption("compress")) {
                out.setUseCompression(true);
            }
            if (in.hasOption("compression-codec")) {
                out.setCompressionCodec(in.getOptionValue("compression-codec"));
            }
            if (in.hasOption("direct-split-size")) {
                out.setDirectSplitSize(Long.parseLong(in.getOptionValue("direct-split-size")));
            }
            if (in.hasOption("inline-lob-limit")) {
                out.setInlineLobLimit(Long.parseLong(in.getOptionValue("inline-lob-limit")));
            }
            if (in.hasOption("fetch-size")) {
                out.setFetchSize(new Integer(in.getOptionValue("fetch-size")));
            }
            if (in.hasOption("jar-file")) {
                out.setExistingJarName(in.getOptionValue("jar-file"));
            }
            if (in.hasOption("autoreset-to-one-mapper")) {
                out.setAutoResetToOneMapper(true);
            }
            this.applyIncrementalOptions(in, out);
            this.applyHiveOptions(in, out);
            this.applyOutputFormatOptions(in, out);
            this.applyInputFormatOptions(in, out);
            this.applyCodeGenOptions(in, out, this.allTables);
            this.applyHBaseOptions(in, out);
            this.applyHCatalogOptions(in, out);
            this.applyAccumuloOptions(in, out);
        }
        catch (NumberFormatException nfe) {
            throw new SqoopOptions.InvalidOptionsException("Error: expected numeric argument.\nTry --help for usage.");
        }
    }

    protected void validateImportOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (!this.allTables && options.getTableName() == null && options.getSqlQuery() == null) {
            throw new SqoopOptions.InvalidOptionsException("--table or --query is required for import. (Or use sqoop import-all-tables.)\nTry --help for usage instructions.");
        }
        if (options.getExistingJarName() != null && options.getClassName() == null) {
            throw new SqoopOptions.InvalidOptionsException("Jar specified with --jar-file, but no class specified with --class-name.\nTry --help for usage instructions.");
        }
        if (options.getTargetDir() != null && options.getWarehouseDir() != null) {
            throw new SqoopOptions.InvalidOptionsException("--target-dir with --warehouse-dir are incompatible options.\nTry --help for usage instructions.");
        }
        if (options.getTableName() != null && options.getSqlQuery() != null) {
            throw new SqoopOptions.InvalidOptionsException("Cannot specify --query and --table together.\nTry --help for usage instructions.");
        }
        if (options.getSqlQuery() != null && options.getTargetDir() == null && options.getHBaseTable() == null && options.getHCatTableName() == null && options.getAccumuloTable() == null) {
            throw new SqoopOptions.InvalidOptionsException("Must specify destination with --target-dir. \nTry --help for usage instructions.");
        }
        if (options.getSqlQuery() != null && options.doHiveImport() && options.getHiveTableName() == null) {
            throw new SqoopOptions.InvalidOptionsException("When importing a query to Hive, you must specify --hive-table.\nTry --help for usage instructions.");
        }
        if (options.getSqlQuery() != null && options.getNumMappers() > 1 && options.getSplitByCol() == null) {
            throw new SqoopOptions.InvalidOptionsException("When importing query results in parallel, you must specify --split-by.\nTry --help for usage instructions.");
        }
        if (options.isDirect() && options.getFileLayout() != SqoopOptions.FileLayout.TextFile && options.getConnectString().contains("jdbc:mysql://")) {
            throw new SqoopOptions.InvalidOptionsException("MySQL direct import currently supports only text output format. Parameters --as-sequencefile --as-avrodatafile and --as-parquetfile are not supported with --direct params in MySQL case.");
        }
        if (options.isDirect() && options.doHiveDropDelims()) {
            throw new SqoopOptions.InvalidOptionsException("Direct import currently do not support dropping hive delimiters, please remove parameter --hive-drop-import-delims.");
        }
        if (this.allTables && options.isValidationEnabled()) {
            throw new SqoopOptions.InvalidOptionsException("Validation is not supported for all tables but single table only.");
        }
        if (options.getSqlQuery() != null && options.isValidationEnabled()) {
            throw new SqoopOptions.InvalidOptionsException("Validation is not supported for free from query but single table only.");
        }
        if (options.getWhereClause() != null && options.isValidationEnabled()) {
            throw new SqoopOptions.InvalidOptionsException("Validation is not supported for where clause but single table only.");
        }
        if (options.getIncrementalMode() != SqoopOptions.IncrementalMode.None && options.isValidationEnabled()) {
            throw new SqoopOptions.InvalidOptionsException("Validation is not supported for incremental imports but single table only.");
        }
        if ((options.getTargetDir() != null || options.getWarehouseDir() != null) && options.getHCatTableName() != null) {
            throw new SqoopOptions.InvalidOptionsException("--hcatalog-table cannot be used  --warehouse-dir or --target-dir options");
        }
        if (options.isDeleteMode() && options.isAppendMode()) {
            throw new SqoopOptions.InvalidOptionsException("--append and --delete-target-dir can not be used together.");
        }
        if (options.isDeleteMode() && options.getIncrementalMode() != SqoopOptions.IncrementalMode.None) {
            throw new SqoopOptions.InvalidOptionsException("--delete-target-dir can not be used with incremental imports.");
        }
        if (options.getAutoResetToOneMapper() && options.getSplitByCol() != null) {
            throw new SqoopOptions.InvalidOptionsException("--autoreset-to-one-mapper and --split-by cannot be used together.");
        }
    }

    private void validateIncrementalOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.getIncrementalMode() != SqoopOptions.IncrementalMode.None && options.getIncrementalTestColumn() == null) {
            throw new SqoopOptions.InvalidOptionsException("For an incremental import, the check column must be specified with --check-column. \nTry --help for usage instructions.");
        }
        if (options.getIncrementalMode() == SqoopOptions.IncrementalMode.None && options.getIncrementalTestColumn() != null) {
            throw new SqoopOptions.InvalidOptionsException("You must specify an incremental import mode with --incremental. \nTry --help for usage instructions.");
        }
        if (options.getIncrementalMode() == SqoopOptions.IncrementalMode.DateLastModified && options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
            throw new SqoopOptions.InvalidOptionsException("--incremental lastmodified cannot be used in conjunction with --as-avrodatafile.\nTry --help for usage instructions.");
        }
    }

    @Override
    public void validateOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        options.setExtraArgs(this.getSubcommandArgs(this.extraArguments));
        int dashPos = this.getDashPosition(this.extraArguments);
        if (this.hasUnrecognizedArgs(this.extraArguments, 0, dashPos)) {
            throw new SqoopOptions.InvalidOptionsException("\nTry --help for usage instructions.");
        }
        this.validateImportOptions(options);
        this.validateIncrementalOptions(options);
        this.validateCommonOptions(options);
        this.validateCodeGenOptions(options);
        this.validateOutputFormatOptions(options);
        this.validateHBaseOptions(options);
        this.validateHiveOptions(options);
        this.validateHCatalogOptions(options);
        this.validateAccumuloOptions(options);
    }
}

