/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.mapreduce.ui.step.enter;

import org.pentaho.big.data.kettle.plugins.mapreduce.step.enter.HadoopEnterMeta;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class HadoopEnterMetaMapper
extends XulEventSourceAdapter {
    public static String IN_KEY_TYPE = "in-key-type";
    public static String IN_KEY_LENGTH = "in-key-length";
    public static String IN_KEY_PRECISION = "in-key-precision";
    public static String IN_VALUE_TYPE = "in-value-type";
    public static String IN_VALUE_LENGTH = "in-value-length";
    public static String IN_VALUE_PRECISION = "in-value-precision";
    private int inKeyType = -1;
    private int inKeyLength = -1;
    private int inKeyPrecision = -1;
    private int inValueType = -1;
    private int inValueLength = -1;
    private int inValuePrecision = -1;

    public void setInKeyType(int arg) {
        int previousVal = this.inKeyType;
        this.inKeyType = arg;
        this.firePropertyChange(IN_KEY_TYPE, previousVal, this.inKeyType);
    }

    public void setInKeyLength(int arg) {
        int previousVal = this.inKeyLength;
        this.inKeyLength = arg;
        this.firePropertyChange(IN_KEY_LENGTH, previousVal, this.inKeyLength);
    }

    public void setInKeyPrecision(int arg) {
        int previousVal = this.inKeyPrecision;
        this.inKeyPrecision = arg;
        this.firePropertyChange(IN_KEY_PRECISION, previousVal, this.inKeyPrecision);
    }

    public void setInValueType(int arg) {
        int previousVal = this.inValueType;
        this.inValueType = arg;
        this.firePropertyChange(IN_VALUE_TYPE, previousVal, this.inValueType);
    }

    public void setInValueLength(int arg) {
        int previousVal = this.inValueLength;
        this.inValueLength = arg;
        this.firePropertyChange(IN_VALUE_LENGTH, previousVal, this.inValueLength);
    }

    public void setInValuePrecision(int arg) {
        int previousVal = this.inValuePrecision;
        this.inValuePrecision = arg;
        this.firePropertyChange(IN_VALUE_PRECISION, previousVal, this.inValuePrecision);
    }

    public int getInKeyType() {
        return this.inKeyType;
    }

    public int getInKeyLength() {
        return this.inKeyLength;
    }

    public int getInKeyPrecision() {
        return this.inKeyPrecision;
    }

    public int getInValueType() {
        return this.inValueType;
    }

    public int getInValueLength() {
        return this.inValueLength;
    }

    public int getInValuePrecision() {
        return this.inValuePrecision;
    }

    public void loadMeta(HadoopEnterMeta meta) {
        FieldPositions fields = new FieldPositions(meta.getFieldname());
        if (!fields.isValid()) {
            return;
        }
        int[] type = meta.getType();
        int[] length = meta.getLength();
        int[] precision = meta.getPrecision();
        this.setInKeyType(type[fields.getKeyIndex()]);
        this.setInKeyLength(length[fields.getKeyIndex()]);
        this.setInKeyPrecision(precision[fields.getKeyIndex()]);
        this.setInValueType(type[fields.getValueIndex()]);
        this.setInValueLength(length[fields.getValueIndex()]);
        this.setInValuePrecision(precision[fields.getValueIndex()]);
    }

    public void saveMeta(HadoopEnterMeta meta) {
        int[] metaPrecision;
        int[] metaLength;
        int[] metaType;
        FieldPositions fields = new FieldPositions(meta.getFieldname());
        if (!fields.isValid()) {
            meta.allocate(2);
            fields.setKeyIndex(0);
            fields.setValueIndex(1);
            meta.getFieldname()[fields.getKeyIndex()] = "key";
            meta.getFieldname()[fields.getValueIndex()] = "value";
            meta.setChanged();
        }
        int[] type = new int[2];
        int[] length = new int[2];
        int[] precision = new int[2];
        if (this.getInKeyType() >= 0) {
            type[fields.getKeyIndex()] = this.getInKeyType();
        }
        if (this.getInValueType() >= 0) {
            type[fields.getValueIndex()] = this.getInValueType();
        }
        if ((metaType = meta.getType()) == null || metaType.length != 2) {
            meta.setChanged();
        }
        for (int index = 0; index < type.length; ++index) {
            if (type[index] == metaType[index]) continue;
            meta.setChanged(true);
        }
        meta.setType(type);
        if (this.getInKeyLength() >= 0) {
            length[fields.getKeyIndex()] = this.getInKeyLength();
        }
        if (this.getInValueLength() >= 0) {
            length[fields.getValueIndex()] = this.getInValueLength();
        }
        if ((metaLength = meta.getLength()) == null || metaLength.length != 2) {
            meta.setChanged();
        }
        for (int index = 0; index < length.length; ++index) {
            if (length[index] == metaLength[index]) continue;
            meta.setChanged(true);
        }
        meta.setLength(length);
        if (this.getInKeyPrecision() >= 0) {
            precision[fields.getKeyIndex()] = this.getInKeyPrecision();
        }
        if (this.getInValuePrecision() >= 0) {
            precision[fields.getValueIndex()] = this.getInValuePrecision();
        }
        if ((metaPrecision = meta.getPrecision()) == null || metaPrecision.length != 2) {
            meta.setChanged();
        }
        for (int index = 0; index < precision.length; ++index) {
            if (precision[index] == metaPrecision[index]) continue;
            meta.setChanged(true);
        }
        meta.setPrecision(type);
    }

    private class FieldPositions {
        private int key;
        private int value;

        public FieldPositions(String[] fieldnames) {
            this.setKeyIndex(-1);
            this.setValueIndex(-1);
            if (fieldnames != null && fieldnames.length == 2) {
                for (int index = 0; index < fieldnames.length; ++index) {
                    if (fieldnames[index].equals("key")) {
                        this.setKeyIndex(index);
                        continue;
                    }
                    if (!fieldnames[index].equals("value")) continue;
                    this.setValueIndex(index);
                }
            }
        }

        public void setKeyIndex(int key) {
            this.key = key;
        }

        public int getKeyIndex() {
            return this.key;
        }

        public void setValueIndex(int value) {
            this.value = value;
        }

        public int getValueIndex() {
            return this.value;
        }

        public boolean isValid() {
            return this.getKeyIndex() >= 0 && this.getValueIndex() >= 0 && this.getKeyIndex() != this.getValueIndex();
        }
    }
}

