/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.nio.ByteBuffer;

class BinaryType
extends AbstractColumnType {
    private final int length;
    private byte[] data;

    BinaryType(int len) {
        this.length = len;
        this.data = new byte[len];
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        byteBuffer.get(this.data);
    }

    public String getDataAsString() {
        StringBuffer sb = new StringBuffer();
        for (byte b : this.data) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public void getData(ByteBuffer byteBuffer) {
        byteBuffer.put(this.data);
    }

    public void setData(String string) {
        int numbytes = string.length() / 2;
        if (this.isCheckValues() && numbytes > this.length) {
            throw new ValueConverterException("data is too big for this column");
        }
        int offset = 0;
        for (int i = 0; i < string.length(); i += 2) {
            String hex = string.substring(i, i + 2);
            this.data[offset++] = (byte)Integer.parseInt(hex, 16);
        }
        this.padZerosStartingAt(numbytes);
    }

    private void padZerosStartingAt(int startIdx) {
        for (int i = startIdx; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
    }

    protected void zeroOutData() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
    }

    public void setData(Object value, ValueConverter meta) throws ValueConverterException {
        if (value == null) {
            this.setIsNull(true);
        } else {
            byte[] bytes = meta.getBinary(value);
            if (bytes == null) {
                this.setIsNull(true);
            } else {
                this.setIsNull(false);
                if (this.isCheckValues() && bytes.length > this.length) {
                    throw new ValueConverterException("data is too big for this column");
                }
                System.arraycopy(bytes, 0, this.data, 0, bytes.length);
                this.padZerosStartingAt(bytes.length);
            }
        }
    }

    public final boolean isNeedsEnclosures() {
        return true;
    }
}

