/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.BigintType;
import com.infobright.etl.model.datatype.BinaryType;
import com.infobright.etl.model.datatype.CharType;
import com.infobright.etl.model.datatype.DateIntType;
import com.infobright.etl.model.datatype.DatetimeType;
import com.infobright.etl.model.datatype.DecimalType;
import com.infobright.etl.model.datatype.DoubleType;
import com.infobright.etl.model.datatype.FloatType;
import com.infobright.etl.model.datatype.IntegerType;
import com.infobright.etl.model.datatype.MediumintType;
import com.infobright.etl.model.datatype.SmallintType;
import com.infobright.etl.model.datatype.TextType;
import com.infobright.etl.model.datatype.TimeType;
import com.infobright.etl.model.datatype.TinyintType;
import com.infobright.etl.model.datatype.VarbinaryType;
import com.infobright.etl.model.datatype.VarcharType;
import com.infobright.etl.model.datatype.YearType;
import com.infobright.logging.EtlLogger;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class AbstractColumnType {
    private String columnName;
    private boolean isNull;
    private boolean checkValues = false;

    public abstract void setData(ByteBuffer var1) throws InvalidDataException;

    public abstract void setData(String var1);

    public abstract String getDataAsString();

    public abstract void getData(ByteBuffer var1);

    public void setIsNull(boolean b) {
        this.isNull = b;
        if (b) {
            this.zeroOutData();
        }
    }

    public boolean getIsNull() {
        return this.isNull;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    protected abstract void zeroOutData();

    public abstract void setData(Object var1, ValueConverter var2) throws ValueConverterException;

    public abstract boolean isNeedsEnclosures();

    public void setCheckValues(boolean checkValues) {
        this.checkValues = checkValues;
    }

    public boolean isCheckValues() {
        return this.checkValues;
    }

    public static AbstractColumnType getInstance(String columnName, int columnType, String columnTypeName, int precision, int scale, Charset charset, EtlLogger logger) {
        if (logger != null) {
            String logMsg = scale == 0 ? String.format("Column: %s %s(%d)", columnName, columnTypeName, precision) : String.format("Column: %s %s(%d,%d)", columnName, columnTypeName, precision, scale);
            logger.info(logMsg);
        }
        AbstractColumnType col = null;
        if (columnType == 12) {
            col = new VarcharType(precision, charset);
        } else if (columnType == 5) {
            col = new SmallintType();
        } else if (columnType == 4) {
            col = "MEDIUMINT".equalsIgnoreCase(columnTypeName) ? new MediumintType() : new IntegerType();
        } else if (columnType == -6 || columnType == 16) {
            col = new TinyintType();
        } else if (columnType == -5) {
            col = new BigintType();
        } else if (columnType == 6 || columnType == 7) {
            col = new FloatType();
        } else if (columnType == 8) {
            col = new DoubleType();
        } else if (columnType == 1) {
            col = new CharType(precision, charset);
        } else if (columnType == 93) {
            col = new DatetimeType();
        } else if (columnType == 91) {
            col = precision == 4 ? new YearType() : new DateIntType();
        } else if (columnType == -2) {
            col = new BinaryType(precision);
        } else if (columnType == -3) {
            col = new VarbinaryType(precision);
        } else if (columnType == -1) {
            col = new TextType(precision, charset);
        } else if (columnType == 3) {
            col = new DecimalType(precision, scale);
        } else if (columnType == 92) {
            col = new TimeType();
        } else {
            throw new RuntimeException("Unsupported type (" + columnTypeName + "," + columnType + ") for column " + columnName);
        }
        col.setColumnName(columnName);
        return col;
    }

    public class InvalidDataException
    extends Exception {
        private static final long serialVersionUID = -222513235333508756L;

        public InvalidDataException(UnsupportedEncodingException e) {
            super(e);
        }
    }
}

