/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.jdbc;

import io.reactivex.Observer;
import java.io.DataInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;
import org.pentaho.di.trans.dataservice.jdbc.ThinBase;
import org.pentaho.di.trans.dataservice.jdbc.ThinConnection;
import org.pentaho.di.trans.dataservice.jdbc.ThinResultFactory;
import org.pentaho.di.trans.dataservice.jdbc.ThinResultSet;
import org.pentaho.di.trans.dataservice.jdbc.annotation.NotSupported;
import org.pentaho.di.trans.dataservice.jdbc.api.IThinStatement;

public class ThinStatement
extends ThinBase
implements IThinStatement {
    protected final ThinConnection connection;
    private final ThinResultFactory resultFactory;
    private ThinResultSet resultSet;
    protected int maxRows = -1;

    public ThinStatement(ThinConnection connection) {
        this(connection, new ThinResultFactory());
    }

    protected ThinStatement(ThinConnection connection, ThinResultFactory resultFactory) {
        this.connection = connection;
        this.resultFactory = resultFactory;
        this.connection.registerStatement(this);
    }

    @NotSupported
    public void addBatch(String arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    public void cancel() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.connection.unregisterStatement(this);
    }

    @NotSupported
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batch update statements are not supported by the thin Kettle JDBC driver");
    }

    public void close() throws SQLException {
        this.cancel();
    }

    public boolean execute(String sql) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    public boolean execute(String sql, int[] arg1) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    public boolean execute(String sql, String[] arg1) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    @NotSupported
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batch update statements are not supported by the thin Kettle JDBC driver");
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        DataInputStream dataInputStream = this.connection.getClientService().query(sql, this.maxRows, this.connection.getParameters());
        this.resultSet = this.resultFactory.loadResultSet(dataInputStream, this.connection.getClientService());
        this.resultSet.setStatement(this);
        return this.resultSet;
    }

    public ResultSet executeQuery(String sql, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, long windowLimit) throws SQLException {
        DataInputStream dataInputStream = this.connection.getClientService().query(sql, windowMode, windowSize, windowEvery, windowLimit, this.connection.getParameters());
        this.resultSet = this.resultFactory.loadResultSet(dataInputStream, this.connection.getClientService());
        this.resultSet.setStatement(this);
        return this.resultSet;
    }

    @NotSupported
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("The thin Kettle JDBC driver is read-only");
    }

    @NotSupported
    public int executeUpdate(String sql, int arg1) throws SQLException {
        return this.executeUpdate(sql);
    }

    @NotSupported
    public int executeUpdate(String sql, int[] arg1) throws SQLException {
        return this.executeUpdate(sql);
    }

    @NotSupported
    public int executeUpdate(String sql, String[] arg1) throws SQLException {
        return this.executeUpdate(sql);
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return 1;
    }

    @NotSupported
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("The thin Kettle JDBC driver is read-only");
    }

    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    public boolean getMoreResults() throws SQLException {
        if (this.resultSet == null) {
            throw new SQLException("Statement is closed.");
        }
        if (this.resultSet.isLast() || this.resultSet.isClosed()) {
            this.resultSet.close();
            return false;
        }
        return true;
    }

    public boolean getMoreResults(int current) throws SQLException {
        if (current != 1) {
            throw new SQLFeatureNotSupportedException("Multiple open result sets not supported");
        }
        return this.getMoreResults();
    }

    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSet.getConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.resultSet.getHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.resultSet.getType();
    }

    public int getUpdateCount() throws SQLException {
        return 0;
    }

    public boolean isClosed() throws SQLException {
        return this.resultSet.isClosed();
    }

    public boolean isPoolable() throws SQLException {
        return false;
    }

    @NotSupported
    public void setCursorName(String arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Named cursors not supported");
    }

    public void setEscapeProcessing(boolean arg0) throws SQLException {
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only FETCH_FORWARD direction is supported");
        }
    }

    public void setFetchSize(int arg0) throws SQLException {
    }

    public void setMaxFieldSize(int arg0) throws SQLException {
    }

    public void setPoolable(boolean arg0) throws SQLException {
    }

    public void setQueryTimeout(int arg0) throws SQLException {
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void closeOnCompletion() throws SQLException {
    }

    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    public void executePushQuery(String sql, IDataServiceClientService.IStreamingParams streamParams, Observer<List<RowMetaAndData>> consumer) throws Exception {
        if (!this.connection.isLocal()) {
            throw new UnsupportedOperationException("Only available in local mode.");
        }
        this.connection.getClientService().query(sql, streamParams, this.connection.getParameters(), consumer);
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        if (type.isAssignableFrom(ThinStatement.class) || type.isAssignableFrom(IDataServiceClientService.class)) {
            return true;
        }
        return super.isWrapperFor(type);
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        if (type.isAssignableFrom(ThinStatement.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(IDataServiceClientService.class)) {
            return type.cast(this.connection.getClientService());
        }
        return super.unwrap(type);
    }
}

