/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.BaseEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.MetricsCoprocessor;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessor;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.WALObserver;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class WALCoprocessorHost
extends CoprocessorHost<WALCoprocessor, WALCoprocessorEnvironment> {
    private static final Logger LOG = LoggerFactory.getLogger(WALCoprocessorHost.class);
    private final WAL wal;
    private CoprocessorHost.ObserverGetter<WALCoprocessor, WALObserver> walObserverGetter = WALCoprocessor::getWALObserver;

    public WALCoprocessorHost(WAL log, Configuration conf) {
        super(null);
        this.wal = log;
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.wal.classes");
    }

    @Override
    public WALEnvironment createEnvironment(WALCoprocessor instance, int priority, int seq, Configuration conf) {
        return new WALEnvironment(instance, priority, seq, conf, this.wal);
    }

    @Override
    public WALCoprocessor checkAndGetInstance(Class<?> implClass) throws IllegalAccessException, InstantiationException {
        if (WALCoprocessor.class.isAssignableFrom(implClass)) {
            try {
                return implClass.asSubclass(WALCoprocessor.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                throw (InstantiationException)new InstantiationException(implClass.getName()).initCause(e);
            }
        }
        LOG.error(implClass.getName() + " is not of type WALCoprocessor. Check the " + "configuration " + "hbase.coprocessor.wal.classes");
        return null;
    }

    public void preWALWrite(final RegionInfo info, final WALKey logKey, final WALEdit logEdit) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(new WALObserverOperation(){

            @Override
            public void call(WALObserver oserver) throws IOException {
                oserver.preWALWrite(this, info, logKey, logEdit);
            }
        });
    }

    public void postWALWrite(final RegionInfo info, final WALKey logKey, final WALEdit logEdit) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new WALObserverOperation(){

            @Override
            protected void call(WALObserver observer) throws IOException {
                observer.postWALWrite(this, info, logKey, logEdit);
            }
        });
    }

    public void preWALRoll(final Path oldPath, final Path newPath) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new WALObserverOperation(){

            @Override
            protected void call(WALObserver observer) throws IOException {
                observer.preWALRoll(this, oldPath, newPath);
            }
        });
    }

    public void postWALRoll(final Path oldPath, final Path newPath) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new WALObserverOperation(){

            @Override
            protected void call(WALObserver observer) throws IOException {
                observer.postWALRoll(this, oldPath, newPath);
            }
        });
    }

    abstract class WALObserverOperation
    extends CoprocessorHost.ObserverOperationWithoutResult<WALObserver> {
        public WALObserverOperation() {
            super(WALCoprocessorHost.this, WALCoprocessorHost.this.walObserverGetter);
        }
    }

    static class WALEnvironment
    extends BaseEnvironment<WALCoprocessor>
    implements WALCoprocessorEnvironment {
        private final WAL wal;
        private final MetricRegistry metricRegistry;

        @Override
        public WAL getWAL() {
            return this.wal;
        }

        private WALEnvironment(WALCoprocessor impl, int priority, int seq, Configuration conf, WAL wal) {
            super(impl, priority, seq, conf);
            this.wal = wal;
            this.metricRegistry = MetricsCoprocessor.createRegistryForWALCoprocessor(impl.getClass().getName());
        }

        @Override
        public MetricRegistry getMetricRegistryForRegionServer() {
            return this.metricRegistry;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            MetricsCoprocessor.removeRegistry(this.metricRegistry);
        }
    }
}

