/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.procedure.FairQueue;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.MetaProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.MetaQueue;
import org.apache.hadoop.hbase.master.procedure.Queue;
import org.apache.hadoop.hbase.master.procedure.SchemaLocking;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ServerQueue;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.TableQueue;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.LockAndQueue;
import org.apache.hadoop.hbase.procedure2.LockStatus;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.LockedResourceType;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureDeque;
import org.apache.hadoop.hbase.util.AvlUtil;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterProcedureScheduler
extends AbstractProcedureScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(MasterProcedureScheduler.class);
    private static final AvlUtil.AvlKeyComparator<ServerQueue> SERVER_QUEUE_KEY_COMPARATOR = (n, k) -> n.compareKey((ServerName)k);
    private static final AvlUtil.AvlKeyComparator<TableQueue> TABLE_QUEUE_KEY_COMPARATOR = (n, k) -> n.compareKey((TableName)k);
    private static final AvlUtil.AvlKeyComparator<MetaQueue> META_QUEUE_KEY_COMPARATOR = (n, k) -> n.compareKey((TableName)k);
    private final FairQueue<ServerName> serverRunQueue = new FairQueue();
    private final FairQueue<TableName> tableRunQueue = new FairQueue();
    private final FairQueue<TableName> metaRunQueue = new FairQueue();
    private final ServerQueue[] serverBuckets = new ServerQueue[128];
    private TableQueue tableMap = null;
    private MetaQueue metaMap = null;
    private final SchemaLocking locking = new SchemaLocking();

    public void yield(Procedure proc) {
        this.push(proc, MasterProcedureScheduler.isTableProcedure(proc), true);
    }

    protected void enqueue(Procedure proc, boolean addFront) {
        if (MasterProcedureScheduler.isMetaProcedure(proc)) {
            this.doAdd(this.metaRunQueue, this.getMetaQueue(), proc, addFront);
        } else if (MasterProcedureScheduler.isTableProcedure(proc)) {
            this.doAdd(this.tableRunQueue, this.getTableQueue(MasterProcedureScheduler.getTableName(proc)), proc, addFront);
        } else if (MasterProcedureScheduler.isServerProcedure(proc)) {
            this.doAdd(this.serverRunQueue, this.getServerQueue(MasterProcedureScheduler.getServerName(proc)), proc, addFront);
        } else {
            throw new UnsupportedOperationException("RQs for non-table/non-server procedures are not implemented yet: " + proc);
        }
    }

    private <T extends Comparable<T>> void doAdd(FairQueue<T> fairq, Queue<T> queue, Procedure proc, boolean addFront) {
        queue.add(proc, addFront);
        if (!queue.getLockStatus().hasExclusiveLock() || queue.getLockStatus().isLockOwner(proc.getProcId())) {
            MasterProcedureScheduler.addToRunQueue(fairq, queue);
        } else if (queue.getLockStatus().hasParentLock(proc)) {
            assert (addFront) : "expected to add a child in the front";
            MasterProcedureScheduler.addToRunQueue(fairq, queue);
        }
    }

    protected boolean queueHasRunnables() {
        return this.metaRunQueue.hasRunnables() || this.tableRunQueue.hasRunnables() || this.serverRunQueue.hasRunnables();
    }

    protected Procedure dequeue() {
        Procedure<?> pollResult = this.doPoll(this.metaRunQueue);
        if (pollResult == null) {
            pollResult = this.doPoll(this.serverRunQueue);
        }
        if (pollResult == null) {
            pollResult = this.doPoll(this.tableRunQueue);
        }
        return pollResult;
    }

    private <T extends Comparable<T>> Procedure<?> doPoll(FairQueue<T> fairq) {
        Procedure<?> nextProc;
        Queue<T> rq = fairq.poll();
        if (rq == null || !rq.isAvailable()) {
            return null;
        }
        Procedure<?> pollResult = rq.peek();
        if (pollResult == null) {
            return null;
        }
        boolean xlockReq = rq.requireExclusiveLock(pollResult);
        if (xlockReq && rq.getLockStatus().isLocked() && !rq.getLockStatus().hasLockAccess(pollResult)) {
            MasterProcedureScheduler.removeFromRunQueue(fairq, rq);
            return null;
        }
        rq.poll();
        if (rq.isEmpty() || xlockReq) {
            MasterProcedureScheduler.removeFromRunQueue(fairq, rq);
        } else if (rq.getLockStatus().hasParentLock(pollResult) && (nextProc = rq.peek()) != null && !Procedure.haveSameParent(nextProc, pollResult) && nextProc.getRootProcId() != pollResult.getRootProcId()) {
            MasterProcedureScheduler.removeFromRunQueue(fairq, rq);
        }
        return pollResult;
    }

    public List<LockedResource> getLocks() {
        this.schedLock();
        try {
            List<LockedResource> list = this.locking.getLocks();
            return list;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockedResource getLockResource(LockedResourceType resourceType, String resourceName) {
        this.schedLock();
        try {
            LockedResource lockedResource = this.locking.getLockResource(resourceType, resourceName);
            return lockedResource;
        }
        finally {
            this.schedUnlock();
        }
    }

    public void clear() {
        this.schedLock();
        try {
            this.clearQueue();
            this.locking.clear();
        }
        finally {
            this.schedUnlock();
        }
    }

    private void clearQueue() {
        for (int i = 0; i < this.serverBuckets.length; ++i) {
            this.clear(this.serverBuckets[i], this.serverRunQueue, SERVER_QUEUE_KEY_COMPARATOR);
            this.serverBuckets[i] = null;
        }
        this.clear(this.tableMap, this.tableRunQueue, TABLE_QUEUE_KEY_COMPARATOR);
        this.tableMap = null;
        assert (this.size() == 0) : "expected queue size to be 0, got " + this.size();
    }

    private <T extends Comparable<T>, TNode extends Queue<T>> void clear(TNode treeMap, FairQueue<T> fairq, AvlUtil.AvlKeyComparator<TNode> comparator) {
        while (treeMap != null) {
            Queue node = (Queue)AvlUtil.AvlTree.getFirst(treeMap);
            treeMap = (Queue)AvlUtil.AvlTree.remove(treeMap, node.getKey(), comparator);
            if (fairq == null) continue;
            MasterProcedureScheduler.removeFromRunQueue(fairq, node);
        }
    }

    private int queueSize(Queue<?> head) {
        int count = 0;
        AvlUtil.AvlTreeIterator iter = new AvlUtil.AvlTreeIterator(head);
        while (iter.hasNext()) {
            count += ((Queue)iter.next()).size();
        }
        return count;
    }

    protected int queueSize() {
        int count = 0;
        for (ServerQueue serverMap : this.serverBuckets) {
            count += this.queueSize(serverMap);
        }
        count += this.queueSize(this.tableMap);
        return count += this.queueSize(this.metaMap);
    }

    public void completionCleanup(Procedure proc) {
        if (proc instanceof TableProcedureInterface) {
            boolean tableDeleted;
            TableProcedureInterface iProcTable = (TableProcedureInterface)proc;
            if (proc.hasException()) {
                Exception procEx = proc.getException().unwrapRemoteException();
                tableDeleted = iProcTable.getTableOperationType() == TableProcedureInterface.TableOperationType.CREATE ? !(procEx instanceof TableExistsException) : procEx instanceof TableNotFoundException;
            } else {
                boolean bl = tableDeleted = iProcTable.getTableOperationType() == TableProcedureInterface.TableOperationType.DELETE;
            }
            if (tableDeleted) {
                this.markTableAsDeleted(iProcTable.getTableName(), proc);
                return;
            }
        } else {
            return;
        }
    }

    private static <T extends Comparable<T>> void addToRunQueue(FairQueue<T> fairq, Queue<T> queue) {
        if (!AvlUtil.AvlIterableList.isLinked(queue) && !queue.isEmpty()) {
            fairq.add(queue);
        }
    }

    private static <T extends Comparable<T>> void removeFromRunQueue(FairQueue<T> fairq, Queue<T> queue) {
        if (AvlUtil.AvlIterableList.isLinked(queue)) {
            fairq.remove(queue);
        }
    }

    private TableQueue getTableQueue(TableName tableName) {
        TableQueue node = (TableQueue)AvlUtil.AvlTree.get((AvlUtil.AvlNode)this.tableMap, (Object)tableName, TABLE_QUEUE_KEY_COMPARATOR);
        if (node != null) {
            return node;
        }
        node = new TableQueue(tableName, MasterProcedureUtil.getTablePriority(tableName), (LockStatus)this.locking.getTableLock(tableName), (LockStatus)this.locking.getNamespaceLock(tableName.getNamespaceAsString()));
        this.tableMap = (TableQueue)AvlUtil.AvlTree.insert((AvlUtil.AvlNode)this.tableMap, (AvlUtil.AvlNode)node);
        return node;
    }

    private void removeTableQueue(TableName tableName) {
        this.tableMap = (TableQueue)AvlUtil.AvlTree.remove((AvlUtil.AvlNode)this.tableMap, (Object)tableName, TABLE_QUEUE_KEY_COMPARATOR);
        this.locking.removeTableLock(tableName);
    }

    private static boolean isTableProcedure(Procedure proc) {
        return proc instanceof TableProcedureInterface;
    }

    private static TableName getTableName(Procedure proc) {
        return ((TableProcedureInterface)proc).getTableName();
    }

    private ServerQueue getServerQueue(ServerName serverName) {
        int index = MasterProcedureScheduler.getBucketIndex((Object[])this.serverBuckets, serverName.hashCode());
        ServerQueue node = (ServerQueue)AvlUtil.AvlTree.get((AvlUtil.AvlNode)this.serverBuckets[index], (Object)serverName, SERVER_QUEUE_KEY_COMPARATOR);
        if (node != null) {
            return node;
        }
        node = new ServerQueue(serverName, (LockStatus)this.locking.getServerLock(serverName));
        this.serverBuckets[index] = (ServerQueue)AvlUtil.AvlTree.insert((AvlUtil.AvlNode)this.serverBuckets[index], (AvlUtil.AvlNode)node);
        return node;
    }

    private static int getBucketIndex(Object[] buckets, int hashCode) {
        return Math.abs(hashCode) % buckets.length;
    }

    private static boolean isServerProcedure(Procedure proc) {
        return proc instanceof ServerProcedureInterface;
    }

    private static ServerName getServerName(Procedure proc) {
        return ((ServerProcedureInterface)proc).getServerName();
    }

    private MetaQueue getMetaQueue() {
        MetaQueue node = (MetaQueue)AvlUtil.AvlTree.get((AvlUtil.AvlNode)this.metaMap, (Object)TableName.META_TABLE_NAME, META_QUEUE_KEY_COMPARATOR);
        if (node != null) {
            return node;
        }
        node = new MetaQueue((LockStatus)this.locking.getMetaLock());
        this.metaMap = (MetaQueue)AvlUtil.AvlTree.insert((AvlUtil.AvlNode)this.metaMap, (AvlUtil.AvlNode)node);
        return node;
    }

    private static boolean isMetaProcedure(Procedure<?> proc) {
        return proc instanceof MetaProcedureInterface;
    }

    private void logLockedResource(LockedResourceType resourceType, String resourceName) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LockedResource lockedResource = this.getLockResource(resourceType, resourceName);
        if (lockedResource != null) {
            String msg = resourceType.toString() + " '" + resourceName + "', shared lock count=" + lockedResource.getSharedLockCount();
            Procedure proc = lockedResource.getExclusiveLockOwnerProcedure();
            if (proc != null) {
                msg = msg + ", exclusively locked by procId=" + proc.getProcId();
            }
            LOG.debug(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitTableExclusiveLock(Procedure procedure, TableName table) {
        this.schedLock();
        try {
            String namespace = table.getNamespaceAsString();
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(namespace);
            LockAndQueue tableLock = this.locking.getTableLock(table);
            if (!namespaceLock.trySharedLock()) {
                this.waitProcedure((ProcedureDeque)namespaceLock, procedure);
                this.logLockedResource(LockedResourceType.NAMESPACE, namespace);
                boolean bl = true;
                return bl;
            }
            if (!tableLock.tryExclusiveLock(procedure)) {
                namespaceLock.releaseSharedLock();
                this.waitProcedure((ProcedureDeque)tableLock, procedure);
                this.logLockedResource(LockedResourceType.TABLE, table.getNameAsString());
                boolean bl = true;
                return bl;
            }
            MasterProcedureScheduler.removeFromRunQueue(this.tableRunQueue, this.getTableQueue(table));
            boolean bl = false;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeTableExclusiveLock(Procedure procedure, TableName table) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(table.getNamespaceAsString());
            LockAndQueue tableLock = this.locking.getTableLock(table);
            int waitingCount = 0;
            if (!tableLock.hasParentLock(procedure)) {
                tableLock.releaseExclusiveLock(procedure);
                waitingCount += this.wakeWaitingProcedures((ProcedureDeque)tableLock);
            }
            if (namespaceLock.releaseSharedLock()) {
                waitingCount += this.wakeWaitingProcedures((ProcedureDeque)namespaceLock);
            }
            MasterProcedureScheduler.addToRunQueue(this.tableRunQueue, this.getTableQueue(table));
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    public boolean waitTableSharedLock(Procedure procedure, TableName table) {
        return this.waitTableQueueSharedLock(procedure, table) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableQueue waitTableQueueSharedLock(Procedure<?> procedure, TableName table) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(table.getNamespaceAsString());
            LockAndQueue tableLock = this.locking.getTableLock(table);
            if (!namespaceLock.trySharedLock()) {
                this.waitProcedure((ProcedureDeque)namespaceLock, procedure);
                TableQueue tableQueue = null;
                return tableQueue;
            }
            if (!tableLock.trySharedLock()) {
                namespaceLock.releaseSharedLock();
                this.waitProcedure((ProcedureDeque)tableLock, procedure);
                TableQueue tableQueue = null;
                return tableQueue;
            }
            TableQueue tableQueue = this.getTableQueue(table);
            return tableQueue;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeTableSharedLock(Procedure procedure, TableName table) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(table.getNamespaceAsString());
            LockAndQueue tableLock = this.locking.getTableLock(table);
            int waitingCount = 0;
            if (tableLock.releaseSharedLock()) {
                MasterProcedureScheduler.addToRunQueue(this.tableRunQueue, this.getTableQueue(table));
                waitingCount += this.wakeWaitingProcedures((ProcedureDeque)tableLock);
            }
            if (namespaceLock.releaseSharedLock()) {
                waitingCount += this.wakeWaitingProcedures((ProcedureDeque)namespaceLock);
            }
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean markTableAsDeleted(TableName table, Procedure<?> procedure) {
        block7: {
            this.schedLock();
            try {
                TableQueue queue = this.getTableQueue(table);
                LockAndQueue tableLock = this.locking.getTableLock(table);
                if (queue == null) {
                    boolean bl = true;
                    return bl;
                }
                if (queue.isEmpty() && tableLock.tryExclusiveLock(procedure)) {
                    if (AvlUtil.AvlIterableList.isLinked((AvlUtil.AvlLinkedNode)queue)) {
                        this.tableRunQueue.remove(queue);
                    }
                    this.removeTableQueue(table);
                    break block7;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.schedUnlock();
            }
        }
        return true;
    }

    public boolean waitRegion(Procedure procedure, RegionInfo regionInfo) {
        return this.waitRegions(procedure, regionInfo.getTable(), regionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitRegions(Procedure procedure, TableName table, RegionInfo ... regionInfo) {
        Arrays.sort(regionInfo, RegionInfo.COMPARATOR);
        this.schedLock();
        try {
            if (!procedure.hasParent() && this.waitTableQueueSharedLock(procedure, table) == null) {
                boolean bl = true;
                return bl;
            }
            boolean hasLock = true;
            LockAndQueue[] regionLocks = new LockAndQueue[regionInfo.length];
            for (int i = 0; i < regionInfo.length; ++i) {
                LOG.info("{} checking lock on {}", (Object)procedure, (Object)regionInfo[i].getEncodedName());
                assert (table != null);
                assert (regionInfo[i] != null);
                assert (regionInfo[i].getTable() != null);
                assert (regionInfo[i].getTable().equals((Object)table)) : regionInfo[i] + " " + procedure;
                assert (i == 0 || regionInfo[i] != regionInfo[i - 1]) : "duplicate region: " + regionInfo[i];
                regionLocks[i] = this.locking.getRegionLock(regionInfo[i].getEncodedName());
                if (regionLocks[i].tryExclusiveLock(procedure)) continue;
                this.waitProcedure((ProcedureDeque)regionLocks[i], procedure);
                hasLock = false;
                while (i-- > 0) {
                    regionLocks[i].releaseExclusiveLock(procedure);
                }
                break;
            }
            if (!hasLock && !procedure.hasParent()) {
                this.wakeTableSharedLock(procedure, table);
            }
            boolean bl = !hasLock;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    public void wakeRegion(Procedure procedure, RegionInfo regionInfo) {
        this.wakeRegions(procedure, regionInfo.getTable(), regionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeRegions(Procedure procedure, TableName table, RegionInfo ... regionInfo) {
        Arrays.sort(regionInfo, RegionInfo.COMPARATOR);
        this.schedLock();
        try {
            int i;
            int numProcs = 0;
            Procedure[] nextProcs = new Procedure[regionInfo.length];
            for (i = 0; i < regionInfo.length; ++i) {
                assert (regionInfo[i].getTable().equals((Object)table));
                assert (i == 0 || regionInfo[i] != regionInfo[i - 1]) : "duplicate region: " + regionInfo[i];
                LockAndQueue regionLock = this.locking.getRegionLock(regionInfo[i].getEncodedName());
                if (!regionLock.releaseExclusiveLock(procedure)) continue;
                if (!regionLock.isEmpty()) {
                    nextProcs[numProcs++] = (Procedure)regionLock.removeFirst();
                    continue;
                }
                this.locking.removeRegionLock(regionInfo[i].getEncodedName());
            }
            for (i = numProcs - 1; i >= 0; --i) {
                this.wakeProcedure(nextProcs[i]);
            }
            this.wakePollIfNeeded(numProcs);
            if (!procedure.hasParent()) {
                this.wakeTableSharedLock(procedure, table);
            }
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitNamespaceExclusiveLock(Procedure procedure, String namespace) {
        this.schedLock();
        try {
            LockAndQueue systemNamespaceTableLock = this.locking.getTableLock(TableName.NAMESPACE_TABLE_NAME);
            if (!systemNamespaceTableLock.trySharedLock()) {
                this.waitProcedure((ProcedureDeque)systemNamespaceTableLock, procedure);
                this.logLockedResource(LockedResourceType.TABLE, TableName.NAMESPACE_TABLE_NAME.getNameAsString());
                boolean bl = true;
                return bl;
            }
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(namespace);
            if (!namespaceLock.tryExclusiveLock(procedure)) {
                systemNamespaceTableLock.releaseSharedLock();
                this.waitProcedure((ProcedureDeque)namespaceLock, procedure);
                this.logLockedResource(LockedResourceType.NAMESPACE, namespace);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNamespaceExclusiveLock(Procedure procedure, String namespace) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(namespace);
            LockAndQueue systemNamespaceTableLock = this.locking.getTableLock(TableName.NAMESPACE_TABLE_NAME);
            namespaceLock.releaseExclusiveLock(procedure);
            int waitingCount = 0;
            if (systemNamespaceTableLock.releaseSharedLock()) {
                MasterProcedureScheduler.addToRunQueue(this.tableRunQueue, this.getTableQueue(TableName.NAMESPACE_TABLE_NAME));
                waitingCount += this.wakeWaitingProcedures((ProcedureDeque)systemNamespaceTableLock);
            }
            this.wakePollIfNeeded(waitingCount += this.wakeWaitingProcedures((ProcedureDeque)namespaceLock));
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitServerExclusiveLock(Procedure procedure, ServerName serverName) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getServerLock(serverName);
            if (lock.tryExclusiveLock(procedure)) {
                MasterProcedureScheduler.removeFromRunQueue(this.serverRunQueue, this.getServerQueue(serverName));
                boolean bl = false;
                return bl;
            }
            this.waitProcedure((ProcedureDeque)lock, procedure);
            this.logLockedResource(LockedResourceType.SERVER, serverName.getServerName());
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeServerExclusiveLock(Procedure procedure, ServerName serverName) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getServerLock(serverName);
            lock.releaseExclusiveLock(procedure);
            MasterProcedureScheduler.addToRunQueue(this.serverRunQueue, this.getServerQueue(serverName));
            int waitingCount = this.wakeWaitingProcedures((ProcedureDeque)lock);
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitMetaExclusiveLock(Procedure<?> procedure) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getMetaLock();
            if (lock.tryExclusiveLock(procedure)) {
                MasterProcedureScheduler.removeFromRunQueue(this.metaRunQueue, this.getMetaQueue());
                boolean bl = false;
                return bl;
            }
            this.waitProcedure((ProcedureDeque)lock, procedure);
            this.logLockedResource(LockedResourceType.META, TableName.META_TABLE_NAME.getNameAsString());
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeMetaExclusiveLock(Procedure<?> procedure) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getMetaLock();
            lock.releaseExclusiveLock(procedure);
            MasterProcedureScheduler.addToRunQueue(this.metaRunQueue, this.getMetaQueue());
            int waitingCount = this.wakeWaitingProcedures((ProcedureDeque)lock);
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    @VisibleForTesting
    public String dumpLocks() throws IOException {
        this.schedLock();
        try {
            String string = this.locking.toString();
            return string;
        }
        finally {
            this.schedUnlock();
        }
    }
}

