/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.caching.impl;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.pentaho.caching.api.Constants;
import org.pentaho.caching.api.PentahoCacheManager;
import org.pentaho.caching.api.PentahoCacheProvidingService;
import org.pentaho.caching.api.PentahoCacheSystemConfiguration;
import org.pentaho.caching.impl.PentahoCacheManagerImpl;

public class PentahoCacheManagerFactory
implements ManagedServiceFactory {
    private final BundleContext bundleContext;
    private final ListMultimap<String, SettableFuture<PentahoCacheProvidingService>> providerMap;
    private final Map<String, RegistrationHandler> registrationHandlerMap;

    public PentahoCacheManagerFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.providerMap = LinkedListMultimap.create();
        this.registrationHandlerMap = Maps.newHashMap();
    }

    public void init() throws InvalidSyntaxException {
        String filter = MessageFormat.format("(&({0}={1})({2}=*))", "objectClass", PentahoCacheProvidingService.class.getName(), "pentaho.cache.provider");
        for (ServiceReference reference : this.bundleContext.getServiceReferences(PentahoCacheProvidingService.class, filter)) {
            String providerId = String.valueOf(reference.getProperty("pentaho.cache.provider"));
            PentahoCacheProvidingService service = (PentahoCacheProvidingService)this.bundleContext.getService(reference);
            this.registerProvider(providerId, service);
        }
        this.bundleContext.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                String providerId = String.valueOf(event.getServiceReference().getProperty("pentaho.cache.provider"));
                PentahoCacheProvidingService service = (PentahoCacheProvidingService)PentahoCacheManagerFactory.this.bundleContext.getService(event.getServiceReference());
                if ((event.getType() & 4) > 0) {
                    PentahoCacheManagerFactory.this.unregisterProvider(providerId, service);
                }
                if ((event.getType() & 1) > 0) {
                    PentahoCacheManagerFactory.this.registerProvider(providerId, service);
                }
            }
        }, filter);
    }

    public String getName() {
        return "Pentaho Cache Manager Factory";
    }

    protected synchronized ListenableFuture<PentahoCacheProvidingService> getProviderService(String providerId) {
        List futureList = this.providerMap.get((Object)providerId);
        if (futureList.isEmpty()) {
            futureList.add(SettableFuture.create());
        }
        return (ListenableFuture)futureList.get(0);
    }

    public synchronized void updated(String pid, Dictionary<String, ?> dictionary) throws ConfigurationException {
        Map<String, String> properties = Constants.convertDictionary(dictionary);
        String providerId = properties.get("pentaho.cache.provider");
        if (providerId == null) {
            throw new ConfigurationException("pentaho.cache.provider", "required property not specified");
        }
        RegistrationHandler registrationHandler = this.registrationHandlerMap.get(pid);
        if (registrationHandler == null) {
            registrationHandler = new RegistrationHandler(pid, providerId, new PentahoCacheSystemConfiguration());
            registrationHandler.config.setData(properties);
            registrationHandler.startService();
        } else if (providerId.equals(registrationHandler.providerId)) {
            registrationHandler.config.setData(properties);
        } else {
            registrationHandler.config.setData(properties);
            registrationHandler = this.restartService(pid, providerId);
        }
        this.registrationHandlerMap.put(pid, registrationHandler);
    }

    public synchronized void registerProvider(String id, PentahoCacheProvidingService provider) {
        List futureList = this.providerMap.get((Object)id);
        if (futureList.isEmpty()) {
            futureList.add(SettableFuture.create());
        }
        for (SettableFuture future : futureList) {
            future.set((Object)provider);
        }
    }

    public synchronized void deleted(String pid) {
        RegistrationHandler registrationHandler = this.registrationHandlerMap.remove(pid);
        if (registrationHandler == null) {
            Logger.getLogger(this.getName()).log(Level.WARNING, "Attempted to delete unused pid: " + pid);
        } else {
            registrationHandler.shutdownService();
        }
    }

    public synchronized void unregisterProvider(String providerId, PentahoCacheProvidingService provider) {
        HashSet invalidFutures = Sets.newHashSet();
        Iterator iterator = this.providerMap.get((Object)providerId).iterator();
        while (iterator.hasNext()) {
            SettableFuture future = (SettableFuture)iterator.next();
            try {
                if (!future.isDone() || !((PentahoCacheProvidingService)future.get(10L, TimeUnit.SECONDS)).equals(provider)) continue;
                iterator.remove();
                invalidFutures.add(future);
            }
            catch (Throwable t) {
                Logger.getLogger(providerId).log(Level.WARNING, "Unexpected exception", t);
            }
        }
        HashSet pidSet = Sets.newHashSet();
        Iterator<RegistrationHandler> registrations = this.registrationHandlerMap.values().iterator();
        while (!invalidFutures.isEmpty() && registrations.hasNext()) {
            RegistrationHandler registrationHandler = registrations.next();
            if (!invalidFutures.contains(registrationHandler.serviceFuture)) continue;
            pidSet.add(registrationHandler.pid);
        }
        for (String pid : pidSet) {
            this.restartService(pid, providerId);
        }
    }

    private synchronized RegistrationHandler restartService(String pid, String providerId) {
        RegistrationHandler shutdown = this.registrationHandlerMap.remove(pid);
        RegistrationHandler startup = new RegistrationHandler(pid, providerId, shutdown.config);
        this.registrationHandlerMap.put(pid, startup);
        shutdown.shutdownService();
        startup.startService();
        return startup;
    }

    private class RegistrationHandler {
        private final String pid;
        private final String providerId;
        private final PentahoCacheSystemConfiguration config;
        private final ListenableFuture<PentahoCacheProvidingService> serviceFuture;
        private final SettableFuture<ServiceRegistration<?>> registrationFuture;
        private final Logger logger;

        public RegistrationHandler(String pid, String providerId, PentahoCacheSystemConfiguration systemConfiguration) {
            this.pid = pid;
            this.providerId = providerId;
            this.serviceFuture = PentahoCacheManagerFactory.this.getProviderService(providerId);
            this.config = systemConfiguration;
            this.registrationFuture = SettableFuture.create();
            this.logger = Logger.getLogger(pid);
        }

        void startService() {
            Futures.addCallback(this.serviceFuture, (FutureCallback)new FutureCallback<PentahoCacheProvidingService>(){

                public void onSuccess(PentahoCacheProvidingService providingService) {
                    if (!RegistrationHandler.this.registrationFuture.isDone()) {
                        PentahoCacheManagerImpl cacheManager = new PentahoCacheManagerImpl(RegistrationHandler.this.config, providingService);
                        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
                        serviceProperties.put("pentaho.cache.provider", RegistrationHandler.this.providerId);
                        serviceProperties.put("service.pid", RegistrationHandler.this.pid);
                        ServiceRegistration registration = PentahoCacheManagerFactory.this.bundleContext.registerService(PentahoCacheManager.class, (Object)cacheManager, serviceProperties);
                        RegistrationHandler.this.registrationFuture.set((Object)registration);
                        RegistrationHandler.this.logger.log(Level.INFO, "New Caching Service registered");
                    }
                }

                public void onFailure(Throwable t) {
                    RegistrationHandler.this.logger.log(Level.WARNING, "Caching Service startup failed", t);
                }
            });
        }

        public void shutdownService() {
            this.registrationFuture.cancel(false);
            Futures.addCallback(this.registrationFuture, (FutureCallback)new FutureCallback<ServiceRegistration<?>>(){

                public void onSuccess(ServiceRegistration<?> registration) {
                    registration.unregister();
                    RegistrationHandler.this.logger.log(Level.INFO, "Caching Service was shutdown");
                }

                public void onFailure(Throwable t) {
                    if (t instanceof CancellationException) {
                        RegistrationHandler.this.logger.log(Level.INFO, "Caching Service was disabled");
                    } else {
                        RegistrationHandler.this.logger.log(Level.WARNING, "Caching Service shutdown failed", t);
                    }
                }
            });
        }
    }
}

