/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.spark;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.logging.LogChannelInterface;

public class PatternMatchingStreamLogger
implements Runnable {
    private LogChannelInterface log;
    private InputStream is;
    private String[] patterns;
    private PatternMatchedListener listener;
    private AtomicBoolean stop;

    public PatternMatchingStreamLogger(LogChannelInterface log, InputStream is, String[] patterns, AtomicBoolean stop) {
        this.log = log;
        this.is = is;
        this.patterns = patterns;
        this.stop = stop;
    }

    @Override
    public void run() {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
        try {
            String line;
            while (!this.stop.get() && (line = br.readLine()) != null) {
                this.log.logBasic(line);
                for (String pattern : this.patterns) {
                    if (!line.contains(pattern) || this.listener == null) continue;
                    this.listener.onPatternFound(pattern);
                }
            }
        }
        catch (IOException e) {
            this.log.logError("", (Throwable)e);
        }
    }

    public void addPatternMatchedListener(PatternMatchedListener pml) {
        this.listener = pml;
    }

    public static interface PatternMatchedListener {
        public void onPatternFound(String var1);
    }
}

