/*
 * Decompiled with CFR 0.152.
 */
package flexjson.transformer;

import flexjson.transformer.AbstractTransformer;
import java.util.HashMap;
import java.util.Map;

public class HtmlEncoderTransformer
extends AbstractTransformer {
    private static final Map<Integer, String> htmlEntities = new HashMap<Integer, String>();

    public HtmlEncoderTransformer() {
        if (htmlEntities.isEmpty()) {
            htmlEntities.put(34, "&quot;");
            htmlEntities.put(38, "&amp;");
            htmlEntities.put(60, "&lt;");
            htmlEntities.put(62, "&gt;");
            htmlEntities.put(160, "&nbsp;");
            htmlEntities.put(169, "&copy;");
            htmlEntities.put(174, "&reg;");
            htmlEntities.put(192, "&Agrave;");
            htmlEntities.put(193, "&Aacute;");
            htmlEntities.put(194, "&Acirc;");
            htmlEntities.put(195, "&Atilde;");
            htmlEntities.put(196, "&Auml;");
            htmlEntities.put(197, "&Aring;");
            htmlEntities.put(198, "&AElig;");
            htmlEntities.put(199, "&Ccedil;");
            htmlEntities.put(200, "&Egrave;");
            htmlEntities.put(201, "&Eacute;");
            htmlEntities.put(202, "&Ecirc;");
            htmlEntities.put(203, "&Euml;");
            htmlEntities.put(204, "&Igrave;");
            htmlEntities.put(205, "&Iacute;");
            htmlEntities.put(206, "&Icirc;");
            htmlEntities.put(207, "&Iuml;");
            htmlEntities.put(208, "&ETH;");
            htmlEntities.put(209, "&Ntilde;");
            htmlEntities.put(210, "&Ograve;");
            htmlEntities.put(211, "&Oacute;");
            htmlEntities.put(212, "&Ocirc;");
            htmlEntities.put(213, "&Otilde;");
            htmlEntities.put(214, "&Ouml;");
            htmlEntities.put(216, "&Oslash;");
            htmlEntities.put(217, "&Ugrave;");
            htmlEntities.put(218, "&Uacute;");
            htmlEntities.put(219, "&Ucirc;");
            htmlEntities.put(220, "&Uuml;");
            htmlEntities.put(221, "&Yacute;");
            htmlEntities.put(222, "&THORN;");
            htmlEntities.put(223, "&szlig;");
            htmlEntities.put(224, "&agrave;");
            htmlEntities.put(225, "&aacute;");
            htmlEntities.put(226, "&acirc;");
            htmlEntities.put(227, "&atilde;");
            htmlEntities.put(228, "&auml;");
            htmlEntities.put(229, "&aring;");
            htmlEntities.put(230, "&aelig;");
            htmlEntities.put(231, "&ccedil;");
            htmlEntities.put(232, "&egrave;");
            htmlEntities.put(233, "&eacute;");
            htmlEntities.put(234, "&ecirc;");
            htmlEntities.put(235, "&euml;");
            htmlEntities.put(236, "&igrave;");
            htmlEntities.put(237, "&iacute;");
            htmlEntities.put(238, "&icirc;");
            htmlEntities.put(239, "&iuml;");
            htmlEntities.put(240, "&eth;");
            htmlEntities.put(241, "&ntilde;");
            htmlEntities.put(242, "&ograve;");
            htmlEntities.put(243, "&oacute;");
            htmlEntities.put(244, "&ocirc;");
            htmlEntities.put(245, "&otilde;");
            htmlEntities.put(246, "&ouml;");
            htmlEntities.put(248, "&oslash;");
            htmlEntities.put(249, "&ugrave;");
            htmlEntities.put(250, "&uacute;");
            htmlEntities.put(251, "&ucirc;");
            htmlEntities.put(252, "&uuml;");
            htmlEntities.put(253, "&yacute;");
            htmlEntities.put(254, "&thorn;");
            htmlEntities.put(255, "&yuml;");
            htmlEntities.put(8364, "&euro;");
        }
    }

    public void transform(Object value) {
        String val = value.toString();
        this.getContext().write("\"");
        for (int i = 0; i < val.length(); ++i) {
            char intVal = val.charAt(i);
            if (htmlEntities.containsKey(intVal)) {
                this.getContext().write(htmlEntities.get(intVal));
                continue;
            }
            if (intVal > '\u0080') {
                this.getContext().write("&#");
                this.getContext().write(String.valueOf((int)intVal));
                this.getContext().write(";");
                continue;
            }
            this.getContext().write(String.valueOf(val.charAt(i)));
        }
        this.getContext().write("\"");
    }
}

