/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.packager.dependencies;

import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import pt.webdetails.cpf.packager.dependencies.CSSMin;
import pt.webdetails.cpf.packager.dependencies.Part;

class Property
implements Comparable<Property> {
    protected String property;
    protected Part[] parts;

    public Property(String property) throws Exception {
        try {
            ArrayList<String> parts = new ArrayList<String>();
            boolean bCanSplit = true;
            int j = 0;
            if (CSSMin.bDebug) {
                System.err.println("Examining property: " + property);
            }
            for (int i = 0; i < property.length(); ++i) {
                if (!bCanSplit) {
                    bCanSplit = property.charAt(i) == '\"';
                    continue;
                }
                if (property.charAt(i) == '\"') {
                    bCanSplit = false;
                    continue;
                }
                if (property.charAt(i) != ':') continue;
                parts.add(property.substring(j, i));
                j = i + 1;
            }
            parts.add(property.substring(j, property.length()));
            if (parts.size() < 2) {
                throw new Exception("Warning: Incomplete property: " + property);
            }
            this.property = ((String)parts.get(0)).trim().toLowerCase();
            this.parts = this.parseValues(((String)parts.get(1)).trim().replaceAll(", ", ","));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.property).append(":");
        for (Part p : this.parts) {
            sb.append(p.toString()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(";");
        return sb.toString();
    }

    @Override
    public int compareTo(Property other) {
        return this.property.compareTo(other.property);
    }

    private Part[] parseValues(String contents) {
        String[] parts = contents.split(",");
        Part[] results = new Part[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                results[i] = new Part(parts[i]);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                results[i] = null;
            }
        }
        return results;
    }
}

