/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.localization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class MessageBundlesHelper {
    public static final String BASE_CACHE_DIR = "tmp/.cache";
    public static final String BASE_MESSAGES_FILENAME = "messages";
    public static final String MESSAGES_EXTENSION = ".properties";
    public static final boolean OVERRIDE_PROPERTIES_IN_CACHE_DIR_IF_EXIST = false;
    public static final String LANGUAGE_COUNTRY_SEPARATOR = "-";
    public static final String LANGUAGE_COUNTRY_SEPARATOR_UNIX = "_";
    public final String REGEXP = "messages_[a-z][a-z](-[A-Z][A-Z]){0,1}.properties";
    public final String REGEXP_ALT = "messages_[a-z][a-z](_[A-Z][A-Z]){0,1}.properties";
    private static final Log logger = LogFactory.getLog(MessageBundlesHelper.class);
    Locale locale;
    String dashboardFolderPath;
    IReadAccess dashboardAccess;
    IRWAccess pluginAccess;
    String pluginStaticBaseContentUrl;

    public MessageBundlesHelper(String dashboardFolderPath, IReadAccess dashboardAccess, IRWAccess pluginAccess, Locale locale, String pluginStaticBaseContentUrl) throws IllegalArgumentException, IOException {
        if (dashboardAccess == null) {
            throw new IllegalArgumentException("dashboardAccess is null");
        }
        if (pluginAccess == null) {
            throw new IllegalArgumentException("pluginAccess is null");
        }
        if (locale == null || StringUtils.isEmpty((String)locale.getLanguage())) {
            throw new IllegalArgumentException("locale language is null");
        }
        if (StringUtils.isEmpty((String)pluginStaticBaseContentUrl)) {
            throw new IllegalArgumentException("pluginStaticBaseContentUrl is null");
        }
        this.setDashboardFolderPath(StringUtils.isEmpty((String)dashboardFolderPath) ? Util.SEPARATOR : dashboardFolderPath);
        this.setDashboardAccess(dashboardAccess);
        this.setPluginAccess(pluginAccess);
        this.setPluginStaticBaseContentUrl(pluginStaticBaseContentUrl);
        this.setLocale(locale);
        this.init();
    }

    protected void init() throws IOException {
        boolean success = this.createCacheDirIfNotExists();
        if (success) {
            this.saveI18NMessageFilesToCacheDir();
        }
    }

    protected boolean createCacheDirIfNotExists() {
        if (!this.getPluginAccess().fileExists(this.getBaseTempCacheFolder())) {
            logger.info((Object)("Attempting to create base base cache dir at " + this.getBaseTempCacheFolder()));
            if (this.getPluginAccess().createFolder(this.getBaseTempCacheFolder(), false)) {
                logger.info((Object)"Base cache dir created successfully");
            } else {
                logger.error((Object)("Unable to create base cache dir at " + this.getBaseTempCacheFolder()));
                return false;
            }
        }
        return true;
    }

    protected void saveI18NMessageFilesToCacheDir() throws IOException {
        this.saveBaseMessageToCacheDir(false);
        List<IBasicFile> localizedPropertiesFiles = this.getDashboardAccess().listFiles(this.getDashboardFolderPath(), new LocalizedMessageFilter(), 1, false, true);
        localizedPropertiesFiles = this.filterOutMessagesAlreadySavedInCacheDir(localizedPropertiesFiles);
        if (localizedPropertiesFiles != null) {
            for (IBasicFile localizedPropertyFile : localizedPropertiesFiles) {
                String fileInCacheDirPath = Util.joinPath(this.getBaseTempCacheFolder(), this.sanitize(localizedPropertyFile.getName()));
                try {
                    this.getPluginAccess().saveFile(fileInCacheDirPath, localizedPropertyFile.getContents());
                }
                catch (IOException e) {
                    logger.error((Object)("Unable to save " + localizedPropertyFile.getName() + " in " + this.getBaseTempCacheFolder()), (Throwable)e);
                }
            }
        }
        String localizedMsgPath = Util.joinPath(this.getBaseTempCacheFolder(), "messages_" + this.getLocale().getLanguage() + MESSAGES_EXTENSION);
        String localizedCountryMsgPath = Util.joinPath(this.getBaseTempCacheFolder(), "messages_" + this.getLocale().getLanguage() + LANGUAGE_COUNTRY_SEPARATOR + this.getLocale().getCountry() + MESSAGES_EXTENSION);
        if (!this.getPluginAccess().fileExists(localizedMsgPath)) {
            this.getPluginAccess().saveFile(localizedMsgPath, new ByteArrayInputStream(new String().getBytes()));
        }
        if (!this.getPluginAccess().fileExists(localizedCountryMsgPath)) {
            this.getPluginAccess().saveFile(localizedCountryMsgPath, new ByteArrayInputStream(new String().getBytes()));
        }
    }

    protected boolean saveBaseMessageToCacheDir(boolean overrideIfExists) throws IOException {
        String baseMsgPath = Util.joinPath(this.getDashboardFolderPath(), "messages.properties");
        IBasicFile basePropertiesFile = null;
        String basePropertiesCachePath = Util.joinPath(this.getBaseTempCacheFolder(), "messages.properties");
        if (this.getDashboardAccess().fileExists(baseMsgPath)) {
            basePropertiesFile = this.getDashboardAccess().fetchFile(baseMsgPath);
            if (!this.getPluginAccess().fileExists(basePropertiesCachePath) || overrideIfExists) {
                this.getPluginAccess().saveFile(basePropertiesCachePath, basePropertiesFile.getContents());
            }
        }
        if (!this.getPluginAccess().fileExists(basePropertiesCachePath)) {
            this.getPluginAccess().saveFile(basePropertiesCachePath, new ByteArrayInputStream(new byte[0]));
        }
        return true;
    }

    protected List<IBasicFile> filterOutMessagesAlreadySavedInCacheDir(List<IBasicFile> localizedMessages) {
        ArrayList<IBasicFile> filteredLocalizedMessages = new ArrayList<IBasicFile>();
        if (localizedMessages != null) {
            for (IBasicFile message : localizedMessages) {
                if (this.getPluginAccess().fileExists(Util.joinPath(this.getBaseTempCacheFolder(), this.sanitize(message.getName())))) continue;
                filteredLocalizedMessages.add(message);
            }
        }
        return filteredLocalizedMessages;
    }

    public String getMessageFilesCacheUrl() {
        return FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)Util.joinPath(this.getPluginStaticBaseContentUrl(), BASE_CACHE_DIR, this.getDashboardFolderPath(), Util.SEPARATOR)));
    }

    public String replaceParameters(String text, ArrayList<String> i18nTagsList) throws IOException {
        if (i18nTagsList == null) {
            i18nTagsList = new ArrayList();
        }
        String languageCode = this.getLocale().getLanguage() + LANGUAGE_COUNTRY_SEPARATOR + this.getLocale().getCountry();
        text = text.replaceAll("\\{load\\}", "onload=\"load()\"");
        text = text.replaceAll("\\{body-tag-unload\\}", "");
        text = text.replaceAll("#\\{GLOBAL_MESSAGE_SET_NAME\\}", BASE_MESSAGES_FILENAME);
        text = text.replaceAll("#\\{GLOBAL_MESSAGE_SET_PATH\\}", this.getMessageFilesCacheUrl());
        text = text.replaceAll("#\\{GLOBAL_MESSAGE_SET\\}", this.buildMessageSetCode(i18nTagsList));
        text = text.replaceAll("#\\{LANGUAGE_CODE\\}", languageCode);
        return text;
    }

    public IReadAccess getDashboardAccess() {
        return this.dashboardAccess;
    }

    public void setDashboardAccess(IReadAccess dashboardAccess) {
        this.dashboardAccess = dashboardAccess;
    }

    public IRWAccess getPluginAccess() {
        return this.pluginAccess;
    }

    public void setPluginAccess(IRWAccess pluginAccess) {
        this.pluginAccess = pluginAccess;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getPluginStaticBaseContentUrl() {
        return this.pluginStaticBaseContentUrl;
    }

    public void setPluginStaticBaseContentUrl(String pluginStaticBaseContentUrl) {
        this.pluginStaticBaseContentUrl = pluginStaticBaseContentUrl;
    }

    public String getDashboardFolderPath() {
        return this.dashboardFolderPath;
    }

    public void setDashboardFolderPath(String dashboardFolderPath) {
        this.dashboardFolderPath = dashboardFolderPath;
    }

    public String getBaseTempCacheFolder() {
        return Util.joinPath(BASE_CACHE_DIR, this.getDashboardFolderPath());
    }

    public String sanitize(String name) {
        String REGEX_SEPARATOR_UNIX = "messages_[a-z][a-z](_[A-Z][A-Z]).properties";
        if (!StringUtils.isEmpty((String)name) && name.matches("messages_[a-z][a-z](_[A-Z][A-Z]).properties")) {
            int idx = name.lastIndexOf(LANGUAGE_COUNTRY_SEPARATOR_UNIX);
            StringBuffer sb = new StringBuffer(name.substring(0, idx));
            sb.append(LANGUAGE_COUNTRY_SEPARATOR);
            sb.append(name.substring(idx + LANGUAGE_COUNTRY_SEPARATOR_UNIX.length()));
            return sb.toString();
        }
        return name;
    }

    private String buildMessageSetCode(ArrayList<String> tagsList) {
        StringBuffer messageCodeSet = new StringBuffer();
        for (String tag : tagsList) {
            messageCodeSet.append("\\$('#").append(this.updateSelectorName(tag)).append("').html(jQuery.i18n.prop('").append(tag).append("'));\n");
        }
        return messageCodeSet.toString();
    }

    private String updateSelectorName(String name) {
        return name.replace(".", LANGUAGE_COUNTRY_SEPARATOR_UNIX);
    }

    class LocalizedMessageFilter
    implements IBasicFileFilter {
        LocalizedMessageFilter() {
        }

        @Override
        public boolean accept(IBasicFile file) {
            return file != null && !StringUtils.isEmpty((String)file.getName()) && (file.getName().matches("messages_[a-z][a-z](-[A-Z][A-Z]){0,1}.properties") || file.getName().matches("messages_[a-z][a-z](_[A-Z][A-Z]){0,1}.properties"));
        }
    }
}

