/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.util.RepositoryHelper;
import pt.webdetails.cpf.utils.CharsetHelper;

public abstract class Util {
    private static Log logger = LogFactory.getLog(Util.class);
    public static final DecimalFormat DEFAULT_DURATION_FORMAT_SEC = new DecimalFormat("0.00s");
    public static final String SEPARATOR = String.valueOf('/');

    public static String toString(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        try {
            String string = IOUtils.toString((InputStream)input, (String)CharsetHelper.getEncoding());
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, CharsetHelper.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            Util.logNoEncoding();
            return new String(bytes);
        }
    }

    public static String getExceptionDescription(Exception e) {
        StringBuilder out = new StringBuilder();
        out.append("[ ").append(e.getClass().getName()).append(" ] - ");
        out.append(e.getMessage());
        if (e.getCause() != null) {
            out.append(" .( Cause [ ").append(e.getCause().getClass().getName()).append(" ] ");
            out.append(e.getCause().getMessage());
        }
        return out.toString();
    }

    public static String getContentsBetween(String source, String begin, String end) {
        if (source == null) {
            return null;
        }
        int startIdx = source.indexOf(begin) + begin.length();
        int endIdx = source.lastIndexOf(end);
        if (startIdx < 0 || endIdx < 0) {
            return null;
        }
        return source.substring(startIdx, endIdx);
    }

    public static String joinPath(String ... paths) {
        LinkedList<String> normalizedPaths = new LinkedList<String>();
        for (String path : paths) {
            normalizedPaths.add(FilenameUtils.separatorsToUnix((String)path));
        }
        return RepositoryHelper.joinPaths(normalizedPaths);
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String byteValue = Integer.toHexString(0xFF & bytes[i]);
            hexString.append(byteValue.length() == 2 ? byteValue : "0" + byteValue);
        }
        return hexString.toString();
    }

    public static InputStream toInputStream(String contents) {
        try {
            return new ByteArrayInputStream(contents.getBytes(CharsetHelper.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            Util.logNoEncoding();
            return null;
        }
    }

    public static InputStream joinStreams(InputStream ... streams) {
        return new SequenceInputStream(Util.toEnumeration(streams));
    }

    public static String getMd5Digest(String contents) throws IOException {
        return Util.getMd5Digest(Util.toInputStream(contents));
    }

    public static String getMd5Digest(InputStream input) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DigestInputStream digestStream = new DigestInputStream(input, digest);
            IOUtils.copy((InputStream)digestStream, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            return Util.bytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            logger.fatal((Object)"No MD5!", (Throwable)e);
            return null;
        }
    }

    public static boolean appendToFile(IRWAccess access, String filePath, InputStream toAppend) throws IOException {
        if (!access.fileExists(filePath)) {
            return false;
        }
        String fileContents = Util.toString(access.getFileInputStream(filePath));
        return access.saveFile(filePath, Util.joinStreams(Util.toInputStream(fileContents), toAppend));
    }

    public static String urlEncode(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, CharsetHelper.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            Util.logNoEncoding();
            return null;
        }
    }

    public static String normalizeUri(String path) {
        try {
            URI uri = new URI(path);
            return uri.normalize().getPath();
        }
        catch (URISyntaxException e) {
            logger.error((Object)("normalizeUri: cannot process path " + path), (Throwable)e);
            return path;
        }
    }

    public static <T> Enumeration<T> toEnumeration(final T[] array) {
        return new Enumeration<T>(){
            int idx = 0;

            @Override
            public boolean hasMoreElements() {
                return this.idx < array.length;
            }

            @Override
            public T nextElement() {
                return array[this.idx++];
            }
        };
    }

    public static <T> Iterable<T> toIterable(final T[] array) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.idx < array.length;
                    }

                    @Override
                    public T next() {
                        return array[this.idx++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static void logNoEncoding() {
        logger.fatal((Object)("Encoding " + CharsetHelper.getEncoding() + " not supported!!"));
    }

    public static String getElapsedSeconds(long startTime) {
        return DEFAULT_DURATION_FORMAT_SEC.format((double)(System.currentTimeMillis() - startTime) / 1000.0);
    }

    public static IReadAccess getAppropriateReadAccess(String resourcePath, IContentAccessFactory factory, String pluginId, String pluginSystemDir, String pluginRepoDir) {
        if (StringUtils.isEmpty((String)resourcePath) || StringUtils.isEmpty((String)pluginId) || StringUtils.isEmpty((String)pluginSystemDir) || StringUtils.isEmpty((String)pluginRepoDir) || factory == null) {
            return null;
        }
        String id = pluginId.endsWith(SEPARATOR) ? pluginId : pluginId + SEPARATOR;
        String repoDir = pluginRepoDir.endsWith(SEPARATOR) ? pluginRepoDir : pluginRepoDir + SEPARATOR;
        String systemDir = pluginSystemDir.endsWith(SEPARATOR) ? pluginSystemDir : pluginSystemDir + SEPARATOR;
        String resource = StringUtils.strip((String)resourcePath, (String)SEPARATOR);
        if (resource.regionMatches(true, 0, systemDir, 0, systemDir.length())) {
            if ((resource = resource.replaceFirst(systemDir, "")).regionMatches(true, 0, id, 0, id.length())) {
                return factory.getPluginSystemReader(null);
            }
            String otherPluginId = resource.substring(0, resource.indexOf(SEPARATOR));
            return factory.getOtherPluginSystemReader(otherPluginId, null);
        }
        if (resource.regionMatches(true, 0, repoDir, 0, repoDir.length())) {
            return factory.getPluginRepositoryReader(null);
        }
        if (factory.getPluginSystemReader(null).fileExists(resourcePath)) {
            return factory.getPluginSystemReader(null);
        }
        if (factory.getUserContentAccess(null).fileExists(resourcePath)) {
            return factory.getUserContentAccess(null);
        }
        return null;
    }
}

