/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.caching.api;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.caching.api.PentahoCacheManager;
import org.pentaho.caching.api.PentahoCacheTemplateConfiguration;

public class PentahoCacheSystemConfiguration {
    private static final Pattern GLOBAL_PATTERN = Pattern.compile("global[.]([\\w_-]+)");
    private static final int GLOBAL_PROP_GROUP = 1;
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("template[.]([\\w_-]+)([.]([\\w_-]+))?");
    private static final int TEMPLATE_NAME_GROUP = 1;
    private static final int TEMPLATE_PROP_GROUP = 3;
    private volatile ImmutableMap<String, String> configuration = ImmutableMap.of();
    private volatile ImmutableMap<String, String> global = ImmutableMap.of();
    private volatile ImmutableMap<String, Template> templateMap = ImmutableMap.of();

    public void setData(Map<String, String> config) {
        HashMap global = Maps.newHashMap();
        HashMap templateMap = Maps.newHashMap();
        Template defaultTemplate = new Template();
        templateMap.put("default", defaultTemplate);
        defaultTemplate.description = "Default Cache Template";
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Matcher matcher = GLOBAL_PATTERN.matcher(key);
            if (matcher.matches()) {
                global.put(matcher.group(1), value);
                continue;
            }
            matcher = TEMPLATE_PATTERN.matcher(key);
            if (!matcher.matches()) continue;
            String templateName = matcher.group(1);
            String propName = matcher.group(3);
            if (!templateMap.containsKey(templateName)) {
                templateMap.put(templateName, new Template());
            }
            Template template = (Template)templateMap.get(templateName);
            if (Strings.isNullOrEmpty((String)propName)) {
                template.description = value;
                continue;
            }
            template.properties.put(propName, value);
        }
        Iterator iterator = templateMap.values().iterator();
        while (iterator.hasNext()) {
            Template template = (Template)iterator.next();
            if (Strings.isNullOrEmpty((String)template.description)) {
                iterator.remove();
                continue;
            }
            HashMap properties = Maps.newHashMap();
            properties.putAll(global);
            properties.putAll(template.properties);
            template.properties = properties;
        }
        this.configuration = ImmutableMap.copyOf(config);
        this.global = ImmutableMap.copyOf((Map)global);
        this.templateMap = ImmutableMap.copyOf((Map)templateMap);
    }

    public Map<String, PentahoCacheTemplateConfiguration> createTemplates(PentahoCacheManager cacheManager) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.templateMap.entrySet()) {
            Template template = (Template)entry.getValue();
            PentahoCacheTemplateConfiguration templateConfiguration = new PentahoCacheTemplateConfiguration(template.description, template.properties, cacheManager);
            builder.put(entry.getKey(), (Object)templateConfiguration);
        }
        return builder.build();
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public Map<String, String> getGlobalProperties() {
        return this.global;
    }

    private class Template {
        private Map<String, String> properties = Maps.newHashMap();
        private String description;
    }
}

