/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.feed4j.html;

import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HTMLEntities {
    private static Hashtable entities = new Hashtable();
    private static Hashtable reversedEntities = new Hashtable();
    private static Pattern pattern = Pattern.compile("&(#?[a-zA-Z0-9]+);");

    static {
        entities.put("nbsp", " ");
        entities.put("iexcl", "\u00a1");
        entities.put("cent", "\u00a2");
        entities.put("pound", "\u00a3");
        entities.put("curren", "\u00a4");
        entities.put("yen", "\u00a5");
        entities.put("brvbar", "\u00a6");
        entities.put("sect", "\u00a7");
        entities.put("uml", "\u00a8");
        entities.put("copy", "\u00a9");
        entities.put("ordf", "\u00aa");
        entities.put("laquo", "\u00ab");
        entities.put("not", "\u00ac");
        entities.put("shy", "\u00ad");
        entities.put("reg", "\u00ae");
        entities.put("macr", "\u00af");
        entities.put("deg", "\u00b0");
        entities.put("plusmn", "\u00b1");
        entities.put("sup2", "\u00b2");
        entities.put("sup3", "\u00b3");
        entities.put("acute", "\u00b4");
        entities.put("micro", "\u00b5");
        entities.put("para", "\u00b6");
        entities.put("middot", "\u00b7");
        entities.put("cedil", "\u00b8");
        entities.put("sup1", "\u00b9");
        entities.put("ordm", "\u00ba");
        entities.put("raquo", "\u00bb");
        entities.put("frac14", "\u00bc");
        entities.put("frac12", "\u00bd");
        entities.put("frac34", "\u00be");
        entities.put("iquest", "\u00bf");
        entities.put("Agrave", "\u00c0");
        entities.put("Aacute", "\u00c1");
        entities.put("Acirc", "\u00c2");
        entities.put("Atilde", "\u00c3");
        entities.put("Auml", "\u00c4");
        entities.put("Aring", "\u00c5");
        entities.put("AElig", "\u00c6");
        entities.put("Ccedil", "\u00c7");
        entities.put("Egrave", "\u00c8");
        entities.put("Eacute", "\u00c9");
        entities.put("Ecirc", "\u00ca");
        entities.put("Euml", "\u00cb");
        entities.put("Igrave", "\u00cc");
        entities.put("Iacute", "\u00cd");
        entities.put("Icirc", "\u00ce");
        entities.put("Iuml", "\u00cf");
        entities.put("ETH", "\u00d0");
        entities.put("Ntilde", "\u00d1");
        entities.put("Ograve", "\u00d2");
        entities.put("Oacute", "\u00d3");
        entities.put("Ocirc", "\u00d4");
        entities.put("Otilde", "\u00d5");
        entities.put("Ouml", "\u00d6");
        entities.put("times", "\u00d7");
        entities.put("Oslash", "\u00d8");
        entities.put("Ugrave", "\u00d9");
        entities.put("Uacute", "\u00da");
        entities.put("Ucirc", "\u00db");
        entities.put("Uuml", "\u00dc");
        entities.put("Yacute", "\u00dd");
        entities.put("THORN", "\u00de");
        entities.put("szlig", "\u00df");
        entities.put("agrave", "\u00e0");
        entities.put("aacute", "\u00e1");
        entities.put("acirc", "\u00e2");
        entities.put("atilde", "\u00e3");
        entities.put("auml", "\u00e4");
        entities.put("aring", "\u00e5");
        entities.put("aelig", "\u00e6");
        entities.put("ccedil", "\u00e7");
        entities.put("egrave", "\u00e8");
        entities.put("eacute", "\u00e9");
        entities.put("ecirc", "\u00ea");
        entities.put("euml", "\u00eb");
        entities.put("igrave", "\u00ec");
        entities.put("iacute", "\u00ed");
        entities.put("icirc", "\u00ee");
        entities.put("iuml", "\u00ef");
        entities.put("eth", "\u00f0");
        entities.put("ntilde", "\u00f1");
        entities.put("ograve", "\u00f2");
        entities.put("oacute", "\u00f3");
        entities.put("ocirc", "\u00f4");
        entities.put("otilde", "\u00f5");
        entities.put("ouml", "\u00f6");
        entities.put("divide", "\u00f7");
        entities.put("oslash", "\u00f8");
        entities.put("ugrave", "\u00f9");
        entities.put("uacute", "\u00fa");
        entities.put("ucirc", "\u00fb");
        entities.put("uuml", "\u00fc");
        entities.put("yacute", "\u00fd");
        entities.put("thorn", "\u00fe");
        entities.put("yuml", "\u00ff");
        entities.put("quot", "\"");
        entities.put("amp", "&");
        entities.put("apos", "'");
        entities.put("lt", "<");
        entities.put("gt", ">");
        entities.put("OElig", "\u0152");
        entities.put("oelig", "\u0153");
        entities.put("Scaron", "\u0160");
        entities.put("scaron", "\u0161");
        entities.put("Yuml", "\u0178");
        entities.put("circ", "\u02c6");
        entities.put("tilde", "\u02dc");
        entities.put("ensp", "\u2002");
        entities.put("emsp", "\u2003");
        entities.put("thinsp", "\u2009");
        entities.put("zwnj", "\u200c");
        entities.put("zwj", "\u200d");
        entities.put("lrm", "\u200e");
        entities.put("rlm", "\u200f");
        entities.put("ndash", "\u2013");
        entities.put("mdash", "\u2014");
        entities.put("lsquo", "\u2018");
        entities.put("rsquo", "\u2019");
        entities.put("sbquo", "\u201a");
        entities.put("ldquo", "\u201c");
        entities.put("rdquo", "\u201d");
        entities.put("bdquo", "\u201e");
        entities.put("dagger", "\u2020");
        entities.put("Dagger", "\u2021");
        entities.put("permil", "\u2030");
        entities.put("lsaquo", "\u2039");
        entities.put("rsaquo", "\u203a");
        entities.put("euro", "\u20ac");
        entities.put("fnof", "\u0192");
        entities.put("Alpha", "\u0391");
        entities.put("Beta", "\u0392");
        entities.put("Gamma", "\u0393");
        entities.put("Delta", "\u0394");
        entities.put("Epsilon", "\u0395");
        entities.put("Zeta", "\u0396");
        entities.put("Eta", "\u0397");
        entities.put("Theta", "\u0398");
        entities.put("Iota", "\u0399");
        entities.put("Kappa", "\u039a");
        entities.put("Lambda", "\u039b");
        entities.put("Mu", "\u039c");
        entities.put("Nu", "\u039d");
        entities.put("Xi", "\u039e");
        entities.put("Omicron", "\u039f");
        entities.put("Pi", "\u03a0");
        entities.put("Rho", "\u03a1");
        entities.put("Sigma", "\u03a3");
        entities.put("Tau", "\u03a4");
        entities.put("Upsilon", "\u03a5");
        entities.put("Phi", "\u03a6");
        entities.put("Chi", "\u03a7");
        entities.put("Psi", "\u03a8");
        entities.put("Omega", "\u03a9");
        entities.put("alpha", "\u03b1");
        entities.put("beta", "\u03b2");
        entities.put("gamma", "\u03b3");
        entities.put("delta", "\u03b4");
        entities.put("epsilon", "\u03b5");
        entities.put("zeta", "\u03b6");
        entities.put("eta", "\u03b7");
        entities.put("theta", "\u03b8");
        entities.put("iota", "\u03b9");
        entities.put("kappa", "\u03ba");
        entities.put("lambda", "\u03bb");
        entities.put("mu", "\u03bc");
        entities.put("nu", "\u03bd");
        entities.put("xi", "\u03be");
        entities.put("omicron", "\u03bf");
        entities.put("pi", "\u03c0");
        entities.put("rho", "\u03c1");
        entities.put("sigmaf", "\u03c2");
        entities.put("sigma", "\u03c3");
        entities.put("tau", "\u03c4");
        entities.put("upsilon", "\u03c5");
        entities.put("phi", "\u03c6");
        entities.put("chi", "\u03c7");
        entities.put("psi", "\u03c8");
        entities.put("omega", "\u03c9");
        entities.put("thetasym", "\u03d1");
        entities.put("upsih", "\u03d2");
        entities.put("piv", "\u03d6");
        entities.put("bull", "\u2022");
        entities.put("hellip", "\u2026");
        entities.put("prime", "\u2032");
        entities.put("Prime", "\u2033");
        entities.put("oline", "\u203e");
        entities.put("frasl", "\u2044");
        entities.put("weierp", "\u2118");
        entities.put("image", "\u2111");
        entities.put("real", "\u211c");
        entities.put("trade", "\u2122");
        entities.put("alefsym", "\u2135");
        entities.put("larr", "\u2190");
        entities.put("uarr", "\u2191");
        entities.put("rarr", "\u2192");
        entities.put("darr", "\u2193");
        entities.put("harr", "\u2194");
        entities.put("crarr", "\u21b5");
        entities.put("lArr", "\u21d0");
        entities.put("uArr", "\u21d1");
        entities.put("rArr", "\u21d2");
        entities.put("dArr", "\u21d3");
        entities.put("hArr", "\u21d4");
        entities.put("forall", "\u2200");
        entities.put("part", "\u2202");
        entities.put("exist", "\u2203");
        entities.put("empty", "\u2205");
        entities.put("nabla", "\u2207");
        entities.put("isin", "\u2208");
        entities.put("notin", "\u2209");
        entities.put("ni", "\u220b");
        entities.put("prod", "\u220f");
        entities.put("sum", "\u2211");
        entities.put("minus", "\u2212");
        entities.put("lowast", "\u2217");
        entities.put("radic", "\u221a");
        entities.put("prop", "\u221d");
        entities.put("infin", "\u221e");
        entities.put("ang", "\u2220");
        entities.put("and", "\u2227");
        entities.put("or", "\u2228");
        entities.put("cap", "\u2229");
        entities.put("cup", "\u222a");
        entities.put("int", "\u222b");
        entities.put("there4", "\u2234");
        entities.put("sim", "\u223c");
        entities.put("cong", "\u2245");
        entities.put("asymp", "\u2248");
        entities.put("ne", "\u2260");
        entities.put("equiv", "\u2261");
        entities.put("le", "\u2264");
        entities.put("ge", "\u2265");
        entities.put("sub", "\u2282");
        entities.put("sup", "\u2283");
        entities.put("nsub", "\u2284");
        entities.put("sube", "\u2286");
        entities.put("supe", "\u2287");
        entities.put("oplus", "\u2295");
        entities.put("otimes", "\u2297");
        entities.put("perp", "\u22a5");
        entities.put("sdot", "\u22c5");
        entities.put("lceil", "\u2308");
        entities.put("rceil", "\u2309");
        entities.put("lfloor", "\u230a");
        entities.put("rfloor", "\u230b");
        entities.put("lang", "\u2329");
        entities.put("rang", "\u232a");
        entities.put("loz", "\u25ca");
        entities.put("spades", "\u2660");
        entities.put("clubs", "\u2663");
        entities.put("hearts", "\u2665");
        entities.put("diams", "\u2666");
        reversedEntities.put("\u00a0", "nbsp");
        reversedEntities.put("\u00a1", "iexcl");
        reversedEntities.put("\u00a2", "cent");
        reversedEntities.put("\u00a3", "pound");
        reversedEntities.put("\u00a4", "curren");
        reversedEntities.put("\u00a5", "yen");
        reversedEntities.put("\u00a6", "brvbar");
        reversedEntities.put("\u00a7", "sect");
        reversedEntities.put("\u00a8", "uml");
        reversedEntities.put("\u00a9", "copy");
        reversedEntities.put("\u00aa", "ordf");
        reversedEntities.put("\u00ab", "laquo");
        reversedEntities.put("\u00ac", "not");
        reversedEntities.put("\u00ad", "shy");
        reversedEntities.put("\u00ae", "reg");
        reversedEntities.put("\u00af", "macr");
        reversedEntities.put("\u00b0", "deg");
        reversedEntities.put("\u00b1", "plusmn");
        reversedEntities.put("\u00b2", "sup2");
        reversedEntities.put("\u00b3", "sup3");
        reversedEntities.put("\u00b4", "acute");
        reversedEntities.put("\u00b5", "micro");
        reversedEntities.put("\u00b6", "para");
        reversedEntities.put("\u00b7", "middot");
        reversedEntities.put("\u00b8", "cedil");
        reversedEntities.put("\u00b9", "sup1");
        reversedEntities.put("\u00ba", "ordm");
        reversedEntities.put("\u00bb", "raquo");
        reversedEntities.put("\u00bc", "frac14");
        reversedEntities.put("\u00bd", "frac12");
        reversedEntities.put("\u00be", "frac34");
        reversedEntities.put("\u00bf", "iquest");
        reversedEntities.put("\u00c0", "Agrave");
        reversedEntities.put("\u00c1", "Aacute");
        reversedEntities.put("\u00c2", "Acirc");
        reversedEntities.put("\u00c3", "Atilde");
        reversedEntities.put("\u00c4", "Auml");
        reversedEntities.put("\u00c5", "Aring");
        reversedEntities.put("\u00c6", "AElig");
        reversedEntities.put("\u00c7", "Ccedil");
        reversedEntities.put("\u00c8", "Egrave");
        reversedEntities.put("\u00c9", "Eacute");
        reversedEntities.put("\u00ca", "Ecirc");
        reversedEntities.put("\u00cb", "Euml");
        reversedEntities.put("\u00cc", "Igrave");
        reversedEntities.put("\u00cd", "Iacute");
        reversedEntities.put("\u00ce", "Icirc");
        reversedEntities.put("\u00cf", "Iuml");
        reversedEntities.put("\u00d0", "ETH");
        reversedEntities.put("\u00d1", "Ntilde");
        reversedEntities.put("\u00d2", "Ograve");
        reversedEntities.put("\u00d3", "Oacute");
        reversedEntities.put("\u00d4", "Ocirc");
        reversedEntities.put("\u00d5", "Otilde");
        reversedEntities.put("\u00d6", "Ouml");
        reversedEntities.put("\u00d7", "times");
        reversedEntities.put("\u00d8", "Oslash");
        reversedEntities.put("\u00d9", "Ugrave");
        reversedEntities.put("\u00da", "Uacute");
        reversedEntities.put("\u00db", "Ucirc");
        reversedEntities.put("\u00dc", "Uuml");
        reversedEntities.put("\u00dd", "Yacute");
        reversedEntities.put("\u00de", "THORN");
        reversedEntities.put("\u00df", "szlig");
        reversedEntities.put("\u00e0", "agrave");
        reversedEntities.put("\u00e1", "aacute");
        reversedEntities.put("\u00e2", "acirc");
        reversedEntities.put("\u00e3", "atilde");
        reversedEntities.put("\u00e4", "auml");
        reversedEntities.put("\u00e5", "aring");
        reversedEntities.put("\u00e6", "aelig");
        reversedEntities.put("\u00e7", "ccedil");
        reversedEntities.put("\u00e8", "egrave");
        reversedEntities.put("\u00e9", "eacute");
        reversedEntities.put("\u00ea", "ecirc");
        reversedEntities.put("\u00eb", "euml");
        reversedEntities.put("\u00ec", "igrave");
        reversedEntities.put("\u00ed", "iacute");
        reversedEntities.put("\u00ee", "icirc");
        reversedEntities.put("\u00ef", "iuml");
        reversedEntities.put("\u00f0", "eth");
        reversedEntities.put("\u00f1", "ntilde");
        reversedEntities.put("\u00f2", "ograve");
        reversedEntities.put("\u00f3", "oacute");
        reversedEntities.put("\u00f4", "ocirc");
        reversedEntities.put("\u00f5", "otilde");
        reversedEntities.put("\u00f6", "ouml");
        reversedEntities.put("\u00f7", "divide");
        reversedEntities.put("\u00f8", "oslash");
        reversedEntities.put("\u00f9", "ugrave");
        reversedEntities.put("\u00fa", "uacute");
        reversedEntities.put("\u00fb", "ucirc");
        reversedEntities.put("\u00fc", "uuml");
        reversedEntities.put("\u00fd", "yacute");
        reversedEntities.put("\u00fe", "thorn");
        reversedEntities.put("\u00ff", "yuml");
        reversedEntities.put("\"", "quot");
        reversedEntities.put("&", "amp");
        reversedEntities.put("<", "lt");
        reversedEntities.put(">", "gt");
        reversedEntities.put("\u0152", "OElig");
        reversedEntities.put("\u0153", "oelig");
        reversedEntities.put("\u0160", "Scaron");
        reversedEntities.put("\u0161", "scaron");
        reversedEntities.put("\u0178", "Yuml");
        reversedEntities.put("\u02c6", "circ");
        reversedEntities.put("\u02dc", "tilde");
        reversedEntities.put("\u2002", "ensp");
        reversedEntities.put("\u2003", "emsp");
        reversedEntities.put("\u2009", "thinsp");
        reversedEntities.put("\u200c", "zwnj");
        reversedEntities.put("\u200d", "zwj");
        reversedEntities.put("\u200e", "lrm");
        reversedEntities.put("\u200f", "rlm");
        reversedEntities.put("\u2013", "ndash");
        reversedEntities.put("\u2014", "mdash");
        reversedEntities.put("\u2018", "lsquo");
        reversedEntities.put("\u2019", "rsquo");
        reversedEntities.put("\u201a", "sbquo");
        reversedEntities.put("\u201c", "ldquo");
        reversedEntities.put("\u201d", "rdquo");
        reversedEntities.put("\u201e", "bdquo");
        reversedEntities.put("\u2020", "dagger");
        reversedEntities.put("\u2021", "Dagger");
        reversedEntities.put("\u2030", "permil");
        reversedEntities.put("\u2039", "lsaquo");
        reversedEntities.put("\u203a", "rsaquo");
        reversedEntities.put("\u20ac", "euro");
        reversedEntities.put("\u0192", "fnof");
        reversedEntities.put("\u0391", "Alpha");
        reversedEntities.put("\u0392", "Beta");
        reversedEntities.put("\u0393", "Gamma");
        reversedEntities.put("\u0394", "Delta");
        reversedEntities.put("\u0395", "Epsilon");
        reversedEntities.put("\u0396", "Zeta");
        reversedEntities.put("\u0397", "Eta");
        reversedEntities.put("\u0398", "Theta");
        reversedEntities.put("\u0399", "Iota");
        reversedEntities.put("\u039a", "Kappa");
        reversedEntities.put("\u039b", "Lambda");
        reversedEntities.put("\u039c", "Mu");
        reversedEntities.put("\u039d", "Nu");
        reversedEntities.put("\u039e", "Xi");
        reversedEntities.put("\u039f", "Omicron");
        reversedEntities.put("\u03a0", "Pi");
        reversedEntities.put("\u03a1", "Rho");
        reversedEntities.put("\u03a3", "Sigma");
        reversedEntities.put("\u03a4", "Tau");
        reversedEntities.put("\u03a5", "Upsilon");
        reversedEntities.put("\u03a6", "Phi");
        reversedEntities.put("\u03a7", "Chi");
        reversedEntities.put("\u03a8", "Psi");
        reversedEntities.put("\u03a9", "Omega");
        reversedEntities.put("\u03b1", "alpha");
        reversedEntities.put("\u03b2", "beta");
        reversedEntities.put("\u03b3", "gamma");
        reversedEntities.put("\u03b4", "delta");
        reversedEntities.put("\u03b5", "epsilon");
        reversedEntities.put("\u03b6", "zeta");
        reversedEntities.put("\u03b7", "eta");
        reversedEntities.put("\u03b8", "theta");
        reversedEntities.put("\u03b9", "iota");
        reversedEntities.put("\u03ba", "kappa");
        reversedEntities.put("\u03bb", "lambda");
        reversedEntities.put("\u03bc", "mu");
        reversedEntities.put("\u03bd", "nu");
        reversedEntities.put("\u03be", "xi");
        reversedEntities.put("\u03bf", "omicron");
        reversedEntities.put("\u03c0", "pi");
        reversedEntities.put("\u03c1", "rho");
        reversedEntities.put("\u03c2", "sigmaf");
        reversedEntities.put("\u03c3", "sigma");
        reversedEntities.put("\u03c4", "tau");
        reversedEntities.put("\u03c5", "upsilon");
        reversedEntities.put("\u03c6", "phi");
        reversedEntities.put("\u03c7", "chi");
        reversedEntities.put("\u03c8", "psi");
        reversedEntities.put("\u03c9", "omega");
        reversedEntities.put("\u03d1", "thetasym");
        reversedEntities.put("\u03d2", "upsih");
        reversedEntities.put("\u03d6", "piv");
        reversedEntities.put("\u2022", "bull");
        reversedEntities.put("\u2026", "hellip");
        reversedEntities.put("\u2032", "prime");
        reversedEntities.put("\u2033", "Prime");
        reversedEntities.put("\u203e", "oline");
        reversedEntities.put("\u2044", "frasl");
        reversedEntities.put("\u2118", "weierp");
        reversedEntities.put("\u2111", "image");
        reversedEntities.put("\u211c", "real");
        reversedEntities.put("\u2122", "trade");
        reversedEntities.put("\u2135", "alefsym");
        reversedEntities.put("\u2190", "larr");
        reversedEntities.put("\u2191", "uarr");
        reversedEntities.put("\u2192", "rarr");
        reversedEntities.put("\u2193", "darr");
        reversedEntities.put("\u2194", "harr");
        reversedEntities.put("\u21b5", "crarr");
        reversedEntities.put("\u21d0", "lArr");
        reversedEntities.put("\u21d1", "uArr");
        reversedEntities.put("\u21d2", "rArr");
        reversedEntities.put("\u21d3", "dArr");
        reversedEntities.put("\u21d4", "hArr");
        reversedEntities.put("\u2200", "forall");
        reversedEntities.put("\u2202", "part");
        reversedEntities.put("\u2203", "exist");
        reversedEntities.put("\u2205", "empty");
        reversedEntities.put("\u2207", "nabla");
        reversedEntities.put("\u2208", "isin");
        reversedEntities.put("\u2209", "notin");
        reversedEntities.put("\u220b", "ni");
        reversedEntities.put("\u220f", "prod");
        reversedEntities.put("\u2211", "sum");
        reversedEntities.put("\u2212", "minus");
        reversedEntities.put("\u2217", "lowast");
        reversedEntities.put("\u221a", "radic");
        reversedEntities.put("\u221d", "prop");
        reversedEntities.put("\u221e", "infin");
        reversedEntities.put("\u2220", "ang");
        reversedEntities.put("\u2227", "and");
        reversedEntities.put("\u2228", "or");
        reversedEntities.put("\u2229", "cap");
        reversedEntities.put("\u222a", "cup");
        reversedEntities.put("\u222b", "int");
        reversedEntities.put("\u2234", "there4");
        reversedEntities.put("\u223c", "sim");
        reversedEntities.put("\u2245", "cong");
        reversedEntities.put("\u2248", "asymp");
        reversedEntities.put("\u2260", "ne");
        reversedEntities.put("\u2261", "equiv");
        reversedEntities.put("\u2264", "le");
        reversedEntities.put("\u2265", "ge");
        reversedEntities.put("\u2282", "sub");
        reversedEntities.put("\u2283", "sup");
        reversedEntities.put("\u2284", "nsub");
        reversedEntities.put("\u2286", "sube");
        reversedEntities.put("\u2287", "supe");
        reversedEntities.put("\u2295", "oplus");
        reversedEntities.put("\u2297", "otimes");
        reversedEntities.put("\u22a5", "perp");
        reversedEntities.put("\u22c5", "sdot");
        reversedEntities.put("\u2308", "lceil");
        reversedEntities.put("\u2309", "rceil");
        reversedEntities.put("\u230a", "lfloor");
        reversedEntities.put("\u230b", "rfloor");
        reversedEntities.put("\u2329", "lang");
        reversedEntities.put("\u232a", "rang");
        reversedEntities.put("\u25ca", "loz");
        reversedEntities.put("\u2660", "spades");
        reversedEntities.put("\u2663", "clubs");
        reversedEntities.put("\u2665", "hearts");
        reversedEntities.put("\u2666", "diams");
    }

    HTMLEntities() {
    }

    public static String decode(String str) {
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = pattern.matcher(str);
        int index = 0;
        while (matcher.find()) {
            String entity;
            int start = matcher.start() + 1;
            int end = matcher.end() - 1;
            if (start > index) {
                buffer.append(str.substring(index, start - 1));
            }
            if ((entity = str.substring(start, end)).charAt(0) == '#') {
                try {
                    buffer.append((char)Integer.parseInt(entity.substring(1, entity.length())));
                }
                catch (Throwable throwable) {}
            } else {
                String value = (String)entities.get(entity);
                if (value != null) {
                    buffer.append(value);
                }
            }
            index = end + 1;
        }
        int strLength = str.length();
        if (index < strLength) {
            buffer.append(str.substring(index, strLength));
        }
        return buffer.toString();
    }

    public static String encode(String str) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            String key = String.valueOf(c);
            String entity = (String)reversedEntities.get(key);
            if (entity != null) {
                buffer.append("&");
                buffer.append(entity);
                buffer.append(";");
            } else {
                int ci = 0xFFFF & c;
                if (ci < 160) {
                    buffer.append(c);
                } else {
                    buffer.append("&#");
                    buffer.append(ci);
                    buffer.append(';');
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

