/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.repo.model;

import org.pentaho.repo.model.RepositoryObject;

public class RepositoryFile
extends RepositoryObject {
    public static final String TRANSFORMATION = "transformation";
    public static final String JOB = "job";
    public static final String KTR = ".ktr";
    public static final String KJB = ".kjb";
    private String username;

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public static RepositoryFile build(org.pentaho.di.repository.RepositoryObject repositoryObject) {
        RepositoryFile repositoryFile = new RepositoryFile();
        repositoryFile.setObjectId(repositoryObject.getObjectId());
        repositoryFile.setName(repositoryObject.getName());
        repositoryFile.setType(repositoryObject.getObjectType().getTypeDescription());
        repositoryFile.setExtension(repositoryObject.getObjectType().getExtension());
        repositoryFile.setDate(repositoryObject.getModifiedDate());
        repositoryFile.setPath(repositoryObject.getRepositoryDirectory().getPath());
        return repositoryFile;
    }

    public static RepositoryFile build(String parentPath, org.pentaho.platform.api.repository2.unified.RepositoryFile repositoryFile, Boolean isAdmin) {
        RepositoryFile repositoryFile1 = new RepositoryFile();
        repositoryFile1.setObjectId(() -> (String)((Object)repositoryFile.getId()));
        repositoryFile1.setName(RepositoryFile.stripExtension(repositoryFile.getName()));
        repositoryFile1.setType(RepositoryFile.getType(repositoryFile.getName()));
        repositoryFile1.setExtension(KTR);
        repositoryFile1.setDate(repositoryFile.getLastModifiedDate());
        repositoryFile1.setPath(parentPath);
        repositoryFile1.setHidden(repositoryFile.isHidden() != false && isAdmin == false);
        return repositoryFile1;
    }

    public static String stripExtension(String filename) {
        if (filename.indexOf(".") > 0) {
            return filename.substring(0, filename.lastIndexOf("."));
        }
        return filename;
    }

    public static String getType(String filename) {
        if (filename.endsWith(KTR)) {
            return TRANSFORMATION;
        }
        if (filename.endsWith(KJB)) {
            return JOB;
        }
        return "";
    }
}

