/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui.util;

import org.pentaho.openformula.ui.ParameterUpdateEvent;
import org.pentaho.openformula.ui.model2.FunctionInformation;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class FunctionParameterEditHelper {
    public static EditResult buildFormulaText(ParameterUpdateEvent event, FunctionInformation fn, String formula) {
        int paramIdx;
        int globalParameterIndex = event.getParameter();
        if (globalParameterIndex == -1) {
            return FunctionParameterEditHelper.performGlobalReplace(fn, formula, event);
        }
        if (globalParameterIndex >= fn.getParameterCount()) {
            return FunctionParameterEditHelper.performAppendParameter(fn, formula, event);
        }
        String parameterText = event.getText();
        if (!event.isCatchAllParameter()) {
            int start = fn.getParamStart(globalParameterIndex);
            int end = fn.getParamEnd(globalParameterIndex);
            StringBuilder formulaText = new StringBuilder(formula);
            formulaText.delete(start, end);
            formulaText.insert(start, parameterText);
            return new EditResult(formulaText.toString(), start + parameterText.length());
        }
        int start = fn.getParamStart(globalParameterIndex);
        boolean canClearEmpty = true;
        for (paramIdx = globalParameterIndex + 1; paramIdx < fn.getParameterCount(); ++paramIdx) {
            String paramText = fn.getParameterText(paramIdx);
            if (StringUtils.isEmpty((String)paramText, (boolean)true)) continue;
            canClearEmpty = false;
        }
        int end = canClearEmpty ? fn.getParamEnd(paramIdx - 1) : fn.getParamEnd(globalParameterIndex);
        StringBuilder formulaText = new StringBuilder(formula);
        formulaText.delete(start, end);
        formulaText.insert(start, parameterText);
        return new EditResult(formulaText.toString(), start + parameterText.length());
    }

    private static EditResult performAppendParameter(FunctionInformation fn, String formula, ParameterUpdateEvent event) {
        int globalParameterIndex = event.getParameter();
        String parameterText = event.getText();
        if (StringUtils.isEmpty((String)parameterText)) {
            return new EditResult(formula, fn.getParamEnd(fn.getParameterCount() - 1));
        }
        int functionParameterCount = fn.getParameterCount();
        StringBuilder formulaText = new StringBuilder(formula);
        int start = fn.getParamEnd(functionParameterCount - 1);
        for (int i = functionParameterCount; i <= globalParameterIndex; ++i) {
            formulaText.insert(start, ";");
            ++start;
        }
        formulaText.insert(start, parameterText);
        return new EditResult(formulaText.toString(), start + parameterText.length());
    }

    private static EditResult performGlobalReplace(FunctionInformation fn, String formula, ParameterUpdateEvent event) {
        String parameterText = event.getText();
        int start = fn.getFunctionOffset();
        int end = fn.getFunctionParameterEnd();
        StringBuilder formulaText = new StringBuilder(formula);
        formulaText.delete(start, end);
        formulaText.insert(start, parameterText);
        return new EditResult(formulaText.toString(), start + parameterText.length());
    }

    public static class EditResult {
        public final String text;
        public final int caretPositionAfterEdit;

        private EditResult(String text, int caretPositionAfterEdit) {
            this.text = text;
            this.caretPositionAfterEdit = caretPositionAfterEdit;
        }
    }
}

