/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;

public class DateValueConverter
implements ValueConverter {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);

    public DateValueConverter() {
        this.dateFormat.setLenient(false);
    }

    @Override
    public String toAttributeValue(Object o) throws BeanException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof Date)) {
            throw new BeanException("Failed to convert object of type " + o.getClass() + ": Not a Date.");
        }
        DateFormat format = (DateFormat)this.dateFormat.clone();
        return format.format((Date)o);
    }

    @Override
    public Object toPropertyValue(String s) throws BeanException {
        if (s == null) {
            throw new NullPointerException();
        }
        try {
            DateFormat format = (DateFormat)this.dateFormat.clone();
            return format.parse(s);
        }
        catch (ParseException e) {
            throw new BeanException("Failed to parse date", e);
        }
    }
}

