/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextRotation;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawable;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class RotatedTextDrawable
implements ReportDrawable {
    private String text;
    private final TextRotation rotation;
    private Font font;
    private ElementAlignment hAlign;
    private ElementAlignment vAlign;

    public RotatedTextDrawable(String text, TextRotation rotation) {
        this.text = text;
        this.rotation = rotation;
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D bounds) {
        boolean fromBottom = TextRotation.D_90.equals(this.rotation);
        if (this.font != null) {
            graphics2D.setFont(this.font);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.drawTransformed(graphics2D, this.getXPadding(fromBottom, fontMetrics, bounds), this.getYPadding(fromBottom, fontMetrics, bounds), fromBottom ? 4.71238898038469 : 1.5707963267948966);
    }

    private int getXPadding(boolean fromBottom, FontMetrics fontMetrics, Rectangle2D bounds) {
        if (ElementAlignment.CENTER.equals(this.hAlign)) {
            return (int)(bounds.getWidth() / 2.0);
        }
        if (ElementAlignment.LEFT.equals(this.hAlign) || ElementAlignment.JUSTIFY.equals(this.hAlign)) {
            return fromBottom ? fontMetrics.getAscent() : fontMetrics.getDescent();
        }
        if (ElementAlignment.RIGHT.equals(this.hAlign)) {
            return (int)(bounds.getWidth() - (double)(fromBottom ? fontMetrics.getDescent() : fontMetrics.getAscent()));
        }
        return 0;
    }

    private int getYPadding(boolean fromBottom, FontMetrics fontMetrics, Rectangle2D bounds) {
        int stringWidth = fontMetrics.stringWidth(this.text);
        if (ElementAlignment.TOP.equals(this.vAlign)) {
            return fromBottom ? stringWidth : 0;
        }
        if (ElementAlignment.MIDDLE.equals(this.vAlign)) {
            return (int)((bounds.getHeight() + (double)((fromBottom ? 1 : -1) * stringWidth)) / 2.0);
        }
        if (ElementAlignment.BOTTOM.equals(this.vAlign)) {
            return fromBottom ? (int)bounds.getHeight() : (int)(bounds.getHeight() - (double)stringWidth);
        }
        return 0;
    }

    private void drawTransformed(Graphics2D g2D, double x, double y, double theta) {
        AffineTransform fontAT = new AffineTransform();
        Font theFont = g2D.getFont();
        fontAT.rotate(theta);
        Font theDerivedFont = theFont.deriveFont(fontAT);
        g2D.setFont(theDerivedFont);
        g2D.drawString(this.text, (int)x, (int)y);
        g2D.setFont(theFont);
    }

    public Dimension getPreferredSize() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        return new Dimension(fontMetrics.getHeight(), fontMetrics.stringWidth(this.text));
    }

    public boolean isKeepAspectRatio() {
        return true;
    }

    @Override
    public void setConfiguration(Configuration config) {
    }

    @Override
    public void setStyleSheet(StyleSheet style) {
        if (style != null) {
            String fontName = (String)style.getStyleProperty(TextStyleKeys.FONT);
            int fontSize = style.getIntStyleProperty(TextStyleKeys.FONTSIZE, 0);
            boolean bold = style.getBooleanStyleProperty(TextStyleKeys.BOLD);
            boolean italics = style.getBooleanStyleProperty(TextStyleKeys.ITALIC);
            boolean underlined = style.getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
            boolean strikeThrough = style.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
            Color foregroundColor = (Color)style.getStyleProperty(ElementStyleKeys.PAINT);
            Color backgroundColor = (Color)style.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
            if (fontName != null && fontSize > 0) {
                int fontstyle = 0;
                if (bold) {
                    fontstyle |= 1;
                }
                if (italics) {
                    fontstyle |= 2;
                }
                HashMap<TextAttribute, Object> fontAttributes = new HashMap<TextAttribute, Object>();
                if (underlined) {
                    fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (strikeThrough) {
                    fontAttributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                fontAttributes.put(TextAttribute.FOREGROUND, foregroundColor);
                fontAttributes.put(TextAttribute.BACKGROUND, backgroundColor);
                this.font = new Font(fontName, fontstyle, fontSize).deriveFont(fontAttributes);
                this.hAlign = (ElementAlignment)style.getStyleProperty(ElementStyleKeys.ALIGNMENT);
                this.vAlign = (ElementAlignment)style.getStyleProperty(ElementStyleKeys.VALIGNMENT);
            }
        }
    }

    @Override
    public void setResourceBundleFactory(ResourceBundleFactory bundleFactory) {
    }

    @Override
    public ImageMap getImageMap(Rectangle2D bounds) {
        return null;
    }

    public String toString() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public TextRotation getRotation() {
        return this.rotation;
    }

    public static RotatedTextDrawable extract(Object value) {
        if (value instanceof RotatedTextDrawable) {
            return (RotatedTextDrawable)value;
        }
        if (value != null && value instanceof DrawableWrapper && ((DrawableWrapper)value).getBackend() instanceof RotatedTextDrawable) {
            return (RotatedTextDrawable)((DrawableWrapper)value).getBackend();
        }
        return null;
    }

    public ElementAlignment gethAlign() {
        return this.hAlign;
    }

    public ElementAlignment getvAlign() {
        return this.vAlign;
    }
}

