/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.util.EmptyStackException;

public class IntList
implements Cloneable {
    private static final int[] EMPTY_ARRAY = new int[0];
    private int[] data;
    private int size;
    private int increment;

    public IntList(int capacity) {
        this.data = new int[capacity];
        this.increment = capacity;
    }

    public Object clone() {
        try {
            IntList i = (IntList)super.clone();
            i.data = (int[])this.data.clone();
            return i;
        }
        catch (CloneNotSupportedException ce) {
            throw new IllegalStateException(ce);
        }
    }

    private void ensureCapacity(int c) {
        if (this.data.length <= c) {
            int[] newData = new int[Math.max(this.data.length + this.increment, c + 1)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public void add(int value) {
        this.ensureCapacity(this.size);
        this.data[this.size] = value;
        ++this.size;
    }

    public int pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        --this.size;
        int retval = this.data[this.size];
        this.data[this.size] = 0;
        return retval;
    }

    public int get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.data[index];
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public int[] toArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        int[] retval = new int[this.size];
        System.arraycopy(this.data, 0, retval, 0, this.size);
        return retval;
    }

    public int[] toArray(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        int listSize = toIndex - fromIndex;
        int[] retval = new int[listSize];
        System.arraycopy(this.data, fromIndex, retval, 0, listSize);
        return retval;
    }

    public void set(int index, int value) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.data[index] = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IntList");
        sb.append("{size=").append(this.size);
        sb.append(", increment=").append(this.increment);
        sb.append(", data=");
        if (this.data == null) {
            sb.append("null");
        } else {
            sb.append("{");
            for (int i = 0; this.data != null && i < this.size; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.data[i]);
            }
            sb.append(this.data == null ? "null" : "}");
        }
        sb.append('}');
        return sb.toString();
    }
}

