/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.crosstab;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class OrderedMergeCrosstabSpecification
implements CrosstabSpecification {
    private static final Log logger = LogFactory.getLog(OrderedMergeCrosstabSpecification.class);
    private int insertationCursor;
    private ArrayList<Object[]> entries;
    private String[] columnSet;
    private String[] rowSet;
    private ReportStateKey key;

    public OrderedMergeCrosstabSpecification(ReportStateKey key, String[] dimensionColumnSet, String[] rowDimensionSet) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (dimensionColumnSet == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.columnSet = (String[])dimensionColumnSet.clone();
        this.rowSet = (String[])rowDimensionSet.clone();
        this.entries = new ArrayList();
    }

    @Override
    public int indexOf(int start, Object[] key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException();
        }
        int size = this.entries.size();
        for (int i = start; i < size; ++i) {
            Object[] objects = this.entries.get(i);
            if (!ObjectUtilities.equalArray((Object[])key, (Object[])objects)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String[] getColumnDimensionNames() {
        return (String[])this.columnSet.clone();
    }

    @Override
    public String[] getRowDimensionNames() {
        return (String[])this.rowSet.clone();
    }

    @Override
    public ReportStateKey getKey() {
        return this.key;
    }

    @Override
    public void startRow() {
        this.insertationCursor = 0;
    }

    @Override
    public void endRow() {
    }

    @Override
    public void endCrosstab() {
    }

    @Override
    public void add(DataRow dataRow) {
        Object[] newKey = new Object[this.columnSet.length];
        for (int i = 0; i < this.columnSet.length; ++i) {
            String columnName = this.columnSet[i];
            newKey[i] = dataRow.get(columnName);
        }
        int insertPosition = this.findInserationPoint(newKey, 0);
        if (insertPosition != -1) {
            if (insertPosition < this.insertationCursor) {
                throw new InvalidReportStateException("Conflicting data in crosstab. Cannot use insertion-order as base for normalization. Use a SortedMerge-Specification instead.");
            }
            Object[] existingKey = this.entries.get(insertPosition);
            if (ObjectUtilities.equalArray((Object[])existingKey, (Object[])newKey)) {
                logger.debug((Object)("Known Key: " + insertPosition + " " + this.insertationCursor + " -> " + this.printKey(newKey)));
                this.insertationCursor = insertPosition;
                return;
            }
        }
        this.insertationCursor = this.entries.size();
        logger.debug((Object)("Added Key: " + this.insertationCursor + " -> " + this.printKey(newKey)));
        this.entries.add(newKey);
    }

    private String printKey(Object[] data) {
        StringBuilder s = new StringBuilder("{");
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append(data[i]);
        }
        return s.append('}').toString();
    }

    private int findInserationPoint(Object[] key, int inserationPoint) {
        for (int i = inserationPoint; i < this.entries.size(); ++i) {
            Object[] existingKey = this.entries.get(i);
            if (!ObjectUtilities.equalArray((Object[])existingKey, (Object[])key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Object[] getKeyAt(int column) {
        Object[] data = this.entries.get(column);
        return (Object[])data.clone();
    }
}

