/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import java.util.ArrayList;
import java.util.Set;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationMessage;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.util.HashNMap;

public class ValidationResult {
    private ArrayList messages;
    private HashNMap propertyMessages = new HashNMap();
    private ReportParameterValues parameterValues;

    public ValidationResult() {
        this.messages = new ArrayList();
    }

    public ReportParameterValues getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(ReportParameterValues parameterValues) {
        this.parameterValues = parameterValues;
    }

    public void addError(ValidationMessage message) {
        if (message == null) {
            throw new NullPointerException();
        }
        this.messages.add(message);
    }

    public void addError(String parameterName, ValidationMessage message) {
        if (parameterName == null) {
            throw new NullPointerException();
        }
        if (message == null) {
            throw new NullPointerException();
        }
        this.propertyMessages.add((Object)parameterName, (Object)message);
    }

    public ValidationMessage[] getErrors() {
        return this.messages.toArray(new ValidationMessage[this.messages.size()]);
    }

    public ValidationMessage[] getErrors(String parameter) {
        return (ValidationMessage[])this.propertyMessages.toArray((Object)parameter, (Object[])new ValidationMessage[this.propertyMessages.getValueCount((Object)parameter)]);
    }

    public String[] getProperties() {
        Set set = this.propertyMessages.keySet();
        return set.toArray(new String[set.size()]);
    }

    public boolean isEmpty() {
        return this.propertyMessages.isEmpty();
    }

    public String[] toMessageList() {
        ArrayList<String> l = new ArrayList<String>();
        ValidationMessage[] messages1 = this.getErrors();
        for (int i = 0; i < messages1.length; ++i) {
            ValidationMessage message = messages1[i];
            l.add(message.getMessage());
        }
        String[] names = this.getProperties();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            ValidationMessage[] messages2 = this.getErrors(name);
            ValidationMessage message = messages2[i];
            l.add(name + " => " + message.getMessage());
        }
        return l.toArray(new String[l.size()]);
    }
}

