/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements;

import java.beans.IntrospectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ExpressionPropertiesReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AttributeExpressionReadHandler
extends AbstractXmlReadHandler {
    private static final Log logger = LogFactory.getLog(AttributeExpressionReadHandler.class);
    private Expression expression;
    private String name;
    private String namespace;
    private String originalExpressionClass;
    private String expressionClassName;

    protected void startParsing(Attributes attrs) throws SAXException {
        this.name = attrs.getValue(this.getUri(), "name");
        if (this.name == null) {
            throw new SAXException("Required attribute 'name' is missing.");
        }
        this.namespace = attrs.getValue(this.getUri(), "namespace");
        if (this.namespace == null) {
            throw new SAXException("Required attribute 'namespace' is missing.");
        }
        this.originalExpressionClass = attrs.getValue(this.getUri(), "class");
        this.expressionClassName = CompatibilityMapperUtil.mapClassName(this.originalExpressionClass);
        String formula = attrs.getValue(this.getUri(), "formula");
        if (this.expressionClassName == null) {
            if (formula != null) {
                FormulaExpression expression = new FormulaExpression();
                expression.setFormula(formula);
                this.expression = expression;
                this.expression.setName(this.name);
            } else {
                logger.warn((Object)("Required attribute 'class' is missing. Gracefully ignoring the error." + this.getLocator()));
            }
        }
        if (this.expression == null && this.expressionClassName != null) {
            this.expression = (Expression)ObjectUtilities.loadAndInstantiate((String)this.expressionClassName, ((Object)((Object)this)).getClass(), Expression.class);
            if (this.expression == null) {
                throw new ParseException("Expression '" + this.expressionClassName + "' is not valid.", this.getLocator());
            }
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("properties".equals(tagName) && this.expression != null) {
            try {
                return new ExpressionPropertiesReadHandler(this.expression, this.originalExpressionClass, this.expressionClassName);
            }
            catch (IntrospectionException e) {
                throw new SAXException("Unable to create Introspector for the specified expression.");
            }
        }
        return null;
    }

    public Object getObject() {
        return this.expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

