/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout;

import java.util.ArrayList;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.SubReportType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.SubReportParameterReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.AbstractElementReadHandler;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SubReportReadHandler
extends AbstractElementReadHandler {
    private SubReport report;
    private ArrayList<SubReportParameterReadHandler> outputParameters;
    private ArrayList<SubReportParameterReadHandler> inputParameters;
    private ElementType elementType;
    private Class targetClass;

    public SubReportReadHandler() {
        this(SubReportType.INSTANCE, SubReport.class);
    }

    public SubReportReadHandler(ElementType elementType, Class targetClass) {
        if (elementType == null) {
            throw new IllegalStateException();
        }
        this.targetClass = targetClass;
        this.elementType = elementType;
        this.outputParameters = new ArrayList();
        this.inputParameters = new ArrayList();
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        String file = attrs.getValue(this.getUri(), "href");
        if (file != null) {
            Map parameters = this.deriveParseParameters();
            parameters.put(new FactoryParameterKey("::Report"), null);
            parameters.put(new FactoryParameterKey("::Include-parser"), ReportParserUtil.INCLUDE_PARSING_VALUE);
            try {
                this.report = (SubReport)this.performExternalParsing(file, this.targetClass, parameters);
            }
            catch (ResourceLoadingException e) {
                throw new ParseException("The specified subreport was not found or could not be loaded.", (Exception)((Object)e));
            }
        } else {
            throw new ParseException("Required attribute 'href' is missing.", this.getLocator());
        }
        this.initialize(this.elementType);
        super.startParsing(attrs);
        this.report.setAttribute(this.getUri(), "href", null);
    }

    @Override
    protected Element createElement() throws ParseException {
        if (this.report == null) {
            throw new IllegalStateException();
        }
        return this.report;
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0".equals(uri)) {
            if ("output-parameter".equals(tagName)) {
                SubReportParameterReadHandler parameterReadHandler = new SubReportParameterReadHandler();
                this.outputParameters.add(parameterReadHandler);
                return parameterReadHandler;
            }
            if ("input-parameter".equals(tagName)) {
                SubReportParameterReadHandler parameterReadHandler = new SubReportParameterReadHandler();
                this.inputParameters.add(parameterReadHandler);
                return parameterReadHandler;
            }
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    @Override
    public Element getElement() {
        return this.report;
    }

    @Override
    protected void doneParsing() throws SAXException {
        SubReportParameterReadHandler handler;
        int i;
        super.doneParsing();
        for (i = 0; i < this.inputParameters.size(); ++i) {
            handler = this.inputParameters.get(i);
            this.report.addInputParameter(handler.getMasterName(), handler.getDetailName());
        }
        for (i = 0; i < this.outputParameters.size(); ++i) {
            handler = this.outputParameters.get(i);
            this.report.addExportParameter(handler.getMasterName(), handler.getDetailName());
        }
    }
}

