/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.html;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.text.RichTextSpec;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlFormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlImageBounds;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.CellLayoutInfo;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastExportTemplateProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastGridLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.TemplatingOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackgroundProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class FastHtmlTemplateProducer
implements FastExportTemplateProducer {
    private final OutputProcessorMetaData metaData;
    private final SheetLayout sheetLayout;
    private final FastHtmlPrinter htmlPrinter;
    private final CellBackgroundProducer cellBackgroundProducer;
    private FastGridLayout gridLayout;
    private Recorder recorder;

    public FastHtmlTemplateProducer(OutputProcessorMetaData metaData, SheetLayout sheetLayout, FastHtmlPrinter htmlPrinter) {
        this.metaData = metaData;
        this.sheetLayout = sheetLayout;
        this.htmlPrinter = htmlPrinter;
        this.recorder = new Recorder();
        this.cellBackgroundProducer = new CellBackgroundProducer(metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE), metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS));
    }

    @Override
    public FormattedDataBuilder createDataBuilder() {
        return new FastHtmlFormattedDataBuilder(this.gridLayout, this.htmlPrinter, this.recorder.getRecordedBounds());
    }

    @Override
    public void produceTemplate(LogicalPageBox pageBox) {
        TableContentProducer contentProducer = TemplatingOutputProcessor.produceTableLayout(pageBox, this.sheetLayout, this.metaData);
        SheetLayout sheetLayout = contentProducer.getSheetLayout();
        int columnCount = contentProducer.getColumnCount();
        int startRow = contentProducer.getFinishedRows();
        int finishRow = contentProducer.getFilledRows();
        this.gridLayout = new FastGridLayout();
        for (int row = startRow; row < finishRow; ++row) {
            this.gridLayout.addRow(row - startRow, sheetLayout.getRowHeight(row));
            for (int col = 0; col < columnCount; col = (int)((short)(col + 1))) {
                CellMarker.SectionType sectionType = contentProducer.getSectionType(row, col);
                RenderBox content = contentProducer.getContent(row, col);
                if (content == null) {
                    RenderBox backgroundBox = contentProducer.getBackground(row, col);
                    CellBackground background = backgroundBox != null ? this.cellBackgroundProducer.getBackgroundForBox(pageBox, sheetLayout, col, row, 1, 1, true, sectionType, backgroundBox) : this.cellBackgroundProducer.getBackgroundAt(pageBox, sheetLayout, col, row, true, sectionType);
                    if (background != null) {
                        this.gridLayout.addBackground(new CellLayoutInfo(col, row, background));
                        continue;
                    }
                    this.gridLayout.addBackground(new CellLayoutInfo(col, row, null));
                    continue;
                }
                if (!content.isCommited()) {
                    throw new InvalidReportStateException("Uncommited content encountered");
                }
                long contentOffset = contentProducer.getContentOffset(row, col);
                TableRectangle rect = sheetLayout.getTableBounds(content.getX(), content.getY() + contentOffset, content.getWidth(), content.getHeight(), null);
                if (!rect.isOrigin(col, row)) continue;
                CellBackground bg = this.cellBackgroundProducer.getBackgroundForBox(pageBox, sheetLayout, rect.getX1(), rect.getY1(), rect.getColumnSpan(), rect.getRowSpan(), false, sectionType, content);
                this.recordInlineImageDimensions(content);
                this.gridLayout.addContent(content.getInstanceId(), new CellLayoutInfo(rect, bg));
                content.setFinishedTable(true);
            }
        }
    }

    private void recordInlineImageDimensions(RenderBox content) {
        this.recorder.process(content);
    }

    private static class Recorder
    extends IterateSimpleStructureProcessStep {
        private HashMap<InstanceID, FastHtmlImageBounds> recordedBounds = new HashMap();

        private Recorder() {
        }

        private HashMap<InstanceID, FastHtmlImageBounds> getRecordedBounds() {
            return this.recordedBounds;
        }

        public void process(RenderNode box) {
            super.startProcessing(box);
        }

        @Override
        protected boolean startBox(RenderBox node) {
            if (node.getNodeType() == 258) {
                RenderableReplacedContentBox box = (RenderableReplacedContentBox)node;
                FastHtmlImageBounds cb = new FastHtmlImageBounds(node.getWidth(), node.getHeight(), box.getContent().getContentWidth(), box.getContent().getContentHeight());
                this.recordedBounds.put(node.getInstanceId(), cb);
                return false;
            }
            return true;
        }

        @Override
        protected void processOtherNode(RenderNode node) {
            if (node instanceof RenderableComplexText) {
                RenderableComplexText text = (RenderableComplexText)node;
                for (RichTextSpec.StyledChunk c : text.getRichText().getStyleChunks()) {
                    if (!(c.getOriginatingTextNode() instanceof RenderableReplacedContentBox)) continue;
                    RenderBox box = (RenderBox)c.getOriginatingTextNode();
                    this.startBox(box);
                }
            }
        }
    }
}

