/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public abstract class EnumPropertyEditor
implements PropertyEditor {
    private boolean allowNull;
    private Enum value;
    private PropertyChangeSupport propertyChangeSupport;
    private Class<? extends Enum> baseClass;

    protected EnumPropertyEditor(Class<? extends Enum> baseClass, boolean allowNull) {
        this.baseClass = baseClass;
        this.allowNull = allowNull;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (this.baseClass.isInstance(value)) {
            Enum oldVal = this.value;
            this.value = (Enum)value;
            this.propertyChangeSupport.firePropertyChange(null, oldVal, value);
        } else {
            Enum oldVal = this.value;
            this.value = null;
            this.propertyChangeSupport.firePropertyChange(null, oldVal, value);
        }
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        return this.value.name();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
        } else {
            this.setValue(Enum.valueOf(this.baseClass, text));
        }
    }

    @Override
    public String[] getTags() {
        String[] retval;
        int offset;
        Enum[] enumConstants = this.baseClass.getEnumConstants();
        if (this.allowNull) {
            offset = 1;
            retval = new String[enumConstants.length + 1];
        } else {
            offset = 0;
            retval = new String[enumConstants.length];
        }
        for (int i = 0; i < enumConstants.length; ++i) {
            Enum enumConstant = enumConstants[i];
            retval[i + offset] = enumConstant.name();
        }
        return retval;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

