/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.util.Comparator;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;

public class GroupedMetaDataComparator
implements Comparator<MetaData> {
    public static final GroupedMetaDataComparator DEFAULT = new GroupedMetaDataComparator();
    public static final GroupedMetaDataComparator ENGLISH = new GroupedMetaDataComparator(Locale.ENGLISH);
    private Locale locale;

    public GroupedMetaDataComparator() {
        this.locale = Locale.getDefault();
    }

    public GroupedMetaDataComparator(Locale locale) {
        this.locale = locale;
    }

    @Override
    public int compare(MetaData metaData1, MetaData metaData2) {
        int itemOrd2;
        String gr2;
        int groupOrd2;
        int groupOrd1 = metaData1.getGroupingOrdinal(this.locale);
        if (groupOrd1 != (groupOrd2 = metaData2.getGroupingOrdinal(this.locale))) {
            return groupOrd1 < groupOrd2 ? -1 : 1;
        }
        String gr1 = metaData1.getGrouping(this.locale);
        int result = gr1.compareTo(gr2 = metaData2.getGrouping(this.locale));
        if (result != 0) {
            return result;
        }
        int itemOrd1 = metaData1.getItemOrdinal(this.locale);
        if (itemOrd1 != (itemOrd2 = metaData2.getItemOrdinal(this.locale))) {
            return itemOrd1 < itemOrd2 ? -1 : 1;
        }
        String dn1 = metaData1.getMetaAttribute("display-name", this.locale);
        String dn2 = metaData2.getMetaAttribute("display-name", this.locale);
        if (dn1 == null && dn2 == null) {
            return 0;
        }
        if (dn1 == null) {
            return -1;
        }
        if (dn2 == null) {
            return 1;
        }
        return dn1.compareTo(dn2);
    }
}

