/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.io.Serializable;
import java.util.BitSet;
import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.LayouterLevel;
import org.pentaho.reporting.engine.classic.core.states.ReportState;

public class RepeatingFooterValidator
implements Cloneable,
Serializable {
    private BitSet lastPrintedRepeatFooterSignature = new BitSet();
    private BitSet computingSignature = new BitSet();

    public boolean isRepeatFooterValid(ReportEvent event, LayouterLevel[] levels) {
        BitSet bitSet = this.computeRepeatingFooterValidity(event, levels);
        if (bitSet.equals(this.lastPrintedRepeatFooterSignature)) {
            return true;
        }
        this.lastPrintedRepeatFooterSignature.clear();
        this.lastPrintedRepeatFooterSignature.or(bitSet);
        return false;
    }

    private BitSet computeRepeatingFooterValidity(ReportEvent event, LayouterLevel[] levels) {
        BitSet bits = this.computingSignature;
        bits.clear();
        int count = 0;
        ReportDefinition report = event.getReport();
        ReportState state = event.getState();
        int groupsPrinted = state.getPresentationGroupIndex();
        for (LayouterLevel level : levels) {
            DetailsFooter detailsFooter;
            ReportDefinition def = level.getReportDefinition();
            for (int gidx = level.getGroupIndex(); gidx >= 0; --gidx) {
                Group g = def.getGroup(gidx);
                if (!(g instanceof RelationalGroup)) continue;
                RelationalGroup rg = (RelationalGroup)g;
                GroupFooter footer = rg.getFooter();
                bits.set(count, DefaultOutputFunction.isGroupSectionPrintable(footer, true, true));
                ++count;
            }
            if (!level.isInItemGroup() || (detailsFooter = def.getDetailsFooter()) == null) continue;
            bits.set(count, DefaultOutputFunction.isGroupSectionPrintable(detailsFooter, true, true));
            ++count;
        }
        for (int gidx = groupsPrinted; gidx >= 0; --gidx) {
            Group g = report.getGroup(gidx);
            if (!(g instanceof RelationalGroup)) continue;
            RelationalGroup rg = (RelationalGroup)g;
            GroupFooter footer = rg.getFooter();
            bits.set(count, DefaultOutputFunction.isGroupSectionPrintable(footer, false, true));
            ++count;
        }
        if (state.isInItemGroup()) {
            DetailsFooter footer = report.getDetailsFooter();
            bits.set(count, DefaultOutputFunction.isGroupSectionPrintable(footer, false, true));
            ++count;
        }
        return bits;
    }

    public RepeatingFooterValidator clone() {
        try {
            RepeatingFooterValidator copy = (RepeatingFooterValidator)super.clone();
            copy.lastPrintedRepeatFooterSignature = (BitSet)this.lastPrintedRepeatFooterSignature.clone();
            copy.computingSignature = (BitSet)this.computingSignature.clone();
            return copy;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }
}

