/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table.rows;

import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.AbstractRowSizeCache;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowImpl;
import org.pentaho.reporting.engine.classic.core.util.BulkArrayList;

public class ValidatedRowSizeCache
extends AbstractRowSizeCache {
    public long[] get(int limit, BulkArrayList<TableRowImpl> rows) {
        final long[] validatedSizes = this.get(rows);
        rows.foreach(new BulkArrayList.Func<TableRowImpl>(){

            @Override
            public void process(TableRowImpl value, int index) {
                validatedSizes[index] = value.getValidateSize();
            }
        }, this.getFillState(), limit);
        return validatedSizes;
    }

    public void apply(final long[] trailingSizes, int start, int end, BulkArrayList<TableRowImpl> rows) {
        rows.foreach(new BulkArrayList.Func<TableRowImpl>(){

            @Override
            public void process(TableRowImpl row, int i) {
                long validateSize = trailingSizes[i] + row.getValidatedLeadingSize();
                row.setValidateSize(Math.max(row.getPreferredSize(), validateSize));
            }
        }, start, end);
        this.setFillState(end);
    }
}

