/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphPoolBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.style.ParagraphPoolboxStyleSheet;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class ParagraphRenderBox
extends BlockRenderBox {
    private ParagraphPoolBox pool;
    private LineBoxRenderBox lineboxContainer;
    private ElementAlignment textAlignment;
    private ElementAlignment lastLineAlignment;
    private long lineBoxAge;
    private long minorLayoutAge;
    private long minorLayoutValidationX1;
    private long minorLayoutValidationX2;
    private int poolSize;
    private long textIndent;
    private long firstLineIndent;
    private long cachedMaxChildX2;

    public ParagraphRenderBox(StyleSheet styleSheet, InstanceID instanceID, BoxDefinition boxDefinition, ElementType elementType, ReportAttributeMap attributeMap, ReportStateKey stateKey) {
        super(styleSheet, instanceID, boxDefinition, elementType, attributeMap, stateKey);
        this.pool = new ParagraphPoolBox(new ParagraphPoolboxStyleSheet(styleSheet), instanceID, stateKey);
        this.pool.setParent(this);
        this.lastLineAlignment = this.textAlignment = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleKeys.ALIGNMENT, ElementAlignment.LEFT);
        if (this.textAlignment == ElementAlignment.JUSTIFY) {
            this.lastLineAlignment = ElementAlignment.LEFT;
        }
        double rawTextIndent = styleSheet.getDoubleStyleProperty(TextStyleKeys.TEXT_INDENT, 0.0);
        double rawFirstLineIndent = styleSheet.getDoubleStyleProperty(TextStyleKeys.FIRST_LINE_INDENT, rawTextIndent);
        this.textIndent = RenderLength.resolveLength(0L, Math.max(0.0, rawTextIndent));
        this.firstLineIndent = RenderLength.resolveLength(0L, Math.max(0.0, rawFirstLineIndent));
    }

    @Override
    public RenderNode derive(boolean deepDerive) {
        ParagraphRenderBox box = (ParagraphRenderBox)super.derive(deepDerive);
        box.pool = (ParagraphPoolBox)this.pool.derive(deepDerive);
        box.pool.setParent(box);
        if (this.lineboxContainer != null) {
            box.lineboxContainer = (LineBoxRenderBox)this.lineboxContainer.derive(deepDerive);
            box.lineboxContainer.setParent(box);
        }
        if (!deepDerive) {
            box.lineBoxAge = 0L;
        }
        return box;
    }

    @Override
    public final void addChild(RenderNode child) {
        this.pool.addChild(child);
    }

    @Override
    public final void clear() {
        this.pool.clear();
        if (this.lineboxContainer != null) {
            this.lineboxContainer.clear();
        }
        super.clear();
        this.lineBoxAge = 0L;
    }

    public final void clearLayout() {
        super.clear();
        this.minorLayoutAge = 0L;
    }

    @Override
    public boolean isAppendable() {
        return this.pool.isAppendable();
    }

    @Override
    public boolean isEmpty() {
        return this.pool.isEmpty();
    }

    @Override
    public boolean isDiscardable() {
        return this.pool.isDiscardable();
    }

    public ElementAlignment getLastLineAlignment() {
        return this.lastLineAlignment;
    }

    public ElementAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public RenderBox getLineboxContainer() {
        return this.lineboxContainer;
    }

    public boolean isComplexParagraph() {
        return this.lineboxContainer != null;
    }

    public RenderBox createLineboxContainer() {
        if (this.lineboxContainer == null) {
            this.lineboxContainer = new LineBoxRenderBox(this.pool.getStyleSheet(), this.getStateKey());
            this.lineboxContainer.setParent(this);
        }
        return this.lineboxContainer;
    }

    public RenderBox getEffectiveLineboxContainer() {
        if (this.lineboxContainer == null) {
            return this.pool;
        }
        return this.lineboxContainer;
    }

    public ParagraphPoolBox getPool() {
        return this.pool;
    }

    public long getLineBoxAge() {
        return this.lineBoxAge;
    }

    public void setLineBoxAge(long lineBoxAge) {
        this.lineBoxAge = lineBoxAge;
    }

    public long getMinorLayoutAge() {
        return this.minorLayoutAge;
    }

    public void updateMinorLayoutAge() {
        this.minorLayoutAge = this.getEffectiveLineboxContainer().getChangeTracker();
        this.minorLayoutValidationX1 = this.getContentAreaX1();
        this.minorLayoutValidationX2 = this.getContentAreaX2();
    }

    @Override
    public InstanceID getInstanceId() {
        return this.pool.getInstanceId();
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    @Override
    public void close() {
        this.pool.close();
        super.close();
    }

    @Override
    public int getNodeType() {
        return 274;
    }

    @Override
    protected void increaseContentReferenceCount(int count, RenderNode source) {
        if (source != this.pool) {
            return;
        }
        super.increaseContentReferenceCount(count, source);
    }

    @Override
    protected void increaseTableReferenceCount(int count, RenderNode source) {
        if (source != this.pool) {
            return;
        }
        super.increaseTableReferenceCount(count, source);
    }

    @Override
    protected void decreaseContentReferenceCount(int count, RenderNode source) {
        if (source != this.pool) {
            return;
        }
        super.decreaseContentReferenceCount(count, source);
    }

    @Override
    protected void decreaseTableReferenceCount(int count, RenderNode source) {
        if (source != this.pool) {
            return;
        }
        super.decreaseTableReferenceCount(count, source);
    }

    @Override
    protected void increaseDescendantCount(int count, RenderNode source) {
        if (source != this.pool) {
            return;
        }
        super.increaseDescendantCount(count, source);
    }

    @Override
    protected void decreaseDescendantCount(int count, RenderNode source) {
        if (source != this.pool) {
            return;
        }
        super.decreaseDescendantCount(count, source);
    }

    public long getTextIndent() {
        return this.textIndent;
    }

    public long getFirstLineIndent() {
        return this.firstLineIndent;
    }

    @Override
    public boolean isAcceptInlineBoxes() {
        return true;
    }

    public boolean isLineBoxUnchanged() {
        long lineBoxChangeTracker = this.getEffectiveLineboxContainer().getChangeTracker();
        return lineBoxChangeTracker == this.getMinorLayoutAge() && this.minorLayoutValidationX1 == this.getContentAreaX1() && this.minorLayoutValidationX2 == this.getContentAreaX2();
    }

    public long getCachedMaxChildX2() {
        return this.cachedMaxChildX2;
    }

    public void setCachedMaxChildX2(long cachedMaxChildX2) {
        this.cachedMaxChildX2 = cachedMaxChildX2;
    }

    @Override
    public void setCachedWidth(long cachedWidth) {
        super.setCachedWidth(cachedWidth);
    }

    private static class LineBoxRenderBox
    extends BlockRenderBox {
        protected LineBoxRenderBox(StyleSheet styleSheet, ReportStateKey stateKey) {
            super(styleSheet, new InstanceID(), BoxDefinition.EMPTY, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, stateKey);
        }

        @Override
        public boolean isAcceptInlineBoxes() {
            return true;
        }
    }
}

