/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositions;

public class PageBreakPositionList
implements PageBreakPositions {
    private int breakSize;
    private int masterSize;
    private int nextFoundIdx;
    private int prevFoundIdx;
    private int prevFoundMasterIdx;
    private int lastCommonBreak;
    private int lastMasterBreak;
    private PageBreakPositionBackend backend;
    private long scaleFactorMasters;
    private long scaleFactorMinors;
    private boolean enableQuickLookup = true;

    public PageBreakPositionList() {
        this.backend = new PageBreakPositionBackend();
        this.breakSize = 1;
        this.masterSize = 1;
        this.scaleFactorMinors = 0L;
        this.scaleFactorMasters = 0L;
    }

    public PageBreakPositionList(PageBreakPositionList parentList) {
        this.backend = parentList.backend;
        this.breakSize = parentList.breakSize;
        this.masterSize = parentList.masterSize;
        this.prevFoundMasterIdx = parentList.prevFoundMasterIdx;
        this.prevFoundIdx = parentList.prevFoundIdx;
        this.nextFoundIdx = parentList.nextFoundIdx;
        this.lastCommonBreak = parentList.lastCommonBreak;
        this.lastMasterBreak = parentList.lastMasterBreak;
        this.scaleFactorMinors = parentList.scaleFactorMinors;
        this.scaleFactorMasters = parentList.scaleFactorMasters;
    }

    public void copyFrom(PageBreakPositionList parentList) {
        this.backend.copyFrom(parentList.backend);
        this.breakSize = parentList.breakSize;
        this.masterSize = parentList.masterSize;
        this.prevFoundMasterIdx = parentList.prevFoundMasterIdx;
        this.prevFoundIdx = parentList.prevFoundIdx;
        this.nextFoundIdx = parentList.nextFoundIdx;
        this.lastCommonBreak = parentList.lastCommonBreak;
        this.lastMasterBreak = parentList.lastMasterBreak;
        this.scaleFactorMinors = parentList.scaleFactorMinors;
        this.scaleFactorMasters = parentList.scaleFactorMasters;
    }

    public void addMinorBreak(long position) {
        long lastPosition = this.backend.breakPositions[this.breakSize - 1];
        if (position < lastPosition) {
            throw new IllegalArgumentException("Invalid position error: Unsorted Entry or negative page area.");
        }
        this.backend.ensureSize(this.breakSize, this.masterSize);
        if (position > lastPosition) {
            this.backend.breakPositions[this.breakSize] = position;
            ++this.breakSize;
            this.scaleFactorMinors = position / (long)this.breakSize;
        }
    }

    public void addMajorBreak(long position, long pageHeaderSize) {
        long lastMaster;
        long lastPosition = this.backend.breakPositions[this.breakSize - 1];
        if (position < lastPosition) {
            throw new IllegalArgumentException("Invalid position error: Unsorted Entry or negative page area.");
        }
        this.backend.ensureSize(this.breakSize, this.masterSize);
        if (position > lastPosition) {
            this.backend.breakPositions[this.breakSize] = position;
            ++this.breakSize;
            this.scaleFactorMinors = position / (long)this.breakSize;
        }
        if (position < (lastMaster = this.backend.masterBreaks[this.masterSize - 1])) {
            throw new IllegalStateException("Adding new values to the break-position list must be happen sorted.");
        }
        if (position > lastMaster) {
            this.backend.masterBreaks[this.masterSize] = position;
            this.backend.pageHeaderSizes[this.masterSize] = pageHeaderSize;
            ++this.masterSize;
            this.scaleFactorMasters = position / (long)this.masterSize;
        }
    }

    @Override
    public long findNextBreakPosition(long position) {
        int breakIndex = this.findBreak(position);
        if (breakIndex < 0) {
            return this.backend.breakPositions[0];
        }
        if (breakIndex >= this.breakSize) {
            return this.backend.breakPositions[this.breakSize - 1];
        }
        return this.backend.breakPositions[breakIndex];
    }

    @Override
    public long findPreviousBreakPosition(long position) {
        int breakIndex = this.findPreviousMajorBreak(position);
        if (breakIndex < 0) {
            return this.backend.breakPositions[0];
        }
        if (breakIndex >= this.breakSize) {
            return this.backend.breakPositions[this.breakSize - 1];
        }
        return this.backend.breakPositions[breakIndex];
    }

    private int findNextBreak(long pos) {
        int insertPos;
        int i;
        int maxIdx;
        long lastVal;
        int start = 0;
        int end = this.breakSize;
        if (this.nextFoundIdx > 0) {
            long foundPos = this.backend.breakPositions[this.nextFoundIdx];
            long prevPos = this.backend.breakPositions[this.nextFoundIdx - 1];
            if (foundPos >= pos && prevPos < pos) {
                return this.nextFoundIdx - 1;
            }
        }
        if (this.enableQuickLookup && this.breakSize > 0 && (lastVal = this.backend.breakPositions[maxIdx = this.breakSize - 1]) > 0L) {
            boolean maxMorePos;
            int targetIdx = (int)(pos / this.scaleFactorMinors);
            int minTgtIdx = Math.max(0, Math.min(maxIdx, targetIdx - 7));
            int maxTgtIdx = Math.min(maxIdx, targetIdx + 7);
            long minKey = this.backend.breakPositions[minTgtIdx];
            long maxKey = this.backend.breakPositions[maxTgtIdx];
            boolean minLessPos = pos >= minKey;
            boolean bl = maxMorePos = pos <= maxKey;
            if (minLessPos) {
                start = minTgtIdx;
            }
            if (maxMorePos) {
                end = maxTgtIdx + 1;
            }
        }
        if ((i = PageBreakPositionList.binarySearch(this.backend.breakPositions, pos, start, end)) > -1) {
            this.nextFoundIdx = i - 1;
            return this.nextFoundIdx;
        }
        if (i == -1) {
            this.nextFoundIdx = -1;
            return -1;
        }
        this.nextFoundIdx = insertPos = Math.min(-(i + 2), this.breakSize - 1);
        return insertPos;
    }

    private int findPreviousBreak(long pos) {
        int insertPos;
        int i;
        int maxIdx;
        long lastVal;
        int start = 0;
        if (this.prevFoundIdx >= 0) {
            long prevFoundPos = this.backend.breakPositions[this.prevFoundIdx];
            if (prevFoundPos == pos) {
                return this.prevFoundIdx;
            }
            if (prevFoundPos < pos) {
                if (this.prevFoundIdx >= this.breakSize - 1) {
                    return this.prevFoundIdx;
                }
                long nextBreak = this.backend.breakPositions[this.prevFoundIdx + 1];
                if (nextBreak > pos) {
                    return this.prevFoundIdx;
                }
            }
        }
        int end = this.breakSize;
        if (this.enableQuickLookup && this.breakSize > 0 && (lastVal = this.backend.breakPositions[maxIdx = this.breakSize - 1]) > 0L) {
            boolean maxMorePos;
            int targetIdx = (int)(pos / this.scaleFactorMinors);
            int minTgtIdx = Math.max(0, Math.min(maxIdx, targetIdx - 7));
            int maxTgtIdx = Math.min(maxIdx, targetIdx + 7);
            long minKey = this.backend.breakPositions[minTgtIdx];
            long maxKey = this.backend.breakPositions[maxTgtIdx];
            boolean minLessPos = pos >= minKey;
            boolean bl = maxMorePos = pos <= maxKey;
            if (minLessPos) {
                start = minTgtIdx;
            }
            if (maxMorePos) {
                end = maxTgtIdx + 1;
            }
        }
        if ((i = PageBreakPositionList.binarySearch(this.backend.breakPositions, pos, start, end)) > -1) {
            this.prevFoundIdx = i;
            return this.prevFoundIdx;
        }
        if (i == -1) {
            this.prevFoundIdx = -1;
            return -1;
        }
        this.prevFoundIdx = insertPos = Math.min(-(i + 1), this.breakSize) - 1;
        return insertPos;
    }

    private int findPreviousMajorBreak(long pos) {
        int insertPos;
        int i;
        int maxIdx;
        long lastVal;
        if (this.prevFoundMasterIdx >= 0) {
            long prevFoundPos = this.backend.masterBreaks[this.prevFoundMasterIdx];
            if (prevFoundPos == pos) {
                return this.prevFoundMasterIdx;
            }
            if (prevFoundPos < pos) {
                if (this.prevFoundMasterIdx >= this.masterSize - 1) {
                    return this.prevFoundMasterIdx;
                }
                long nextBreak = this.backend.masterBreaks[this.prevFoundMasterIdx + 1];
                if (nextBreak > pos) {
                    return this.prevFoundMasterIdx;
                }
            }
        }
        int start = 0;
        int end = this.masterSize;
        if (this.enableQuickLookup && this.masterSize > 0 && (lastVal = this.backend.masterBreaks[maxIdx = this.masterSize - 1]) > 0L) {
            boolean maxMorePos;
            int targetIdx = (int)(pos / this.scaleFactorMasters);
            int minTgtIdx = Math.max(0, Math.min(maxIdx, targetIdx - 7));
            int maxTgtIdx = Math.min(maxIdx, targetIdx + 7);
            long minKey = this.backend.masterBreaks[minTgtIdx];
            long maxKey = this.backend.masterBreaks[maxTgtIdx];
            boolean minLessPos = pos >= minKey;
            boolean bl = maxMorePos = pos <= maxKey;
            if (minLessPos) {
                start = minTgtIdx;
            }
            if (maxMorePos) {
                end = maxTgtIdx + 1;
            }
        }
        if ((i = PageBreakPositionList.binarySearch(this.backend.masterBreaks, pos, start, end)) > -1) {
            this.prevFoundMasterIdx = i;
            return this.prevFoundMasterIdx;
        }
        if (i == -1) {
            this.prevFoundMasterIdx = -1;
            return -1;
        }
        this.prevFoundMasterIdx = insertPos = Math.min(-(i + 1), this.masterSize) - 1;
        return insertPos;
    }

    @Override
    public boolean isCrossingPagebreak(long boxY, long boxHeight, long pagebreakShift) {
        int y2;
        if (boxHeight == 0L) {
            return false;
        }
        long shiftedStartPos = boxY + pagebreakShift;
        int y1 = this.findPreviousBreak(shiftedStartPos);
        return y1 != (y2 = this.findNextBreak(shiftedStartPos + boxHeight));
    }

    @Override
    public boolean isCrossingPagebreakWithFixedPosition(long shiftedBoxPosition, long boxHeight, long fixedPositionResolved) {
        if (boxHeight == 0L) {
            return false;
        }
        long shiftedSpaceOnPage = Math.max(0L, fixedPositionResolved - this.getPageHeaderHeight(shiftedBoxPosition));
        int pageIndex = this.findPreviousMajorBreak(shiftedBoxPosition);
        long fixedPositionInFlow = pageIndex < 0 ? this.backend.masterBreaks[0] + shiftedSpaceOnPage : this.backend.masterBreaks[pageIndex] + shiftedSpaceOnPage;
        int y1 = this.findPreviousBreak(fixedPositionInFlow);
        int y2 = this.findNextBreak(fixedPositionInFlow + boxHeight);
        return y1 != y2;
    }

    @Override
    public long computeFixedPositionInFlow(long shiftedBoxPosition, long fixedPositionResolved) {
        long pageHeaderHeight = this.getPageHeaderHeight(shiftedBoxPosition);
        long positionInPageContentArea = Math.max(0L, fixedPositionResolved - pageHeaderHeight);
        int pageIndex = this.findPreviousMajorBreak(shiftedBoxPosition);
        long pageStart = pageIndex < 0 ? this.backend.masterBreaks[0] : this.backend.masterBreaks[pageIndex];
        return pageStart + positionInPageContentArea;
    }

    protected long getPageHeaderHeight(long position) {
        int majorBreak = this.findNextMajorBreak(position);
        if (this.isMasterBreak(position)) {
            return this.backend.pageHeaderSizes[Math.min(majorBreak + 1, this.masterSize - 1)];
        }
        return this.backend.pageHeaderSizes[majorBreak];
    }

    private int findBreak(long pos) {
        int insertPos;
        int i;
        int maxIdx;
        long lastVal;
        long prevBreakPos;
        long lastBreakPos;
        int start = 0;
        if (this.lastCommonBreak >= this.breakSize) {
            lastBreakPos = this.backend.breakPositions[this.breakSize - 1];
            if (lastBreakPos > pos) {
                return this.breakSize;
            }
            if (lastBreakPos == pos) {
                this.lastCommonBreak = this.breakSize - 1;
                return this.lastCommonBreak;
            }
        } else if (this.lastCommonBreak == 0 ? (lastBreakPos = this.backend.breakPositions[this.lastCommonBreak]) >= pos : (lastBreakPos = this.backend.breakPositions[this.lastCommonBreak]) >= pos && (prevBreakPos = this.backend.breakPositions[this.lastCommonBreak - 1]) < pos) {
            return this.lastCommonBreak;
        }
        int end = this.breakSize;
        if (this.enableQuickLookup && this.breakSize > 0 && (lastVal = this.backend.breakPositions[maxIdx = this.breakSize - 1]) > 0L) {
            boolean maxMorePos;
            int targetIdx = (int)(pos / this.scaleFactorMinors);
            int minTgtIdx = Math.max(0, Math.min(maxIdx, targetIdx - 7));
            int maxTgtIdx = Math.min(maxIdx, targetIdx + 7);
            long minKey = this.backend.breakPositions[minTgtIdx];
            long maxKey = this.backend.breakPositions[maxTgtIdx];
            boolean minLessPos = pos >= minKey;
            boolean bl = maxMorePos = pos <= maxKey;
            if (minLessPos) {
                start = minTgtIdx;
            }
            if (maxMorePos) {
                end = maxTgtIdx + 1;
            }
        }
        if ((i = PageBreakPositionList.binarySearch(this.backend.breakPositions, pos, start, end)) > -1) {
            this.lastCommonBreak = i;
            return i;
        }
        if (i == -1) {
            this.lastCommonBreak = 0;
            return 0;
        }
        this.lastCommonBreak = insertPos = -(i + 1);
        return insertPos;
    }

    private int findNextMajorBreak(long pos) {
        int insertPos;
        int i;
        int maxIdx;
        long lastVal;
        long prevBreakPos;
        long lastBreakPos;
        int start = 0;
        if (this.lastMasterBreak >= this.masterSize) {
            lastBreakPos = this.backend.masterBreaks[this.breakSize - 1];
            if (lastBreakPos > pos) {
                return this.masterSize;
            }
            if (lastBreakPos == pos) {
                this.lastMasterBreak = this.masterSize - 1;
                return this.lastMasterBreak;
            }
        } else if (this.lastMasterBreak == 0 ? (lastBreakPos = this.backend.masterBreaks[this.lastMasterBreak]) >= pos : (lastBreakPos = this.backend.masterBreaks[this.lastMasterBreak]) >= pos && (prevBreakPos = this.backend.masterBreaks[this.lastMasterBreak - 1]) < pos) {
            return this.lastMasterBreak;
        }
        int end = this.masterSize;
        if (this.enableQuickLookup && this.masterSize > 0 && (lastVal = this.backend.masterBreaks[maxIdx = this.masterSize - 1]) > 0L) {
            boolean maxMorePos;
            int targetIdx = (int)(pos / this.scaleFactorMasters);
            int minTgtIdx = Math.max(0, Math.min(maxIdx, targetIdx - 7));
            int maxTgtIdx = Math.min(maxIdx, targetIdx + 7);
            long minKey = this.backend.masterBreaks[minTgtIdx];
            long maxKey = this.backend.masterBreaks[maxTgtIdx];
            boolean minLessPos = pos >= minKey;
            boolean bl = maxMorePos = pos <= maxKey;
            if (minLessPos) {
                start = minTgtIdx;
            }
            if (maxMorePos) {
                end = maxTgtIdx + 1;
            }
        }
        if ((i = PageBreakPositionList.binarySearch(this.backend.masterBreaks, pos, start, end)) > -1) {
            this.lastMasterBreak = i;
            return i;
        }
        if (i == -1) {
            this.lastMasterBreak = 0;
            return 0;
        }
        this.lastMasterBreak = insertPos = -(i + 1);
        return insertPos;
    }

    private boolean isMasterBreak(long pos) {
        int maxIdx;
        long lastVal;
        int start = 0;
        int end = this.masterSize;
        if (this.enableQuickLookup && this.masterSize > 0 && (lastVal = this.backend.masterBreaks[maxIdx = this.masterSize - 1]) > 0L) {
            boolean maxMorePos;
            int targetIdx = (int)(pos / this.scaleFactorMasters);
            int minTgtIdx = Math.max(0, Math.min(maxIdx, targetIdx - 7));
            int maxTgtIdx = Math.min(maxIdx, targetIdx + 7);
            long minKey = this.backend.masterBreaks[minTgtIdx];
            long maxKey = this.backend.masterBreaks[maxTgtIdx];
            boolean minLessPos = pos >= minKey;
            boolean bl = maxMorePos = pos <= maxKey;
            if (minLessPos) {
                start = minTgtIdx;
            }
            if (maxMorePos) {
                end = maxTgtIdx + 1;
            }
        }
        return PageBreakPositionList.binarySearch(this.backend.masterBreaks, pos, start, end) > -1;
    }

    private static int binarySearch(long[] array, long key, int start, int end) {
        int low = start;
        int high = end - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = array[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public long findNextMajorBreakPosition(long position) {
        int majorBreakIndex = this.findNextMajorBreak(position);
        if (majorBreakIndex < 0) {
            return this.backend.masterBreaks[0];
        }
        if (majorBreakIndex >= this.masterSize) {
            return this.backend.masterBreaks[this.masterSize - 1];
        }
        return this.backend.masterBreaks[majorBreakIndex];
    }

    public long getLastMasterBreak() {
        return this.backend.masterBreaks[this.masterSize - 1];
    }

    public int getMasterBreakSize() {
        return this.masterSize;
    }

    public long getMasterBreak(int index) {
        return this.backend.masterBreaks[index];
    }

    public String toString() {
        StringBuilder retval = new StringBuilder(100);
        retval.append("PageBreakPositionList{breakSize=");
        retval.append(this.breakSize);
        retval.append(", masterSize=");
        retval.append(this.masterSize);
        retval.append(", prevFoundIdx=");
        retval.append(this.prevFoundIdx);
        retval.append(", masterBreaks={");
        int masterBreakCount = this.masterSize;
        for (int i = 0; i < masterBreakCount; ++i) {
            if (i > 0) {
                retval.append(", ");
            }
            long aBreak = this.backend.masterBreaks[i];
            retval.append(String.valueOf(aBreak));
        }
        retval.append("}, breakPositions={");
        int breakPosCount = this.breakSize;
        for (int i = 0; i < breakPosCount; ++i) {
            if (i > 0) {
                retval.append(", ");
            }
            long position = this.backend.breakPositions[i];
            retval.append(String.valueOf(position));
        }
        retval.append("}}");
        return retval.toString();
    }

    @Override
    public long findPageEndForPageStartPosition(long pageOffset) {
        int masterBreakSize = this.getMasterBreakSize();
        if (masterBreakSize > 0) {
            long lastBreak = this.getMasterBreak(masterBreakSize - 1);
            if (pageOffset == lastBreak) {
                return lastBreak;
            }
            for (int i = masterBreakSize - 2; i >= 0; --i) {
                long masterBreak = this.getMasterBreak(i);
                if (masterBreak == pageOffset) {
                    return this.getMasterBreak(i + 1);
                }
                if (masterBreak < pageOffset) break;
            }
        }
        throw new IllegalStateException("Unable to locate proper page start for given offset " + pageOffset);
    }

    @Override
    public long findPageStartPositionForPageEndPosition(long pageOffset) {
        int masterBreakSize = this.getMasterBreakSize();
        for (int i = masterBreakSize - 1; i > 0; --i) {
            long masterBreak = this.getMasterBreak(i);
            if (masterBreak == pageOffset) {
                return this.getMasterBreak(i - 1);
            }
            if (masterBreak >= pageOffset) continue;
            throw new IllegalStateException("Unable to locate proper page start for given offset " + pageOffset);
        }
        return 0L;
    }

    @Override
    public boolean isPageStart(long position) {
        return this.isMasterBreak(position);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageBreakPositionList that = (PageBreakPositionList)o;
        if (this.breakSize != that.breakSize) {
            return false;
        }
        if (this.masterSize != that.masterSize) {
            return false;
        }
        return this.backend.equals(that.backend);
    }

    public int hashCode() {
        int result = this.breakSize;
        result = 31 * result + this.masterSize;
        result = 31 * result + this.backend.hashCode();
        return result;
    }

    private static class PageBreakPositionBackend {
        public long[] pageHeaderSizes = new long[100];
        public long[] masterBreaks = new long[100];
        public long[] breakPositions = new long[100];

        private PageBreakPositionBackend() {
        }

        public void copyFrom(PageBreakPositionBackend parentList) {
            long[] parentBreaks = parentList.breakPositions;
            if (parentBreaks.length > this.breakPositions.length) {
                this.breakPositions = new long[parentBreaks.length];
            }
            System.arraycopy(parentBreaks, 0, this.breakPositions, 0, parentBreaks.length);
            if (parentList.masterBreaks.length > this.masterBreaks.length) {
                this.masterBreaks = new long[parentList.masterBreaks.length];
            }
            System.arraycopy(parentList.masterBreaks, 0, this.masterBreaks, 0, parentList.masterBreaks.length);
            if (parentList.pageHeaderSizes.length > this.pageHeaderSizes.length) {
                this.pageHeaderSizes = new long[parentList.pageHeaderSizes.length];
            }
            System.arraycopy(parentList.pageHeaderSizes, 0, this.pageHeaderSizes, 0, parentList.pageHeaderSizes.length);
        }

        private void ensureSize(int breakSize, int masterSize) {
            long[] newBreakPositions;
            int newSize;
            if (breakSize >= this.breakPositions.length) {
                newSize = breakSize + Math.min(Math.max(breakSize / 2, 5), 512);
                newBreakPositions = new long[newSize];
                System.arraycopy(this.breakPositions, 0, newBreakPositions, 0, this.breakPositions.length);
                this.breakPositions = newBreakPositions;
            }
            if (masterSize >= this.masterBreaks.length) {
                newSize = masterSize + Math.min(Math.max(masterSize / 2, 5), 512);
                newBreakPositions = new long[newSize];
                System.arraycopy(this.masterBreaks, 0, newBreakPositions, 0, this.masterBreaks.length);
                this.masterBreaks = newBreakPositions;
            }
            if (masterSize >= this.pageHeaderSizes.length) {
                newSize = masterSize + Math.min(Math.max(masterSize / 2, 5), 512);
                newBreakPositions = new long[newSize];
                System.arraycopy(this.pageHeaderSizes, 0, newBreakPositions, 0, this.pageHeaderSizes.length);
                this.pageHeaderSizes = newBreakPositions;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageBreakPositionBackend that = (PageBreakPositionBackend)o;
            if (!Arrays.equals(this.breakPositions, that.breakPositions)) {
                return false;
            }
            if (!Arrays.equals(this.masterBreaks, that.masterBreaks)) {
                return false;
            }
            return Arrays.equals(this.pageHeaderSizes, that.pageHeaderSizes);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.pageHeaderSizes);
            result = 31 * result + Arrays.hashCode(this.masterBreaks);
            result = 31 * result + Arrays.hashCode(this.breakPositions);
            return result;
        }
    }
}

