/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;

public final class Border
implements Cloneable {
    public static final Border EMPTY_BORDER = new Border(BorderEdge.EMPTY, BorderEdge.EMPTY, BorderEdge.EMPTY, BorderEdge.EMPTY, BorderEdge.EMPTY, BorderCorner.EMPTY, BorderCorner.EMPTY, BorderCorner.EMPTY, BorderCorner.EMPTY);
    private BorderEdge top;
    private BorderEdge left;
    private BorderEdge bottom;
    private BorderEdge right;
    private BorderEdge splittingEdge;
    private BorderCorner topLeft;
    private BorderCorner topRight;
    private BorderCorner bottomLeft;
    private BorderCorner bottomRight;
    private Boolean empty;
    private Boolean sameForAllSides;

    public Border(BorderEdge top, BorderEdge left, BorderEdge bottom, BorderEdge right, BorderEdge splittingEdge, BorderCorner topLeft, BorderCorner topRight, BorderCorner bottomLeft, BorderCorner bottomRight) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.splittingEdge = splittingEdge;
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
    }

    public BorderEdge getTop() {
        return this.top;
    }

    public BorderEdge getLeft() {
        return this.left;
    }

    public BorderEdge getBottom() {
        return this.bottom;
    }

    public BorderEdge getRight() {
        return this.right;
    }

    public BorderEdge getSplittingEdge() {
        return this.splittingEdge;
    }

    public BorderCorner getTopLeft() {
        return this.topLeft;
    }

    public BorderCorner getTopRight() {
        return this.topRight;
    }

    public BorderCorner getBottomLeft() {
        return this.bottomLeft;
    }

    public BorderCorner getBottomRight() {
        return this.bottomRight;
    }

    public Border[] splitVertically(Border[] borders) {
        if (borders == null || borders.length < 2) {
            borders = new Border[2];
        }
        Boolean empty = this.empty != null && Boolean.TRUE.equals(this.empty) ? (this.splittingEdge.isEmpty() ? Boolean.TRUE : Boolean.FALSE) : null;
        borders[0] = (Border)this.clone();
        borders[0].empty = empty;
        borders[0].right = borders[0].splittingEdge;
        borders[0].topRight = BorderCorner.EMPTY;
        borders[0].bottomRight = BorderCorner.EMPTY;
        borders[1] = (Border)this.clone();
        borders[1].empty = empty;
        borders[1].left = borders[1].splittingEdge;
        borders[1].topLeft = BorderCorner.EMPTY;
        borders[1].bottomLeft = BorderCorner.EMPTY;
        return borders;
    }

    public Border[] splitHorizontally(Border[] borders) {
        if (borders == null || borders.length < 2) {
            borders = new Border[2];
        }
        Boolean empty = this.empty != null && Boolean.TRUE.equals(this.empty) ? (this.splittingEdge.isEmpty() ? Boolean.TRUE : Boolean.FALSE) : null;
        borders[0] = (Border)this.clone();
        borders[0].empty = empty;
        borders[0].sameForAllSides = null;
        borders[0].bottom = borders[0].splittingEdge;
        borders[0].bottomLeft = BorderCorner.EMPTY;
        borders[0].bottomRight = BorderCorner.EMPTY;
        borders[1] = (Border)this.clone();
        borders[1].empty = empty;
        borders[1].top = borders[1].splittingEdge;
        borders[1].topLeft = BorderCorner.EMPTY;
        borders[1].topRight = BorderCorner.EMPTY;
        return borders;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Borders not supporting clone is evil!");
        }
    }

    public boolean isSameForAllSides() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.sameForAllSides == null) {
            this.sameForAllSides = this.computeSameForAllSides();
        }
        return this.sameForAllSides;
    }

    private Boolean computeSameForAllSides() {
        BorderEdge borderEdge = this.top;
        if (!borderEdge.equals(this.bottom)) {
            return Boolean.FALSE;
        }
        if (!borderEdge.equals(this.left)) {
            return Boolean.FALSE;
        }
        if (!borderEdge.equals(this.right)) {
            return Boolean.FALSE;
        }
        BorderCorner corner = this.topLeft;
        if (!corner.equals(this.topRight)) {
            return Boolean.FALSE;
        }
        if (!corner.equals(this.bottomLeft)) {
            return Boolean.FALSE;
        }
        if (!corner.equals(this.bottomRight)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean isEmpty() {
        if (this.empty != null) {
            return this.empty;
        }
        if (this.top.getWidth() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.left.getWidth() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.bottom.getWidth() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.right.getWidth() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        this.empty = Boolean.TRUE;
        return true;
    }

    public String toString() {
        return "Border{top=" + this.top + ", left=" + this.left + ", bottom=" + this.bottom + ", right=" + this.right + ", splittingEdge=" + this.splittingEdge + ", topLeft=" + this.topLeft + ", topRight=" + this.topRight + ", bottomLeft=" + this.bottomLeft + ", bottomRight=" + this.bottomRight + ", empty=" + this.empty + '}';
    }
}

