/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.build;

import org.pentaho.reporting.engine.classic.core.layout.build.GroupSection;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilderContext;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public class SectionLayoutModelBuilderContext
implements LayoutModelBuilderContext,
Cloneable {
    private GroupSection section;
    private LayoutModelBuilderContext parent;
    private boolean strictLegacyMode;
    private boolean empty;
    private boolean keepWrapperBoxAlive;
    private boolean autoGeneratedWrapperBox;

    public SectionLayoutModelBuilderContext(LayoutModelBuilderContext parent, GroupSection section, boolean strictLegacyMode) {
        this.section = section;
        this.parent = parent;
        this.strictLegacyMode = strictLegacyMode;
        this.parent.addChild(section.getGroupBox());
        this.parent.setEmpty(false);
    }

    @Override
    public RenderBox getRenderBox() {
        return this.section.getAddBox();
    }

    @Override
    public LayoutModelBuilderContext getParent() {
        return this.parent;
    }

    @Override
    public boolean mergeSection(ReportStateKey stateKey) {
        if (stateKey == null && !this.strictLegacyMode) {
            return false;
        }
        return this.section.mergeSection(stateKey);
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    @Override
    public boolean isKeepWrapperBoxAlive() {
        return this.keepWrapperBoxAlive;
    }

    @Override
    public void setKeepWrapperBoxAlive(boolean keepWrapperBoxAlive) {
        this.keepWrapperBoxAlive = keepWrapperBoxAlive;
    }

    @Override
    public boolean isAutoGeneratedWrapperBox() {
        return this.autoGeneratedWrapperBox;
    }

    @Override
    public void setAutoGeneratedWrapperBox(boolean autoGeneratedWrapperBox) {
        this.autoGeneratedWrapperBox = autoGeneratedWrapperBox;
    }

    @Override
    public LayoutModelBuilderContext close() {
        this.section.close();
        return this.parent;
    }

    @Override
    public void commitAsEmpty() {
    }

    @Override
    public void addChild(RenderBox child) {
        this.section.addedSection(child);
    }

    @Override
    public void removeChild(RenderBox child) {
        this.section.removedLastSection(child);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public LayoutModelBuilderContext deriveForPagebreak() {
        SectionLayoutModelBuilderContext clone = (SectionLayoutModelBuilderContext)this.clone();
        clone.section = this.section.deriveForPagebreak();
        if (clone.parent != null) {
            clone.parent = this.parent.deriveForPagebreak();
        }
        return clone;
    }

    @Override
    public LayoutModelBuilderContext deriveForStorage(RenderBox clonedRoot) {
        SectionLayoutModelBuilderContext clone = (SectionLayoutModelBuilderContext)this.clone();
        if (clone.parent != null) {
            clone.parent = this.parent.deriveForStorage(clonedRoot);
            clone.section = this.section.deriveForStorage(clone.parent.getRenderBox());
        } else {
            clone.section = this.section.deriveForStorage(null);
        }
        return clone;
    }

    @Override
    public void validateAfterCommit() {
        this.section.performPostCommitModelCheck();
    }

    @Override
    public void performParanoidModelCheck() {
        this.section.performParanoidModelCheck();
    }

    @Override
    public void restoreStateAfterRollback() {
        this.section.restoreStateAfterRollback();
    }

    @Override
    public int getDepth() {
        if (this.parent == null) {
            return 1;
        }
        return 1 + this.parent.getDepth();
    }
}

