/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.parameters.CompoundDataRow;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class WrapperExpressionRuntime
implements ExpressionRuntime {
    private DataRow dataRow;
    private ExpressionRuntime runtime;
    private WrapperProcessingContext processingContext;

    public WrapperExpressionRuntime() {
    }

    public WrapperExpressionRuntime(DataRow overrideValues, ExpressionRuntime runtime) {
        this.update(overrideValues, runtime);
    }

    public void update(DataRow overrideValues, ExpressionRuntime runtime) {
        if (runtime == null) {
            this.dataRow = null;
            this.runtime = null;
            this.processingContext = null;
            return;
        }
        this.dataRow = overrideValues != null ? new CompoundDataRow(overrideValues, runtime.getDataRow()) : runtime.getDataRow();
        this.processingContext = new WrapperProcessingContext(runtime);
        this.runtime = runtime;
    }

    @Override
    public DataRow getDataRow() {
        return this.dataRow;
    }

    @Override
    public DataSchema getDataSchema() {
        return this.runtime.getDataSchema();
    }

    @Override
    public Configuration getConfiguration() {
        return this.runtime.getConfiguration();
    }

    @Override
    public ResourceBundleFactory getResourceBundleFactory() {
        return this.runtime.getResourceBundleFactory();
    }

    @Override
    public TableModel getData() {
        return this.runtime.getData();
    }

    @Override
    public int getCurrentRow() {
        return this.runtime.getCurrentRow();
    }

    @Override
    public int getCurrentDataItem() {
        return this.runtime.getCurrentDataItem();
    }

    @Override
    public int getCurrentGroup() {
        return this.runtime.getCurrentGroup();
    }

    @Override
    public int getGroupStartRow(String groupName) {
        return this.runtime.getGroupStartRow(groupName);
    }

    @Override
    public int getGroupStartRow(int groupIndex) {
        return this.runtime.getGroupStartRow(groupIndex);
    }

    @Override
    public String getExportDescriptor() {
        return this.runtime.getExportDescriptor();
    }

    @Override
    public ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    @Override
    public DataFactory getDataFactory() {
        return this.runtime.getDataFactory();
    }

    @Override
    public boolean isStructuralComplexReport() {
        return this.runtime.isStructuralComplexReport();
    }

    @Override
    public boolean isCrosstabActive() {
        return this.runtime.isCrosstabActive();
    }

    private static class WrapperProcessingContext
    implements ProcessingContext {
        private ProcessingContext context;
        private ExpressionRuntime runtime;

        private WrapperProcessingContext(ExpressionRuntime runtime) {
            this.context = runtime.getProcessingContext();
            this.runtime = runtime;
        }

        @Override
        public int getProgressLevel() {
            return this.context.getProgressLevel();
        }

        @Override
        public int getProgressLevelCount() {
            return this.context.getProgressLevelCount();
        }

        @Override
        public int getProcessingLevel() {
            return this.context.getProcessingLevel();
        }

        @Override
        public FormulaContext getFormulaContext() {
            return new ReportFormulaContext(this.context.getFormulaContext(), this.runtime);
        }

        @Override
        public boolean isPrepareRun() {
            return this.context.isPrepareRun();
        }

        @Override
        public String getExportDescriptor() {
            return this.context.getExportDescriptor();
        }

        @Override
        public OutputProcessorMetaData getOutputProcessorMetaData() {
            return this.context.getOutputProcessorMetaData();
        }

        @Override
        public ResourceBundleFactory getResourceBundleFactory() {
            return this.context.getResourceBundleFactory();
        }

        @Override
        public ResourceKey getContentBase() {
            return this.context.getContentBase();
        }

        @Override
        public ResourceManager getResourceManager() {
            return this.context.getResourceManager();
        }

        @Override
        public Configuration getConfiguration() {
            return this.context.getConfiguration();
        }

        @Override
        public DocumentMetaData getDocumentMetaData() {
            return this.context.getDocumentMetaData();
        }

        @Override
        public ReportEnvironment getEnvironment() {
            return this.context.getEnvironment();
        }

        @Override
        public long getReportProcessingStartTime() {
            return this.context.getReportProcessingStartTime();
        }

        @Override
        public int getCompatibilityLevel() {
            return this.context.getCompatibilityLevel();
        }
    }
}

