/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.StateSequence;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class TotalItemMinFunction
extends AbstractFunction
implements FieldAggregationFunction {
    private static final Log logger = LogFactory.getLog(TotalItemMinFunction.class);
    private static final int ZERO_I = 0;
    private transient int lastGroupSequenceNumber;
    private String group;
    private String field;
    private transient Sequence<Comparable> result;
    private StateSequence<Comparable> stateSequence = new StateSequence();
    private transient ReportStateKey globalStateKey;
    private String crosstabFilterGroup;

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void setField(String field) {
        this.field = field;
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        this.globalStateKey = event.getState().getProcessKey();
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.result = new Sequence();
            this.stateSequence.clear();
            this.stateSequence.add(this.globalStateKey, this.result);
            this.lastGroupSequenceNumber = 0;
        } else {
            this.result = this.stateSequence.resultExists() ? this.stateSequence.getResult(0) : null;
            this.lastGroupSequenceNumber = 0;
        }
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            ReportStateKey groupStateKey = event.getState().getProcessKey();
            if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
                this.result = new Sequence();
                this.lastGroupSequenceNumber = 0;
                this.stateSequence.add(this.globalStateKey, this.result);
                this.stateSequence.add(groupStateKey, this.result);
            } else {
                int found = this.stateSequence.getKeyIndex(groupStateKey);
                this.result = found < 0 ? null : this.stateSequence.getResult(found);
            }
        }
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (this.field == null) {
            return;
        }
        if (!FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            return;
        }
        Object fieldValue = event.getDataRow().get(this.getField());
        if (!(fieldValue instanceof Comparable)) {
            return;
        }
        try {
            Comparable compare = (Comparable)fieldValue;
            Comparable oldValue = this.result.get(this.lastGroupSequenceNumber);
            if (oldValue == null || oldValue.compareTo(compare) > 0) {
                this.result.set(this.lastGroupSequenceNumber, compare);
            }
        }
        catch (Exception e) {
            logger.error((Object)"TotalItemMinFunction.advanceItems(): problem comparing values.");
        }
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public Object getValue() {
        if (this.result == null) {
            return null;
        }
        return this.result.get(this.lastGroupSequenceNumber);
    }

    @Override
    public Expression getInstance() {
        TotalItemMinFunction function = (TotalItemMinFunction)super.getInstance();
        function.stateSequence = new StateSequence();
        return function;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.stateSequence = new StateSequence();
    }

    @Override
    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    @Override
    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }
}

