/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ShowElementIfDataAvailableExpression
extends AbstractElementFormatFunction {
    @Override
    protected boolean evaluateElement(ReportElement e) {
        if (ObjectUtilities.equal((Object)e.getName(), (Object)this.getElement())) {
            e.getStyle().setStyleProperty(ElementStyleKeys.VISIBLE, this.isDataAvailable());
            return true;
        }
        return false;
    }

    private boolean isDataAvailable() {
        ExpressionRuntime runtime = this.getRuntime();
        if (runtime == null) {
            return false;
        }
        TableModel data = runtime.getData();
        if (data == null) {
            return false;
        }
        return data.getRowCount() != 0;
    }

    @Override
    public Object getValue() {
        if (this.isDataAvailable()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

