/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.compat;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.designtime.compat.CompatibilityConverter;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.InternationalizedLoader;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public abstract class AbstractCompatibilityConverter
implements CompatibilityConverter {
    protected AbstractCompatibilityConverter() {
    }

    @Override
    public String getUpgradeDescription(Locale locale) {
        try {
            String name = this.getClass().getName();
            String path = name.replace('.', '/');
            byte[] bytes = new BinaryDataLoader().load(path, locale);
            if (bytes == null) {
                return "";
            }
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is not a supported encoding in this JDK.");
        }
    }

    @Override
    public void inspectElement(ReportElement element) {
    }

    @Override
    public void inspectAttributeExpression(ReportElement element, String attributeNamespace, String attributeName, Expression expression, ExpressionMetaData expressionMetaData) {
    }

    @Override
    public void inspectStyleExpression(ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
    }

    @Override
    public void inspectExpression(AbstractReportDefinition report, Expression expression) {
    }

    @Override
    public void inspectParameter(AbstractReportDefinition report, ReportParameterDefinition definition, ParameterDefinitionEntry parameter) {
    }

    @Override
    public void inspectDataSource(AbstractReportDefinition report, DataFactory dataFactory) {
    }

    private static class BinaryDataLoader
    extends InternationalizedLoader<byte[]> {
        private BinaryDataLoader() {
        }

        @Override
        public byte[] load(String name, Locale locale) {
            return (byte[])super.load(name, locale);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected byte[] loadData(String name) {
            byte[] byArray;
            InputStream stream = ObjectUtilities.getResourceAsStream((String)name, this.getClass());
            if (stream == null) {
                return null;
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.getInstance().copyStreams(stream, (OutputStream)out);
                byArray = out.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            stream.close();
            return byArray;
        }

        @Override
        protected String getExtension() {
            return ".html";
        }
    }
}

