/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime;

import org.pentaho.reporting.engine.classic.core.designtime.AttributeChange;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilter;
import org.pentaho.reporting.engine.classic.core.designtime.StyleChange;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;

public class ReportModelEventFilterFactory {
    public ReportModelEventFilter createStyleFilter(StyleKey key) {
        return new StyleReportModelEventFilter(key);
    }

    public ReportModelEventFilter createAttributeFilter(String attrNameSpace, String attrName) {
        return new AttributeReportModelEventFilter(attrNameSpace, attrName);
    }

    public static class AttributeReportModelEventFilter
    implements ReportModelEventFilter {
        private String nameSpace;
        private String name;

        public AttributeReportModelEventFilter(String nameSpace, String name) {
            this.name = name;
            this.nameSpace = nameSpace;
        }

        @Override
        public boolean isFilteredEvent(ReportModelEvent event) {
            Object parameter = event.getParameter();
            if (!(parameter instanceof AttributeChange)) {
                return false;
            }
            AttributeChange attrChange = (AttributeChange)parameter;
            if (!this.nameSpace.equals(attrChange.getNamespace())) {
                return false;
            }
            return this.name.equals(attrChange.getName());
        }
    }

    public static class StyleReportModelEventFilter
    implements ReportModelEventFilter {
        private StyleKey key;

        public StyleReportModelEventFilter(StyleKey key) {
            this.key = key;
        }

        @Override
        public boolean isFilteredEvent(ReportModelEvent event) {
            Object parameter = event.getParameter();
            if (!(parameter instanceof StyleChange)) {
                return false;
            }
            StyleChange styleChange = (StyleChange)parameter;
            return this.key.equals(styleChange.getStyleKey());
        }
    }
}

