/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.awt.print.PageFormat;
import java.util.LinkedHashMap;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.designtime.SubReportParameterChange;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.SubReportType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class SubReport
extends AbstractReportDefinition {
    private LinkedHashMap<String, String> exportParameters;
    private LinkedHashMap<String, String> inputParameters;
    private DataFactory dataFactory;

    public SubReport() {
        this.setElementType(new SubReportType());
        this.exportParameters = new LinkedHashMap();
        this.inputParameters = new LinkedHashMap();
    }

    public SubReport(InstanceID id) {
        super(id);
        this.setElementType(new SubReportType());
        this.exportParameters = new LinkedHashMap();
        this.inputParameters = new LinkedHashMap();
    }

    @Override
    public PageDefinition getPageDefinition() {
        for (Section parent = this.getParentSection(); parent != null; parent = parent.getParentSection()) {
            if (!(parent instanceof MasterReport)) continue;
            MasterReport masterReport = (MasterReport)parent;
            return masterReport.getPageDefinition();
        }
        return new SimplePageDefinition(new PageFormat());
    }

    @Override
    public SubReport derive(boolean preserveElementInstanceIds) {
        SubReport o = (SubReport)super.derive(preserveElementInstanceIds);
        o.exportParameters = (LinkedHashMap)this.exportParameters.clone();
        o.inputParameters = (LinkedHashMap)this.inputParameters.clone();
        if (this.dataFactory != null) {
            o.dataFactory = this.dataFactory.derive();
        }
        return o;
    }

    public void reconnectParent(Section parentSection) {
        parentSection.registerAsChild(this);
    }

    @Override
    public SubReport clone() {
        SubReport o = (SubReport)super.clone();
        o.exportParameters = (LinkedHashMap)this.exportParameters.clone();
        o.inputParameters = (LinkedHashMap)this.inputParameters.clone();
        if (this.dataFactory != null) {
            o.dataFactory = this.dataFactory.derive();
        }
        return o;
    }

    public void addExportParameter(String outerName, String sourceColumn) {
        if (outerName == null) {
            throw new NullPointerException();
        }
        if (sourceColumn == null) {
            throw new NullPointerException();
        }
        ParameterMapping[] oldMappings = this.getExportMappings();
        this.exportParameters.put(outerName, sourceColumn);
        this.notifyNodePropertiesChanged(new SubReportParameterChange(SubReportParameterChange.Type.EXPORT, oldMappings, this.getExportMappings()));
    }

    public void removeExportParameter(String outerName) {
        if (outerName == null) {
            throw new NullPointerException();
        }
        ParameterMapping[] oldMappings = this.getExportMappings();
        this.exportParameters.remove(outerName);
        this.notifyNodePropertiesChanged(new SubReportParameterChange(SubReportParameterChange.Type.EXPORT, oldMappings, this.getExportMappings()));
    }

    public ParameterMapping[] getExportMappings() {
        int length = this.exportParameters.size();
        String[] keys = this.exportParameters.keySet().toArray(new String[length]);
        ParameterMapping[] mapping = new ParameterMapping[length];
        for (int i = 0; i < length; ++i) {
            String name = keys[i];
            String alias = this.exportParameters.get(name);
            mapping[i] = new ParameterMapping(name, alias);
        }
        return mapping;
    }

    public void setExportMappings(ParameterMapping[] mappings) {
        if (mappings == null) {
            throw new NullPointerException();
        }
        ParameterMapping[] oldMappings = this.getExportMappings();
        this.exportParameters.clear();
        for (int i = 0; i < mappings.length; ++i) {
            ParameterMapping mapping = mappings[i];
            this.exportParameters.put(mapping.getName(), mapping.getAlias());
        }
        this.notifyNodePropertiesChanged(new SubReportParameterChange(SubReportParameterChange.Type.EXPORT, oldMappings, this.getExportMappings()));
    }

    public void addInputParameter(String outerName, String sourceColumn) {
        if (outerName == null) {
            throw new NullPointerException();
        }
        if (sourceColumn == null) {
            throw new NullPointerException();
        }
        ParameterMapping[] oldMappings = this.getInputMappings();
        this.inputParameters.put(sourceColumn, outerName);
        this.notifyNodePropertiesChanged(new SubReportParameterChange(SubReportParameterChange.Type.INPUT, oldMappings, this.getInputMappings()));
    }

    public void removeInputParameter(String sourceColumn) {
        if (sourceColumn == null) {
            throw new NullPointerException();
        }
        ParameterMapping[] oldMappings = this.getInputMappings();
        this.inputParameters.remove(sourceColumn);
        this.notifyNodePropertiesChanged(new SubReportParameterChange(SubReportParameterChange.Type.INPUT, oldMappings, this.getInputMappings()));
    }

    public void clearInputParameters() {
        ParameterMapping[] oldMappings = this.getInputMappings();
        this.inputParameters.clear();
        this.notifyNodePropertiesChanged(new SubReportParameterChange(SubReportParameterChange.Type.INPUT, oldMappings, this.getInputMappings()));
    }

    public void clearExportParameters() {
        ParameterMapping[] oldMappings = this.getExportMappings();
        this.exportParameters.clear();
        this.notifyNodePropertiesChanged();
        this.notifyNodePropertiesChanged(new SubReportParameterChange(SubReportParameterChange.Type.EXPORT, oldMappings, this.getExportMappings()));
    }

    public ParameterMapping[] getInputMappings() {
        int length = this.inputParameters.size();
        String[] keys = this.inputParameters.keySet().toArray(new String[length]);
        ParameterMapping[] mapping = new ParameterMapping[length];
        for (int i = 0; i < length; ++i) {
            String alias = keys[i];
            String name = this.inputParameters.get(alias);
            mapping[i] = new ParameterMapping(name, alias);
        }
        return mapping;
    }

    public void setInputMappings(ParameterMapping[] mappings) {
        if (mappings == null) {
            throw new NullPointerException();
        }
        ParameterMapping[] oldMappings = this.getInputMappings();
        this.inputParameters.clear();
        for (int i = 0; i < mappings.length; ++i) {
            ParameterMapping mapping = mappings[i];
            this.inputParameters.put(mapping.getAlias(), mapping.getName());
        }
        this.notifyNodePropertiesChanged(new SubReportParameterChange(SubReportParameterChange.Type.INPUT, oldMappings, this.getInputMappings()));
    }

    public boolean isGlobalImport() {
        return "*".equals(this.inputParameters.get("*"));
    }

    public boolean isGlobalExport() {
        return "*".equals(this.exportParameters.get("*"));
    }

    @Override
    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    @Override
    public void setDataFactory(DataFactory dataFactory) {
        DataFactory old = this.dataFactory;
        this.dataFactory = dataFactory;
        if (old != null) {
            this.notifyNodeChildRemoved(old);
        }
        if (dataFactory != null) {
            this.notifyNodeChildAdded(dataFactory);
        }
    }

    public Expression getActivationExpression() {
        return this.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "subreport-active");
    }

    public void setActivationExpression(Expression activationExpression) {
        this.setAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "subreport-active", activationExpression);
    }

    @Override
    protected void updateChangedFlagInternal(ReportElement element, int type, Object parameter) {
        super.fireModelLayoutChanged(element, type, parameter);
        super.updateChangedFlagInternal(element, type, parameter);
    }

    @Override
    @Deprecated
    public ResourceManager getResourceManager() {
        return DesignTimeUtil.getResourceManager(this);
    }

    @Override
    @Deprecated
    public ResourceBundleFactory getResourceBundleFactory() {
        return super.getResourceBundleFactory();
    }
}

