/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.database.gwt;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.gwt.widgets.client.utils.i18n.ResourceBundle;
import org.pentaho.ui.database.event.DataHandler;
import org.pentaho.ui.database.event.DatabaseDialogListener;
import org.pentaho.ui.database.event.GwtFragmentHandler;
import org.pentaho.ui.database.gwt.GwtLaunch;
import org.pentaho.ui.database.gwt.GwtMessages;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.gwt.GwtXulDomContainer;
import org.pentaho.ui.xul.gwt.GwtXulRunner;
import org.pentaho.ui.xul.gwt.util.AsyncXulLoader;
import org.pentaho.ui.xul.gwt.util.IXulLoaderCallback;
import org.pentaho.ui.xul.impl.XulEventHandler;

public class GwtDatabaseDialog {
    protected DatabaseTypeHelper databaseTypeHelper;
    protected DataHandler dataHandler = new DataHandler();
    protected GwtFragmentHandler fragmentHandler = new GwtFragmentHandler();
    protected GwtMessages messages = new GwtMessages();
    protected String overlay = null;
    protected String overlayResource = "databasedialog";
    protected DatabaseDialogListener listener;
    protected XulDialog dialog;

    public GwtDatabaseDialog(DatabaseTypeHelper databaseTypeHelper, DatabaseDialogListener listener) {
        this.databaseTypeHelper = databaseTypeHelper;
        this.listener = listener;
        AsyncXulLoader.loadXulFromUrl((String)(GWT.getModuleBaseURL() + "databasedialog.xul"), (String)(GWT.getModuleBaseURL() + "databasedialog"), (IXulLoaderCallback)new InternalCallback());
    }

    public GwtDatabaseDialog(DatabaseTypeHelper databaseTypeHelper, String overlay, DatabaseDialogListener listener) {
        this.databaseTypeHelper = databaseTypeHelper;
        this.overlay = overlay;
        this.listener = listener;
        AsyncXulLoader.loadXulFromUrl((String)(GWT.getModuleBaseURL() + "databasedialog.xul"), (String)(GWT.getModuleBaseURL() + "databasedialog"), (IXulLoaderCallback)new InternalCallback());
    }

    public GwtDatabaseDialog(DatabaseTypeHelper databaseTypeHelper, String overlay, String overlayResource, DatabaseDialogListener listener) {
        this.databaseTypeHelper = databaseTypeHelper;
        this.overlay = overlay;
        this.overlayResource = overlayResource;
        this.listener = listener;
        AsyncXulLoader.loadXulFromUrl((String)(GWT.getModuleBaseURL() + "databasedialog.xul"), (String)(GWT.getModuleBaseURL() + "databasedialog"), (IXulLoaderCallback)new InternalCallback());
    }

    public void show() {
        this.dialog.show();
    }

    public void setDatabaseConnection(final IDatabaseConnection conn) {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                GwtDatabaseDialog.this.dataHandler.setData(conn);
            }
        });
    }

    public boolean isDialogReady() {
        return this.dialog != null;
    }

    public IDatabaseConnection getDatabaseConnection() {
        return (IDatabaseConnection)this.dataHandler.getData();
    }

    private class InternalCallback
    implements IXulLoaderCallback {
        private InternalCallback() {
        }

        public void overlayLoaded() {
        }

        public void overlayRemoved() {
        }

        public void xulLoaded(final GwtXulRunner runner) {
            try {
                final GwtXulDomContainer container = (GwtXulDomContainer)runner.getXulDomContainers().get(0);
                GwtDatabaseDialog.this.messages.setMessageBundle((ResourceBundle)container.getResourceBundles().get(0));
                GwtDatabaseDialog.this.dataHandler.setMessages(GwtDatabaseDialog.this.messages);
                if (GwtDatabaseDialog.this.listener != null) {
                    GwtDatabaseDialog.this.dataHandler.setDatabaseDialogListener(GwtDatabaseDialog.this.listener);
                }
                GwtDatabaseDialog.this.dataHandler.setLaunch(new GwtLaunch());
                GwtDatabaseDialog.this.dataHandler.setDatabaseTypeHelper(GwtDatabaseDialog.this.databaseTypeHelper);
                GwtDatabaseDialog.this.dataHandler.setFragmentHandler(GwtDatabaseDialog.this.fragmentHandler);
                container.addEventHandler((XulEventHandler)GwtDatabaseDialog.this.dataHandler);
                GwtDatabaseDialog.this.fragmentHandler.setMessages(GwtDatabaseDialog.this.messages);
                GwtDatabaseDialog.this.fragmentHandler.setDatabaseTypeHelper(GwtDatabaseDialog.this.databaseTypeHelper);
                container.addEventHandler((XulEventHandler)GwtDatabaseDialog.this.fragmentHandler);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        GwtDatabaseDialog.this.fragmentHandler.setDisableRefresh(true);
                        try {
                            runner.initialize();
                        }
                        catch (XulException e) {
                            e.printStackTrace();
                        }
                        GwtDatabaseDialog.this.fragmentHandler.setDisableRefresh(false);
                    }
                });
                if (GwtDatabaseDialog.this.overlay != null) {
                    final IXulLoaderCallback callback2 = new IXulLoaderCallback(){

                        public void overlayLoaded() {
                            GwtDatabaseDialog.this.dialog = (XulDialog)container.getDocumentRoot().getElementById("general-datasource-window");
                            if (GwtDatabaseDialog.this.listener != null) {
                                GwtDatabaseDialog.this.listener.onDialogReady();
                            }
                        }

                        public void overlayRemoved() {
                        }

                        public void xulLoaded(GwtXulRunner runner) {
                        }
                    };
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            AsyncXulLoader.loadOverlayFromUrl((String)GwtDatabaseDialog.this.overlay, (String)GwtDatabaseDialog.this.overlayResource, (GwtXulDomContainer)container, (IXulLoaderCallback)callback2);
                        }
                    });
                } else {
                    GwtDatabaseDialog.this.dialog = (XulDialog)container.getDocumentRoot().getElementById("general-datasource-window");
                    if (GwtDatabaseDialog.this.listener != null) {
                        GwtDatabaseDialog.this.listener.onDialogReady();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

