/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.database.event;

import java.io.InputStream;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.ui.database.Messages;
import org.pentaho.ui.database.event.DataHandler;
import org.pentaho.ui.database.event.IFragmentHandler;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class FragmentHandler
extends AbstractXulEventHandler
implements IFragmentHandler {
    private Messages messages = new Messages();
    private XulListbox connectionBox;
    private XulListbox accessBox;
    private DatabaseTypeHelper databaseTypeHelper;
    private String packagePath = "org/pentaho/ui/database/resources/";
    boolean disableRefresh = false;

    public String getName() {
        return "fragmentHandler";
    }

    public void setDatabaseTypeHelper(DatabaseTypeHelper databaseTypeHelper) {
        this.databaseTypeHelper = databaseTypeHelper;
    }

    private void loadDatabaseOptionsFragment(String fragmentUri) throws XulException {
        XulComponent groupElement = this.document.getElementById("database-options-box");
        XulComponent parentElement = groupElement.getParent();
        XulDomContainer fragmentContainer = null;
        try {
            fragmentContainer = this.xulDomContainer.loadFragment(fragmentUri, (Object)this.messages.getBundle());
            XulComponent newGroup = fragmentContainer.getDocumentRoot().getElementById("database-options-box");
            parentElement.replaceChild(groupElement, newGroup);
        }
        catch (XulException e) {
            e.printStackTrace();
            throw e;
        }
        if (fragmentContainer == null) {
            return;
        }
    }

    @Bindable
    public void refreshOptions() {
        this.refreshOptionsWithCallback(null);
    }

    @Override
    public void refreshOptionsWithCallback(IFragmentHandler.Callback callback) {
        int port;
        DatabaseAccessType access;
        if (this.disableRefresh) {
            return;
        }
        this.connectionBox = (XulListbox)this.document.getElementById("connection-type-list");
        this.accessBox = (XulListbox)this.document.getElementById("access-type-list");
        String connectionKey = (String)this.connectionBox.getSelectedItem();
        IDatabaseType database = this.databaseTypeHelper.getDatabaseTypeByName(connectionKey);
        String accessKey = (String)this.accessBox.getSelectedItem();
        if (accessKey == null) {
            this.accessBox.setSelectedIndex(0);
            accessKey = (String)this.accessBox.getSelectedItem();
        }
        if ((access = DatabaseAccessType.getAccessTypeByName((String)accessKey)) == null) {
            return;
        }
        String fragment = null;
        DataHandler dataHandler = null;
        try {
            dataHandler = (DataHandler)this.xulDomContainer.getEventHandler("dataHandler");
            dataHandler.pushCache();
        }
        catch (XulException xulException) {
            // empty catch block
        }
        switch (access) {
            case JNDI: {
                fragment = this.getFragment(database, "_jndi.xul", "common_jndi.xul");
                break;
            }
            case NATIVE: {
                fragment = this.getFragment(database, "_native.xul", "common_native.xul");
                break;
            }
            case OCI: {
                fragment = this.getFragment(database, "_oci.xul", "common_native.xul");
                break;
            }
            case ODBC: {
                fragment = this.getFragment(database, "_odbc.xul", "common_odbc.xul");
                break;
            }
            case PLUGIN: {
                fragment = this.getFragment(database, "_plugin.xul", "common_native.xul");
            }
        }
        try {
            this.loadDatabaseOptionsFragment(fragment.toLowerCase());
        }
        catch (XulException e) {
            this.showMessage(this.messages.getString("FragmentHandler.USER.CANT_LOAD_OPTIONS", database.getName()));
        }
        XulTextbox portBox = (XulTextbox)this.document.getElementById("port-number-text");
        if (portBox != null && (port = database.getDefaultDatabasePort()) > 0) {
            portBox.setValue(Integer.toString(port));
        }
        if (dataHandler != null) {
            dataHandler.popCache();
        }
        if (callback != null) {
            callback.callback();
        }
    }

    private String getFragment(IDatabaseType database, String extension, String defaultFragment) {
        String fragment = this.packagePath.concat(database.getShortName()).concat(extension);
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(fragment.toLowerCase());
        if (in == null) {
            fragment = this.packagePath.concat(defaultFragment);
        }
        return fragment;
    }

    public Object getData() {
        return null;
    }

    public void setData(Object arg0) {
    }

    private void showMessage(String message) {
        try {
            XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
            box.setMessage(message);
            box.open();
        }
        catch (XulException e) {
            System.out.println("Error creating messagebox " + e.getMessage());
        }
    }

    @Override
    public void setDisableRefresh(boolean disableRefresh) {
        this.disableRefresh = disableRefresh;
    }

    @Override
    public boolean isRefreshDisabled() {
        return this.disableRefresh;
    }
}

